<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tomasdatahaus StructType
 * @subpackage Structs
 */
class Tomasdatahaus extends AbstractStructBase
{
    /**
     * The isBuchbar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBuchbar;
    /**
     * The isAlternative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAlternative;
    /**
     * The von
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $von;
    /**
     * The bis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bis;
    /**
     * The minpreis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minpreis;
    /**
     * The verpflegung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verpflegung;
    /**
     * The personen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personen;
    /**
     * The tbookingurl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tbookingurl;
    /**
     * Constructor method for tomasdatahaus
     * @uses Tomasdatahaus::setIsBuchbar()
     * @uses Tomasdatahaus::setIsAlternative()
     * @uses Tomasdatahaus::setVon()
     * @uses Tomasdatahaus::setBis()
     * @uses Tomasdatahaus::setMinpreis()
     * @uses Tomasdatahaus::setVerpflegung()
     * @uses Tomasdatahaus::setPersonen()
     * @uses Tomasdatahaus::setTbookingurl()
     * @param bool $isBuchbar
     * @param bool $isAlternative
     * @param string $von
     * @param string $bis
     * @param string $minpreis
     * @param string $verpflegung
     * @param int $personen
     * @param string $tbookingurl
     */
    public function __construct($isBuchbar = null, $isAlternative = null, $von = null, $bis = null, $minpreis = null, $verpflegung = null, $personen = null, $tbookingurl = null)
    {
        $this
            ->setIsBuchbar($isBuchbar)
            ->setIsAlternative($isAlternative)
            ->setVon($von)
            ->setBis($bis)
            ->setMinpreis($minpreis)
            ->setVerpflegung($verpflegung)
            ->setPersonen($personen)
            ->setTbookingurl($tbookingurl);
    }
    /**
     * Get isBuchbar value
     * @return bool|null
     */
    public function getIsBuchbar()
    {
        return $this->isBuchbar;
    }
    /**
     * Set isBuchbar value
     * @param bool $isBuchbar
     * @return \StructType\Tomasdatahaus
     */
    public function setIsBuchbar($isBuchbar = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBuchbar) && !is_bool($isBuchbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBuchbar, true), gettype($isBuchbar)), __LINE__);
        }
        $this->isBuchbar = $isBuchbar;
        return $this;
    }
    /**
     * Get isAlternative value
     * @return bool|null
     */
    public function getIsAlternative()
    {
        return $this->isAlternative;
    }
    /**
     * Set isAlternative value
     * @param bool $isAlternative
     * @return \StructType\Tomasdatahaus
     */
    public function setIsAlternative($isAlternative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternative) && !is_bool($isAlternative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternative, true), gettype($isAlternative)), __LINE__);
        }
        $this->isAlternative = $isAlternative;
        return $this;
    }
    /**
     * Get von value
     * @return string|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \StructType\Tomasdatahaus
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \StructType\Tomasdatahaus
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get minpreis value
     * @return string|null
     */
    public function getMinpreis()
    {
        return $this->minpreis;
    }
    /**
     * Set minpreis value
     * @param string $minpreis
     * @return \StructType\Tomasdatahaus
     */
    public function setMinpreis($minpreis = null)
    {
        // validation for constraint: string
        if (!is_null($minpreis) && !is_string($minpreis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minpreis, true), gettype($minpreis)), __LINE__);
        }
        $this->minpreis = $minpreis;
        return $this;
    }
    /**
     * Get verpflegung value
     * @return string|null
     */
    public function getVerpflegung()
    {
        return $this->verpflegung;
    }
    /**
     * Set verpflegung value
     * @param string $verpflegung
     * @return \StructType\Tomasdatahaus
     */
    public function setVerpflegung($verpflegung = null)
    {
        // validation for constraint: string
        if (!is_null($verpflegung) && !is_string($verpflegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpflegung, true), gettype($verpflegung)), __LINE__);
        }
        $this->verpflegung = $verpflegung;
        return $this;
    }
    /**
     * Get personen value
     * @return int|null
     */
    public function getPersonen()
    {
        return $this->personen;
    }
    /**
     * Set personen value
     * @param int $personen
     * @return \StructType\Tomasdatahaus
     */
    public function setPersonen($personen = null)
    {
        // validation for constraint: int
        if (!is_null($personen) && !(is_int($personen) || ctype_digit($personen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personen, true), gettype($personen)), __LINE__);
        }
        $this->personen = $personen;
        return $this;
    }
    /**
     * Get tbookingurl value
     * @return string|null
     */
    public function getTbookingurl()
    {
        return $this->tbookingurl;
    }
    /**
     * Set tbookingurl value
     * @param string $tbookingurl
     * @return \StructType\Tomasdatahaus
     */
    public function setTbookingurl($tbookingurl = null)
    {
        // validation for constraint: string
        if (!is_null($tbookingurl) && !is_string($tbookingurl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbookingurl, true), gettype($tbookingurl)), __LINE__);
        }
        $this->tbookingurl = $tbookingurl;
        return $this;
    }
}
