<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sprachbezeichnung StructType
 * @subpackage Structs
 */
class Sprachbezeichnung extends AbstractStructBase
{
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * Constructor method for sprachbezeichnung
     * @uses Sprachbezeichnung::setSprache()
     * @uses Sprachbezeichnung::setBezeichnung()
     * @param string $sprache
     * @param string $bezeichnung
     */
    public function __construct($sprache = null, $bezeichnung = null)
    {
        $this
            ->setSprache($sprache)
            ->setBezeichnung($bezeichnung);
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Sprachbezeichnung
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Sprachbezeichnung
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
}
