<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for person StructType
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The anzahl
     * @var int
     */
    public $anzahl;
    /**
     * The typ
     * @var string
     */
    public $typ;
    /**
     * The alter
     * @var int
     */
    public $alter;
    /**
     * Constructor method for person
     * @uses Person::setAnzahl()
     * @uses Person::setTyp()
     * @uses Person::setAlter()
     * @param int $anzahl
     * @param string $typ
     * @param int $alter
     */
    public function __construct($anzahl = null, $typ = null, $alter = null)
    {
        $this
            ->setAnzahl($anzahl)
            ->setTyp($typ)
            ->setAlter($alter);
    }
    /**
     * Get anzahl value
     * @return int|null
     */
    public function getAnzahl()
    {
        return $this->anzahl;
    }
    /**
     * Set anzahl value
     * @param int $anzahl
     * @return \StructType\Person
     */
    public function setAnzahl($anzahl = null)
    {
        // validation for constraint: int
        if (!is_null($anzahl) && !(is_int($anzahl) || ctype_digit($anzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahl, true), gettype($anzahl)), __LINE__);
        }
        $this->anzahl = $anzahl;
        return $this;
    }
    /**
     * Get typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @uses \EnumType\Persontyp::valueIsValid()
     * @uses \EnumType\Persontyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typ
     * @return \StructType\Person
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Persontyp::valueIsValid($typ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Persontyp', is_array($typ) ? implode(', ', $typ) : var_export($typ, true), implode(', ', \EnumType\Persontyp::getValidValues())), __LINE__);
        }
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get alter value
     * @return int|null
     */
    public function getAlter()
    {
        return $this->alter;
    }
    /**
     * Set alter value
     * @param int $alter
     * @return \StructType\Person
     */
    public function setAlter($alter = null)
    {
        // validation for constraint: int
        if (!is_null($alter) && !(is_int($alter) || ctype_digit($alter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alter, true), gettype($alter)), __LINE__);
        }
        $this->alter = $alter;
        return $this;
    }
}
