<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pauschalentext StructType
 * @subpackage Structs
 */
class Pauschalentext extends AbstractStructBase
{
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The art
     * @var int
     */
    public $art;
    /**
     * The titel
     * @var string
     */
    public $titel;
    /**
     * The text
     * @var string
     */
    public $text;
    /**
     * The lastchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastchange;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * Constructor method for pauschalentext
     * @uses Pauschalentext::setPauid()
     * @uses Pauschalentext::setSprache()
     * @uses Pauschalentext::setArt()
     * @uses Pauschalentext::setTitel()
     * @uses Pauschalentext::setText()
     * @uses Pauschalentext::setLastchange()
     * @uses Pauschalentext::setStatus()
     * @param int $pauid
     * @param string $sprache
     * @param int $art
     * @param string $titel
     * @param string $text
     * @param string $lastchange
     * @param int $status
     */
    public function __construct($pauid = null, $sprache = null, $art = null, $titel = null, $text = null, $lastchange = null, $status = null)
    {
        $this
            ->setPauid($pauid)
            ->setSprache($sprache)
            ->setArt($art)
            ->setTitel($titel)
            ->setText($text)
            ->setLastchange($lastchange)
            ->setStatus($status);
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Pauschalentext
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Pauschalentext
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get art value
     * @return int|null
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param int $art
     * @return \StructType\Pauschalentext
     */
    public function setArt($art = null)
    {
        // validation for constraint: int
        if (!is_null($art) && !(is_int($art) || ctype_digit($art))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\Pauschalentext
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Pauschalentext
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Pauschalentext
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Pauschalentext
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
