<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ortsteil StructType
 * @subpackage Structs
 */
class Ortsteil extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The ortsteilid
     * @var int
     */
    public $ortsteilid;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The lastchange
     * @var string
     */
    public $lastchange;
    /**
     * Constructor method for ortsteil
     * @uses Ortsteil::setOrtid()
     * @uses Ortsteil::setOrtsteilid()
     * @uses Ortsteil::setStatus()
     * @uses Ortsteil::setBezeichnung()
     * @uses Ortsteil::setLastchange()
     * @param int $ortid
     * @param int $ortsteilid
     * @param int $status
     * @param string $bezeichnung
     * @param string $lastchange
     */
    public function __construct($ortid = null, $ortsteilid = null, $status = null, $bezeichnung = null, $lastchange = null)
    {
        $this
            ->setOrtid($ortid)
            ->setOrtsteilid($ortsteilid)
            ->setStatus($status)
            ->setBezeichnung($bezeichnung)
            ->setLastchange($lastchange);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Ortsteil
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get ortsteilid value
     * @return int|null
     */
    public function getOrtsteilid()
    {
        return $this->ortsteilid;
    }
    /**
     * Set ortsteilid value
     * @param int $ortsteilid
     * @return \StructType\Ortsteil
     */
    public function setOrtsteilid($ortsteilid = null)
    {
        // validation for constraint: int
        if (!is_null($ortsteilid) && !(is_int($ortsteilid) || ctype_digit($ortsteilid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortsteilid, true), gettype($ortsteilid)), __LINE__);
        }
        $this->ortsteilid = $ortsteilid;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Ortsteil
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Ortsteil
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Ortsteil
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
}
