<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The hashvalue
     * @var string
     */
    public $hashvalue;
    /**
     * The datevalue
     * @var string
     */
    public $datevalue;
    /**
     * Constructor method for login
     * @uses Login::setUsername()
     * @uses Login::setHashvalue()
     * @uses Login::setDatevalue()
     * @param string $username
     * @param string $hashvalue
     * @param string $datevalue
     */
    public function __construct($username = null, $hashvalue = null, $datevalue = null)
    {
        $this
            ->setUsername($username)
            ->setHashvalue($hashvalue)
            ->setDatevalue($datevalue);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\Login
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get hashvalue value
     * @return string|null
     */
    public function getHashvalue()
    {
        return $this->hashvalue;
    }
    /**
     * Set hashvalue value
     * @param string $hashvalue
     * @return \StructType\Login
     */
    public function setHashvalue($hashvalue = null)
    {
        // validation for constraint: string
        if (!is_null($hashvalue) && !is_string($hashvalue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashvalue, true), gettype($hashvalue)), __LINE__);
        }
        $this->hashvalue = $hashvalue;
        return $this;
    }
    /**
     * Get datevalue value
     * @return string|null
     */
    public function getDatevalue()
    {
        return $this->datevalue;
    }
    /**
     * Set datevalue value
     * @param string $datevalue
     * @return \StructType\Login
     */
    public function setDatevalue($datevalue = null)
    {
        // validation for constraint: string
        if (!is_null($datevalue) && !is_string($datevalue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datevalue, true), gettype($datevalue)), __LINE__);
        }
        $this->datevalue = $datevalue;
        return $this;
    }
}
