<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kurzone StructType
 * @subpackage Structs
 */
class Kurzone extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The kurzoneid
     * @var int
     */
    public $kurzoneid;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The lastchange
     * @var string
     */
    public $lastchange;
    /**
     * Constructor method for kurzone
     * @uses Kurzone::setOrtid()
     * @uses Kurzone::setKurzoneid()
     * @uses Kurzone::setStatus()
     * @uses Kurzone::setBezeichnung()
     * @uses Kurzone::setLastchange()
     * @param int $ortid
     * @param int $kurzoneid
     * @param int $status
     * @param string $bezeichnung
     * @param string $lastchange
     */
    public function __construct($ortid = null, $kurzoneid = null, $status = null, $bezeichnung = null, $lastchange = null)
    {
        $this
            ->setOrtid($ortid)
            ->setKurzoneid($kurzoneid)
            ->setStatus($status)
            ->setBezeichnung($bezeichnung)
            ->setLastchange($lastchange);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Kurzone
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get kurzoneid value
     * @return int|null
     */
    public function getKurzoneid()
    {
        return $this->kurzoneid;
    }
    /**
     * Set kurzoneid value
     * @param int $kurzoneid
     * @return \StructType\Kurzone
     */
    public function setKurzoneid($kurzoneid = null)
    {
        // validation for constraint: int
        if (!is_null($kurzoneid) && !(is_int($kurzoneid) || ctype_digit($kurzoneid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kurzoneid, true), gettype($kurzoneid)), __LINE__);
        }
        $this->kurzoneid = $kurzoneid;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Kurzone
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Kurzone
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Kurzone
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
}
