<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hausmitkat StructType
 * @subpackage Structs
 */
class Hausmitkat extends AbstractStructBase
{
    /**
     * The haus
     * @var \StructType\Haus
     */
    public $haus;
    /**
     * The haustext
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Haustext[]
     */
    public $haustext;
    /**
     * The hausbilder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hausbild[]
     */
    public $hausbilder;
    /**
     * The kategoriemitpreis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kategoriemitpreis[]
     */
    public $kategoriemitpreis;
    /**
     * The saisondaten
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Saisonen
     */
    public $saisondaten;
    /**
     * The alterklassen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Altersklassen[]
     */
    public $alterklassen;
    /**
     * The portale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Portal[]
     */
    public $portale;
    /**
     * The adressen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hausadresse[]
     */
    public $adressen;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $errors;
    /**
     * Constructor method for hausmitkat
     * @uses Hausmitkat::setHaus()
     * @uses Hausmitkat::setHaustext()
     * @uses Hausmitkat::setHausbilder()
     * @uses Hausmitkat::setKategoriemitpreis()
     * @uses Hausmitkat::setSaisondaten()
     * @uses Hausmitkat::setAlterklassen()
     * @uses Hausmitkat::setPortale()
     * @uses Hausmitkat::setAdressen()
     * @uses Hausmitkat::setErrors()
     * @param \StructType\Haus $haus
     * @param \StructType\Haustext[] $haustext
     * @param \StructType\Hausbild[] $hausbilder
     * @param \StructType\Kategoriemitpreis[] $kategoriemitpreis
     * @param \StructType\Saisonen $saisondaten
     * @param \StructType\Altersklassen[] $alterklassen
     * @param \StructType\Portal[] $portale
     * @param \StructType\Hausadresse[] $adressen
     * @param string[] $errors
     */
    public function __construct(\StructType\Haus $haus = null, array $haustext = array(), array $hausbilder = array(), array $kategoriemitpreis = array(), \StructType\Saisonen $saisondaten = null, array $alterklassen = array(), array $portale = array(), array $adressen = array(), array $errors = array())
    {
        $this
            ->setHaus($haus)
            ->setHaustext($haustext)
            ->setHausbilder($hausbilder)
            ->setKategoriemitpreis($kategoriemitpreis)
            ->setSaisondaten($saisondaten)
            ->setAlterklassen($alterklassen)
            ->setPortale($portale)
            ->setAdressen($adressen)
            ->setErrors($errors);
    }
    /**
     * Get haus value
     * @return \StructType\Haus|null
     */
    public function getHaus()
    {
        return $this->haus;
    }
    /**
     * Set haus value
     * @param \StructType\Haus $haus
     * @return \StructType\Hausmitkat
     */
    public function setHaus(\StructType\Haus $haus = null)
    {
        $this->haus = $haus;
        return $this;
    }
    /**
     * Get haustext value
     * @return \StructType\Haustext[]|null
     */
    public function getHaustext()
    {
        return $this->haustext;
    }
    /**
     * This method is responsible for validating the values passed to the setHaustext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHaustext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHaustextForArrayConstraintsFromSetHaustext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatHaustextItem) {
            // validation for constraint: itemType
            if (!$hausmitkatHaustextItem instanceof \StructType\Haustext) {
                $invalidValues[] = is_object($hausmitkatHaustextItem) ? get_class($hausmitkatHaustextItem) : sprintf('%s(%s)', gettype($hausmitkatHaustextItem), var_export($hausmitkatHaustextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The haustext property can only contain items of type \StructType\Haustext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set haustext value
     * @throws \InvalidArgumentException
     * @param \StructType\Haustext[] $haustext
     * @return \StructType\Hausmitkat
     */
    public function setHaustext(array $haustext = array())
    {
        // validation for constraint: array
        if ('' !== ($haustextArrayErrorMessage = self::validateHaustextForArrayConstraintsFromSetHaustext($haustext))) {
            throw new \InvalidArgumentException($haustextArrayErrorMessage, __LINE__);
        }
        $this->haustext = $haustext;
        return $this;
    }
    /**
     * Add item to haustext value
     * @throws \InvalidArgumentException
     * @param \StructType\Haustext $item
     * @return \StructType\Hausmitkat
     */
    public function addToHaustext(\StructType\Haustext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Haustext) {
            throw new \InvalidArgumentException(sprintf('The haustext property can only contain items of type \StructType\Haustext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->haustext[] = $item;
        return $this;
    }
    /**
     * Get hausbilder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hausbild[]|null
     */
    public function getHausbilder()
    {
        return isset($this->hausbilder) ? $this->hausbilder : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHausbilder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHausbilder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHausbilderForArrayConstraintsFromSetHausbilder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatHausbilderItem) {
            // validation for constraint: itemType
            if (!$hausmitkatHausbilderItem instanceof \StructType\Hausbild) {
                $invalidValues[] = is_object($hausmitkatHausbilderItem) ? get_class($hausmitkatHausbilderItem) : sprintf('%s(%s)', gettype($hausmitkatHausbilderItem), var_export($hausmitkatHausbilderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hausbilder property can only contain items of type \StructType\Hausbild, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hausbilder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hausbild[] $hausbilder
     * @return \StructType\Hausmitkat
     */
    public function setHausbilder(array $hausbilder = array())
    {
        // validation for constraint: array
        if ('' !== ($hausbilderArrayErrorMessage = self::validateHausbilderForArrayConstraintsFromSetHausbilder($hausbilder))) {
            throw new \InvalidArgumentException($hausbilderArrayErrorMessage, __LINE__);
        }
        if (is_null($hausbilder) || (is_array($hausbilder) && empty($hausbilder))) {
            unset($this->hausbilder);
        } else {
            $this->hausbilder = $hausbilder;
        }
        return $this;
    }
    /**
     * Add item to hausbilder value
     * @throws \InvalidArgumentException
     * @param \StructType\Hausbild $item
     * @return \StructType\Hausmitkat
     */
    public function addToHausbilder(\StructType\Hausbild $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hausbild) {
            throw new \InvalidArgumentException(sprintf('The hausbilder property can only contain items of type \StructType\Hausbild, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hausbilder[] = $item;
        return $this;
    }
    /**
     * Get kategoriemitpreis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kategoriemitpreis[]|null
     */
    public function getKategoriemitpreis()
    {
        return isset($this->kategoriemitpreis) ? $this->kategoriemitpreis : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKategoriemitpreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategoriemitpreis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategoriemitpreisForArrayConstraintsFromSetKategoriemitpreis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatKategoriemitpreisItem) {
            // validation for constraint: itemType
            if (!$hausmitkatKategoriemitpreisItem instanceof \StructType\Kategoriemitpreis) {
                $invalidValues[] = is_object($hausmitkatKategoriemitpreisItem) ? get_class($hausmitkatKategoriemitpreisItem) : sprintf('%s(%s)', gettype($hausmitkatKategoriemitpreisItem), var_export($hausmitkatKategoriemitpreisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategoriemitpreis property can only contain items of type \StructType\Kategoriemitpreis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategoriemitpreis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kategoriemitpreis[] $kategoriemitpreis
     * @return \StructType\Hausmitkat
     */
    public function setKategoriemitpreis(array $kategoriemitpreis = array())
    {
        // validation for constraint: array
        if ('' !== ($kategoriemitpreisArrayErrorMessage = self::validateKategoriemitpreisForArrayConstraintsFromSetKategoriemitpreis($kategoriemitpreis))) {
            throw new \InvalidArgumentException($kategoriemitpreisArrayErrorMessage, __LINE__);
        }
        if (is_null($kategoriemitpreis) || (is_array($kategoriemitpreis) && empty($kategoriemitpreis))) {
            unset($this->kategoriemitpreis);
        } else {
            $this->kategoriemitpreis = $kategoriemitpreis;
        }
        return $this;
    }
    /**
     * Add item to kategoriemitpreis value
     * @throws \InvalidArgumentException
     * @param \StructType\Kategoriemitpreis $item
     * @return \StructType\Hausmitkat
     */
    public function addToKategoriemitpreis(\StructType\Kategoriemitpreis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kategoriemitpreis) {
            throw new \InvalidArgumentException(sprintf('The kategoriemitpreis property can only contain items of type \StructType\Kategoriemitpreis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategoriemitpreis[] = $item;
        return $this;
    }
    /**
     * Get saisondaten value
     * @return \StructType\Saisonen|null
     */
    public function getSaisondaten()
    {
        return $this->saisondaten;
    }
    /**
     * Set saisondaten value
     * @param \StructType\Saisonen $saisondaten
     * @return \StructType\Hausmitkat
     */
    public function setSaisondaten(\StructType\Saisonen $saisondaten = null)
    {
        $this->saisondaten = $saisondaten;
        return $this;
    }
    /**
     * Get alterklassen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Altersklassen[]|null
     */
    public function getAlterklassen()
    {
        return isset($this->alterklassen) ? $this->alterklassen : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAlterklassen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlterklassen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlterklassenForArrayConstraintsFromSetAlterklassen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatAlterklassenItem) {
            // validation for constraint: itemType
            if (!$hausmitkatAlterklassenItem instanceof \StructType\Altersklassen) {
                $invalidValues[] = is_object($hausmitkatAlterklassenItem) ? get_class($hausmitkatAlterklassenItem) : sprintf('%s(%s)', gettype($hausmitkatAlterklassenItem), var_export($hausmitkatAlterklassenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alterklassen property can only contain items of type \StructType\Altersklassen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alterklassen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Altersklassen[] $alterklassen
     * @return \StructType\Hausmitkat
     */
    public function setAlterklassen(array $alterklassen = array())
    {
        // validation for constraint: array
        if ('' !== ($alterklassenArrayErrorMessage = self::validateAlterklassenForArrayConstraintsFromSetAlterklassen($alterklassen))) {
            throw new \InvalidArgumentException($alterklassenArrayErrorMessage, __LINE__);
        }
        if (is_null($alterklassen) || (is_array($alterklassen) && empty($alterklassen))) {
            unset($this->alterklassen);
        } else {
            $this->alterklassen = $alterklassen;
        }
        return $this;
    }
    /**
     * Add item to alterklassen value
     * @throws \InvalidArgumentException
     * @param \StructType\Altersklassen $item
     * @return \StructType\Hausmitkat
     */
    public function addToAlterklassen(\StructType\Altersklassen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Altersklassen) {
            throw new \InvalidArgumentException(sprintf('The alterklassen property can only contain items of type \StructType\Altersklassen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->alterklassen[] = $item;
        return $this;
    }
    /**
     * Get portale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Portal[]|null
     */
    public function getPortale()
    {
        return isset($this->portale) ? $this->portale : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPortale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPortale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePortaleForArrayConstraintsFromSetPortale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatPortaleItem) {
            // validation for constraint: itemType
            if (!$hausmitkatPortaleItem instanceof \StructType\Portal) {
                $invalidValues[] = is_object($hausmitkatPortaleItem) ? get_class($hausmitkatPortaleItem) : sprintf('%s(%s)', gettype($hausmitkatPortaleItem), var_export($hausmitkatPortaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The portale property can only contain items of type \StructType\Portal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set portale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Portal[] $portale
     * @return \StructType\Hausmitkat
     */
    public function setPortale(array $portale = array())
    {
        // validation for constraint: array
        if ('' !== ($portaleArrayErrorMessage = self::validatePortaleForArrayConstraintsFromSetPortale($portale))) {
            throw new \InvalidArgumentException($portaleArrayErrorMessage, __LINE__);
        }
        if (is_null($portale) || (is_array($portale) && empty($portale))) {
            unset($this->portale);
        } else {
            $this->portale = $portale;
        }
        return $this;
    }
    /**
     * Add item to portale value
     * @throws \InvalidArgumentException
     * @param \StructType\Portal $item
     * @return \StructType\Hausmitkat
     */
    public function addToPortale(\StructType\Portal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Portal) {
            throw new \InvalidArgumentException(sprintf('The portale property can only contain items of type \StructType\Portal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->portale[] = $item;
        return $this;
    }
    /**
     * Get adressen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hausadresse[]|null
     */
    public function getAdressen()
    {
        return isset($this->adressen) ? $this->adressen : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdressen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdressen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdressenForArrayConstraintsFromSetAdressen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatAdressenItem) {
            // validation for constraint: itemType
            if (!$hausmitkatAdressenItem instanceof \StructType\Hausadresse) {
                $invalidValues[] = is_object($hausmitkatAdressenItem) ? get_class($hausmitkatAdressenItem) : sprintf('%s(%s)', gettype($hausmitkatAdressenItem), var_export($hausmitkatAdressenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The adressen property can only contain items of type \StructType\Hausadresse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set adressen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hausadresse[] $adressen
     * @return \StructType\Hausmitkat
     */
    public function setAdressen(array $adressen = array())
    {
        // validation for constraint: array
        if ('' !== ($adressenArrayErrorMessage = self::validateAdressenForArrayConstraintsFromSetAdressen($adressen))) {
            throw new \InvalidArgumentException($adressenArrayErrorMessage, __LINE__);
        }
        if (is_null($adressen) || (is_array($adressen) && empty($adressen))) {
            unset($this->adressen);
        } else {
            $this->adressen = $adressen;
        }
        return $this;
    }
    /**
     * Add item to adressen value
     * @throws \InvalidArgumentException
     * @param \StructType\Hausadresse $item
     * @return \StructType\Hausmitkat
     */
    public function addToAdressen(\StructType\Hausadresse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hausadresse) {
            throw new \InvalidArgumentException(sprintf('The adressen property can only contain items of type \StructType\Hausadresse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->adressen[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getErrors()
    {
        return isset($this->errors) ? $this->errors : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorsForArrayConstraintsFromSetErrors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausmitkatErrorsItem) {
            // validation for constraint: itemType
            if (!is_string($hausmitkatErrorsItem)) {
                $invalidValues[] = is_object($hausmitkatErrorsItem) ? get_class($hausmitkatErrorsItem) : sprintf('%s(%s)', gettype($hausmitkatErrorsItem), var_export($hausmitkatErrorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errors property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $errors
     * @return \StructType\Hausmitkat
     */
    public function setErrors(array $errors = array())
    {
        // validation for constraint: array
        if ('' !== ($errorsArrayErrorMessage = self::validateErrorsForArrayConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsArrayErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->errors);
        } else {
            $this->errors = $errors;
        }
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Hausmitkat
     */
    public function addToErrors($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
}
