<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hauseigenschaften StructType
 * @subpackage Structs
 */
class Hauseigenschaften extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The wert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wert;
    /**
     * Constructor method for hauseigenschaften
     * @uses Hauseigenschaften::setId()
     * @uses Hauseigenschaften::setWert()
     * @param int $id
     * @param string $wert
     */
    public function __construct($id = null, $wert = null)
    {
        $this
            ->setId($id)
            ->setWert($wert);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Hauseigenschaften
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get wert value
     * @return string|null
     */
    public function getWert()
    {
        return $this->wert;
    }
    /**
     * Set wert value
     * @param string $wert
     * @return \StructType\Hauseigenschaften
     */
    public function setWert($wert = null)
    {
        // validation for constraint: string
        if (!is_null($wert) && !is_string($wert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->wert = $wert;
        return $this;
    }
}
