<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingvolumen StructType
 * @subpackage Structs
 */
class Bookingvolumen extends AbstractStructBase
{
    /**
     * The anzahl
     * @var int
     */
    public $anzahl;
    /**
     * The wohneinheitenid
     * @var int
     */
    public $wohneinheitenid;
    /**
     * The person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Person[]
     */
    public $person;
    /**
     * The maxpreis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $maxpreis;
    /**
     * Constructor method for bookingvolumen
     * @uses Bookingvolumen::setAnzahl()
     * @uses Bookingvolumen::setWohneinheitenid()
     * @uses Bookingvolumen::setPerson()
     * @uses Bookingvolumen::setMaxpreis()
     * @param int $anzahl
     * @param int $wohneinheitenid
     * @param \StructType\Person[] $person
     * @param int[] $maxpreis
     */
    public function __construct($anzahl = null, $wohneinheitenid = null, array $person = array(), array $maxpreis = array())
    {
        $this
            ->setAnzahl($anzahl)
            ->setWohneinheitenid($wohneinheitenid)
            ->setPerson($person)
            ->setMaxpreis($maxpreis);
    }
    /**
     * Get anzahl value
     * @return int|null
     */
    public function getAnzahl()
    {
        return $this->anzahl;
    }
    /**
     * Set anzahl value
     * @param int $anzahl
     * @return \StructType\Bookingvolumen
     */
    public function setAnzahl($anzahl = null)
    {
        // validation for constraint: int
        if (!is_null($anzahl) && !(is_int($anzahl) || ctype_digit($anzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahl, true), gettype($anzahl)), __LINE__);
        }
        $this->anzahl = $anzahl;
        return $this;
    }
    /**
     * Get wohneinheitenid value
     * @return int|null
     */
    public function getWohneinheitenid()
    {
        return $this->wohneinheitenid;
    }
    /**
     * Set wohneinheitenid value
     * @param int $wohneinheitenid
     * @return \StructType\Bookingvolumen
     */
    public function setWohneinheitenid($wohneinheitenid = null)
    {
        // validation for constraint: int
        if (!is_null($wohneinheitenid) && !(is_int($wohneinheitenid) || ctype_digit($wohneinheitenid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wohneinheitenid, true), gettype($wohneinheitenid)), __LINE__);
        }
        $this->wohneinheitenid = $wohneinheitenid;
        return $this;
    }
    /**
     * Get person value
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonForArrayConstraintsFromSetPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingvolumenPersonItem) {
            // validation for constraint: itemType
            if (!$bookingvolumenPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($bookingvolumenPersonItem) ? get_class($bookingvolumenPersonItem) : sprintf('%s(%s)', gettype($bookingvolumenPersonItem), var_export($bookingvolumenPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person[] $person
     * @return \StructType\Bookingvolumen
     */
    public function setPerson(array $person = array())
    {
        // validation for constraint: array
        if ('' !== ($personArrayErrorMessage = self::validatePersonForArrayConstraintsFromSetPerson($person))) {
            throw new \InvalidArgumentException($personArrayErrorMessage, __LINE__);
        }
        $this->person = $person;
        return $this;
    }
    /**
     * Add item to person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \StructType\Bookingvolumen
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->person[] = $item;
        return $this;
    }
    /**
     * Get maxpreis value
     * @return int[]|null
     */
    public function getMaxpreis()
    {
        return $this->maxpreis;
    }
    /**
     * This method is responsible for validating the values passed to the setMaxpreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaxpreis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaxpreisForArrayConstraintsFromSetMaxpreis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingvolumenMaxpreisItem) {
            // validation for constraint: itemType
            if (!(is_int($bookingvolumenMaxpreisItem) || ctype_digit($bookingvolumenMaxpreisItem))) {
                $invalidValues[] = is_object($bookingvolumenMaxpreisItem) ? get_class($bookingvolumenMaxpreisItem) : sprintf('%s(%s)', gettype($bookingvolumenMaxpreisItem), var_export($bookingvolumenMaxpreisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The maxpreis property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set maxpreis value
     * @throws \InvalidArgumentException
     * @param int[] $maxpreis
     * @return \StructType\Bookingvolumen
     */
    public function setMaxpreis(array $maxpreis = array())
    {
        // validation for constraint: array
        if ('' !== ($maxpreisArrayErrorMessage = self::validateMaxpreisForArrayConstraintsFromSetMaxpreis($maxpreis))) {
            throw new \InvalidArgumentException($maxpreisArrayErrorMessage, __LINE__);
        }
        $this->maxpreis = $maxpreis;
        return $this;
    }
    /**
     * Add item to maxpreis value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Bookingvolumen
     */
    public function addToMaxpreis($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The maxpreis property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->maxpreis[] = $item;
        return $this;
    }
}
