<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anfrageadresse StructType
 * @subpackage Structs
 */
class Anfrageadresse extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The anfrageam
     * @var string
     */
    public $anfrageam;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The anredeid
     * @var int
     */
    public $anredeid;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The landid
     * @var int
     */
    public $landid;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The telefonp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefonp;
    /**
     * The mobil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobil;
    /**
     * The telefax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The bemerkung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bemerkung;
    /**
     * The sprache
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sprache;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The anfrageprospekt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anfrageprospekt[]
     */
    public $anfrageprospekt;
    /**
     * Constructor method for anfrageadresse
     * @uses Anfrageadresse::setOrtid()
     * @uses Anfrageadresse::setHausid()
     * @uses Anfrageadresse::setAnfrageam()
     * @uses Anfrageadresse::setNachname()
     * @uses Anfrageadresse::setVorname()
     * @uses Anfrageadresse::setAnredeid()
     * @uses Anfrageadresse::setStrasse()
     * @uses Anfrageadresse::setPlz()
     * @uses Anfrageadresse::setOrt()
     * @uses Anfrageadresse::setLandid()
     * @uses Anfrageadresse::setTelefon()
     * @uses Anfrageadresse::setTelefonp()
     * @uses Anfrageadresse::setMobil()
     * @uses Anfrageadresse::setTelefax()
     * @uses Anfrageadresse::setEmail()
     * @uses Anfrageadresse::setBemerkung()
     * @uses Anfrageadresse::setSprache()
     * @uses Anfrageadresse::setSource()
     * @uses Anfrageadresse::setAnfrageprospekt()
     * @param int $ortid
     * @param int $hausid
     * @param string $anfrageam
     * @param string $nachname
     * @param string $vorname
     * @param int $anredeid
     * @param string $strasse
     * @param string $plz
     * @param string $ort
     * @param int $landid
     * @param string $telefon
     * @param string $telefonp
     * @param string $mobil
     * @param string $telefax
     * @param string $email
     * @param string $bemerkung
     * @param string $sprache
     * @param string $source
     * @param \StructType\Anfrageprospekt[] $anfrageprospekt
     */
    public function __construct($ortid = null, $hausid = null, $anfrageam = null, $nachname = null, $vorname = null, $anredeid = null, $strasse = null, $plz = null, $ort = null, $landid = null, $telefon = null, $telefonp = null, $mobil = null, $telefax = null, $email = null, $bemerkung = null, $sprache = null, $source = null, array $anfrageprospekt = array())
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setAnfrageam($anfrageam)
            ->setNachname($nachname)
            ->setVorname($vorname)
            ->setAnredeid($anredeid)
            ->setStrasse($strasse)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setLandid($landid)
            ->setTelefon($telefon)
            ->setTelefonp($telefonp)
            ->setMobil($mobil)
            ->setTelefax($telefax)
            ->setEmail($email)
            ->setBemerkung($bemerkung)
            ->setSprache($sprache)
            ->setSource($source)
            ->setAnfrageprospekt($anfrageprospekt);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Anfrageadresse
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Anfrageadresse
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get anfrageam value
     * @return string|null
     */
    public function getAnfrageam()
    {
        return $this->anfrageam;
    }
    /**
     * Set anfrageam value
     * @param string $anfrageam
     * @return \StructType\Anfrageadresse
     */
    public function setAnfrageam($anfrageam = null)
    {
        // validation for constraint: string
        if (!is_null($anfrageam) && !is_string($anfrageam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anfrageam, true), gettype($anfrageam)), __LINE__);
        }
        $this->anfrageam = $anfrageam;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\Anfrageadresse
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Anfrageadresse
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \StructType\Anfrageadresse
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Anfrageadresse
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Anfrageadresse
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Anfrageadresse
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get landid value
     * @return int|null
     */
    public function getLandid()
    {
        return $this->landid;
    }
    /**
     * Set landid value
     * @param int $landid
     * @return \StructType\Anfrageadresse
     */
    public function setLandid($landid = null)
    {
        // validation for constraint: int
        if (!is_null($landid) && !(is_int($landid) || ctype_digit($landid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landid, true), gettype($landid)), __LINE__);
        }
        $this->landid = $landid;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Anfrageadresse
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get telefonp value
     * @return string|null
     */
    public function getTelefonp()
    {
        return $this->telefonp;
    }
    /**
     * Set telefonp value
     * @param string $telefonp
     * @return \StructType\Anfrageadresse
     */
    public function setTelefonp($telefonp = null)
    {
        // validation for constraint: string
        if (!is_null($telefonp) && !is_string($telefonp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonp, true), gettype($telefonp)), __LINE__);
        }
        $this->telefonp = $telefonp;
        return $this;
    }
    /**
     * Get mobil value
     * @return string|null
     */
    public function getMobil()
    {
        return $this->mobil;
    }
    /**
     * Set mobil value
     * @param string $mobil
     * @return \StructType\Anfrageadresse
     */
    public function setMobil($mobil = null)
    {
        // validation for constraint: string
        if (!is_null($mobil) && !is_string($mobil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobil, true), gettype($mobil)), __LINE__);
        }
        $this->mobil = $mobil;
        return $this;
    }
    /**
     * Get telefax value
     * @return string|null
     */
    public function getTelefax()
    {
        return $this->telefax;
    }
    /**
     * Set telefax value
     * @param string $telefax
     * @return \StructType\Anfrageadresse
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax, true), gettype($telefax)), __LINE__);
        }
        $this->telefax = $telefax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Anfrageadresse
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get bemerkung value
     * @return string|null
     */
    public function getBemerkung()
    {
        return $this->bemerkung;
    }
    /**
     * Set bemerkung value
     * @param string $bemerkung
     * @return \StructType\Anfrageadresse
     */
    public function setBemerkung($bemerkung = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkung) && !is_string($bemerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkung, true), gettype($bemerkung)), __LINE__);
        }
        $this->bemerkung = $bemerkung;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Anfrageadresse
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Anfrageadresse
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get anfrageprospekt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anfrageprospekt[]|null
     */
    public function getAnfrageprospekt()
    {
        return isset($this->anfrageprospekt) ? $this->anfrageprospekt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnfrageprospekt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnfrageprospekt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnfrageprospektForArrayConstraintsFromSetAnfrageprospekt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anfrageadresseAnfrageprospektItem) {
            // validation for constraint: itemType
            if (!$anfrageadresseAnfrageprospektItem instanceof \StructType\Anfrageprospekt) {
                $invalidValues[] = is_object($anfrageadresseAnfrageprospektItem) ? get_class($anfrageadresseAnfrageprospektItem) : sprintf('%s(%s)', gettype($anfrageadresseAnfrageprospektItem), var_export($anfrageadresseAnfrageprospektItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anfrageprospekt property can only contain items of type \StructType\Anfrageprospekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anfrageprospekt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anfrageprospekt[] $anfrageprospekt
     * @return \StructType\Anfrageadresse
     */
    public function setAnfrageprospekt(array $anfrageprospekt = array())
    {
        // validation for constraint: array
        if ('' !== ($anfrageprospektArrayErrorMessage = self::validateAnfrageprospektForArrayConstraintsFromSetAnfrageprospekt($anfrageprospekt))) {
            throw new \InvalidArgumentException($anfrageprospektArrayErrorMessage, __LINE__);
        }
        if (is_null($anfrageprospekt) || (is_array($anfrageprospekt) && empty($anfrageprospekt))) {
            unset($this->anfrageprospekt);
        } else {
            $this->anfrageprospekt = $anfrageprospekt;
        }
        return $this;
    }
    /**
     * Add item to anfrageprospekt value
     * @throws \InvalidArgumentException
     * @param \StructType\Anfrageprospekt $item
     * @return \StructType\Anfrageadresse
     */
    public function addToAnfrageprospekt(\StructType\Anfrageprospekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anfrageprospekt) {
            throw new \InvalidArgumentException(sprintf('The anfrageprospekt property can only contain items of type \StructType\Anfrageprospekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anfrageprospekt[] = $item;
        return $this;
    }
}
