<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anfrage StructType
 * @subpackage Structs
 */
class Anfrage extends AbstractStructBase
{
    /**
     * The anfrageid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anfrageid;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The katids
     * @var string
     */
    public $katids;
    /**
     * The anredeid
     * @var int
     */
    public $anredeid;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The landid
     * @var int
     */
    public $landid;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The telefax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The bemerkung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bemerkung;
    /**
     * The sent2email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sent2email;
    /**
     * The von
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $von;
    /**
     * The bis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $bis;
    /**
     * The anztage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anztage;
    /**
     * The verpflegung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verpflegung;
    /**
     * The anzerw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anzerw;
    /**
     * The anzkinder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anzkinder;
    /**
     * The alterkinder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $alterkinder;
    /**
     * The absendebeleg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $absendebeleg;
    /**
     * The ci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ci;
    /**
     * The zusatzinfoid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $zusatzinfoid;
    /**
     * Constructor method for anfrage
     * @uses Anfrage::setAnfrageid()
     * @uses Anfrage::setOrtid()
     * @uses Anfrage::setHausid()
     * @uses Anfrage::setKatids()
     * @uses Anfrage::setAnredeid()
     * @uses Anfrage::setVorname()
     * @uses Anfrage::setNachname()
     * @uses Anfrage::setStrasse()
     * @uses Anfrage::setPlz()
     * @uses Anfrage::setOrt()
     * @uses Anfrage::setLandid()
     * @uses Anfrage::setTelefon()
     * @uses Anfrage::setTelefax()
     * @uses Anfrage::setEmail()
     * @uses Anfrage::setBemerkung()
     * @uses Anfrage::setSent2email()
     * @uses Anfrage::setVon()
     * @uses Anfrage::setBis()
     * @uses Anfrage::setAnztage()
     * @uses Anfrage::setVerpflegung()
     * @uses Anfrage::setAnzerw()
     * @uses Anfrage::setAnzkinder()
     * @uses Anfrage::setAlterkinder()
     * @uses Anfrage::setAbsendebeleg()
     * @uses Anfrage::setCi()
     * @uses Anfrage::setZusatzinfoid()
     * @param int $anfrageid
     * @param int $ortid
     * @param int $hausid
     * @param string $katids
     * @param int $anredeid
     * @param string $vorname
     * @param string $nachname
     * @param string $strasse
     * @param string $plz
     * @param string $ort
     * @param int $landid
     * @param string $telefon
     * @param string $telefax
     * @param string $email
     * @param string $bemerkung
     * @param string $sent2email
     * @param anySimpleType $von
     * @param anySimpleType $bis
     * @param int $anztage
     * @param string $verpflegung
     * @param int $anzerw
     * @param int $anzkinder
     * @param string $alterkinder
     * @param int $absendebeleg
     * @param string $ci
     * @param int[] $zusatzinfoid
     */
    public function __construct($anfrageid = null, $ortid = null, $hausid = null, $katids = null, $anredeid = null, $vorname = null, $nachname = null, $strasse = null, $plz = null, $ort = null, $landid = null, $telefon = null, $telefax = null, $email = null, $bemerkung = null, $sent2email = null, anySimpleType $von = null, anySimpleType $bis = null, $anztage = null, $verpflegung = null, $anzerw = null, $anzkinder = null, $alterkinder = null, $absendebeleg = null, $ci = null, array $zusatzinfoid = array())
    {
        $this
            ->setAnfrageid($anfrageid)
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setKatids($katids)
            ->setAnredeid($anredeid)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setStrasse($strasse)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setLandid($landid)
            ->setTelefon($telefon)
            ->setTelefax($telefax)
            ->setEmail($email)
            ->setBemerkung($bemerkung)
            ->setSent2email($sent2email)
            ->setVon($von)
            ->setBis($bis)
            ->setAnztage($anztage)
            ->setVerpflegung($verpflegung)
            ->setAnzerw($anzerw)
            ->setAnzkinder($anzkinder)
            ->setAlterkinder($alterkinder)
            ->setAbsendebeleg($absendebeleg)
            ->setCi($ci)
            ->setZusatzinfoid($zusatzinfoid);
    }
    /**
     * Get anfrageid value
     * @return int|null
     */
    public function getAnfrageid()
    {
        return $this->anfrageid;
    }
    /**
     * Set anfrageid value
     * @param int $anfrageid
     * @return \StructType\Anfrage
     */
    public function setAnfrageid($anfrageid = null)
    {
        // validation for constraint: int
        if (!is_null($anfrageid) && !(is_int($anfrageid) || ctype_digit($anfrageid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anfrageid, true), gettype($anfrageid)), __LINE__);
        }
        $this->anfrageid = $anfrageid;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Anfrage
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Anfrage
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get katids value
     * @return string|null
     */
    public function getKatids()
    {
        return $this->katids;
    }
    /**
     * Set katids value
     * @param string $katids
     * @return \StructType\Anfrage
     */
    public function setKatids($katids = null)
    {
        // validation for constraint: string
        if (!is_null($katids) && !is_string($katids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($katids, true), gettype($katids)), __LINE__);
        }
        $this->katids = $katids;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \StructType\Anfrage
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Anfrage
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\Anfrage
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Anfrage
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Anfrage
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Anfrage
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get landid value
     * @return int|null
     */
    public function getLandid()
    {
        return $this->landid;
    }
    /**
     * Set landid value
     * @param int $landid
     * @return \StructType\Anfrage
     */
    public function setLandid($landid = null)
    {
        // validation for constraint: int
        if (!is_null($landid) && !(is_int($landid) || ctype_digit($landid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landid, true), gettype($landid)), __LINE__);
        }
        $this->landid = $landid;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Anfrage
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get telefax value
     * @return string|null
     */
    public function getTelefax()
    {
        return $this->telefax;
    }
    /**
     * Set telefax value
     * @param string $telefax
     * @return \StructType\Anfrage
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax, true), gettype($telefax)), __LINE__);
        }
        $this->telefax = $telefax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Anfrage
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get bemerkung value
     * @return string|null
     */
    public function getBemerkung()
    {
        return $this->bemerkung;
    }
    /**
     * Set bemerkung value
     * @param string $bemerkung
     * @return \StructType\Anfrage
     */
    public function setBemerkung($bemerkung = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkung) && !is_string($bemerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkung, true), gettype($bemerkung)), __LINE__);
        }
        $this->bemerkung = $bemerkung;
        return $this;
    }
    /**
     * Get sent2email value
     * @return string|null
     */
    public function getSent2email()
    {
        return $this->sent2email;
    }
    /**
     * Set sent2email value
     * @param string $sent2email
     * @return \StructType\Anfrage
     */
    public function setSent2email($sent2email = null)
    {
        // validation for constraint: string
        if (!is_null($sent2email) && !is_string($sent2email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sent2email, true), gettype($sent2email)), __LINE__);
        }
        $this->sent2email = $sent2email;
        return $this;
    }
    /**
     * Get von value
     * @return anySimpleType|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param anySimpleType $von
     * @return \StructType\Anfrage
     */
    public function setVon(anySimpleType $von = null)
    {
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return anySimpleType|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param anySimpleType $bis
     * @return \StructType\Anfrage
     */
    public function setBis(anySimpleType $bis = null)
    {
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get anztage value
     * @return int|null
     */
    public function getAnztage()
    {
        return $this->anztage;
    }
    /**
     * Set anztage value
     * @param int $anztage
     * @return \StructType\Anfrage
     */
    public function setAnztage($anztage = null)
    {
        // validation for constraint: int
        if (!is_null($anztage) && !(is_int($anztage) || ctype_digit($anztage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anztage, true), gettype($anztage)), __LINE__);
        }
        $this->anztage = $anztage;
        return $this;
    }
    /**
     * Get verpflegung value
     * @return string|null
     */
    public function getVerpflegung()
    {
        return $this->verpflegung;
    }
    /**
     * Set verpflegung value
     * @param string $verpflegung
     * @return \StructType\Anfrage
     */
    public function setVerpflegung($verpflegung = null)
    {
        // validation for constraint: string
        if (!is_null($verpflegung) && !is_string($verpflegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpflegung, true), gettype($verpflegung)), __LINE__);
        }
        $this->verpflegung = $verpflegung;
        return $this;
    }
    /**
     * Get anzerw value
     * @return int|null
     */
    public function getAnzerw()
    {
        return $this->anzerw;
    }
    /**
     * Set anzerw value
     * @param int $anzerw
     * @return \StructType\Anfrage
     */
    public function setAnzerw($anzerw = null)
    {
        // validation for constraint: int
        if (!is_null($anzerw) && !(is_int($anzerw) || ctype_digit($anzerw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzerw, true), gettype($anzerw)), __LINE__);
        }
        $this->anzerw = $anzerw;
        return $this;
    }
    /**
     * Get anzkinder value
     * @return int|null
     */
    public function getAnzkinder()
    {
        return $this->anzkinder;
    }
    /**
     * Set anzkinder value
     * @param int $anzkinder
     * @return \StructType\Anfrage
     */
    public function setAnzkinder($anzkinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzkinder) && !(is_int($anzkinder) || ctype_digit($anzkinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkinder, true), gettype($anzkinder)), __LINE__);
        }
        $this->anzkinder = $anzkinder;
        return $this;
    }
    /**
     * Get alterkinder value
     * @return string|null
     */
    public function getAlterkinder()
    {
        return $this->alterkinder;
    }
    /**
     * Set alterkinder value
     * @param string $alterkinder
     * @return \StructType\Anfrage
     */
    public function setAlterkinder($alterkinder = null)
    {
        // validation for constraint: string
        if (!is_null($alterkinder) && !is_string($alterkinder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alterkinder, true), gettype($alterkinder)), __LINE__);
        }
        $this->alterkinder = $alterkinder;
        return $this;
    }
    /**
     * Get absendebeleg value
     * @return int|null
     */
    public function getAbsendebeleg()
    {
        return $this->absendebeleg;
    }
    /**
     * Set absendebeleg value
     * @param int $absendebeleg
     * @return \StructType\Anfrage
     */
    public function setAbsendebeleg($absendebeleg = null)
    {
        // validation for constraint: int
        if (!is_null($absendebeleg) && !(is_int($absendebeleg) || ctype_digit($absendebeleg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($absendebeleg, true), gettype($absendebeleg)), __LINE__);
        }
        $this->absendebeleg = $absendebeleg;
        return $this;
    }
    /**
     * Get ci value
     * @return string|null
     */
    public function getCi()
    {
        return $this->ci;
    }
    /**
     * Set ci value
     * @param string $ci
     * @return \StructType\Anfrage
     */
    public function setCi($ci = null)
    {
        // validation for constraint: string
        if (!is_null($ci) && !is_string($ci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ci, true), gettype($ci)), __LINE__);
        }
        $this->ci = $ci;
        return $this;
    }
    /**
     * Get zusatzinfoid value
     * @return int[]|null
     */
    public function getZusatzinfoid()
    {
        return $this->zusatzinfoid;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzinfoid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzinfoid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzinfoidForArrayConstraintsFromSetZusatzinfoid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anfrageZusatzinfoidItem) {
            // validation for constraint: itemType
            if (!(is_int($anfrageZusatzinfoidItem) || ctype_digit($anfrageZusatzinfoidItem))) {
                $invalidValues[] = is_object($anfrageZusatzinfoidItem) ? get_class($anfrageZusatzinfoidItem) : sprintf('%s(%s)', gettype($anfrageZusatzinfoidItem), var_export($anfrageZusatzinfoidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzinfoid property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzinfoid value
     * @throws \InvalidArgumentException
     * @param int[] $zusatzinfoid
     * @return \StructType\Anfrage
     */
    public function setZusatzinfoid(array $zusatzinfoid = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzinfoidArrayErrorMessage = self::validateZusatzinfoidForArrayConstraintsFromSetZusatzinfoid($zusatzinfoid))) {
            throw new \InvalidArgumentException($zusatzinfoidArrayErrorMessage, __LINE__);
        }
        $this->zusatzinfoid = $zusatzinfoid;
        return $this;
    }
    /**
     * Add item to zusatzinfoid value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Anfrage
     */
    public function addToZusatzinfoid($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The zusatzinfoid property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzinfoid[] = $item;
        return $this;
    }
}
