<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for altersklassen StructType
 * @subpackage Structs
 */
class Altersklassen extends AbstractStructBase
{
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The vonalter
     * @var int
     */
    public $vonalter;
    /**
     * The bisalter
     * @var int
     */
    public $bisalter;
    /**
     * Constructor method for altersklassen
     * @uses Altersklassen::setBezeichnung()
     * @uses Altersklassen::setVonalter()
     * @uses Altersklassen::setBisalter()
     * @param string $bezeichnung
     * @param int $vonalter
     * @param int $bisalter
     */
    public function __construct($bezeichnung = null, $vonalter = null, $bisalter = null)
    {
        $this
            ->setBezeichnung($bezeichnung)
            ->setVonalter($vonalter)
            ->setBisalter($bisalter);
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Altersklassen
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get vonalter value
     * @return int|null
     */
    public function getVonalter()
    {
        return $this->vonalter;
    }
    /**
     * Set vonalter value
     * @param int $vonalter
     * @return \StructType\Altersklassen
     */
    public function setVonalter($vonalter = null)
    {
        // validation for constraint: int
        if (!is_null($vonalter) && !(is_int($vonalter) || ctype_digit($vonalter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vonalter, true), gettype($vonalter)), __LINE__);
        }
        $this->vonalter = $vonalter;
        return $this;
    }
    /**
     * Get bisalter value
     * @return int|null
     */
    public function getBisalter()
    {
        return $this->bisalter;
    }
    /**
     * Set bisalter value
     * @param int $bisalter
     * @return \StructType\Altersklassen
     */
    public function setBisalter($bisalter = null)
    {
        // validation for constraint: int
        if (!is_null($bisalter) && !(is_int($bisalter) || ctype_digit($bisalter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bisalter, true), gettype($bisalter)), __LINE__);
        }
        $this->bisalter = $bisalter;
        return $this;
    }
}
