<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tarifdata StructType
 * @subpackage Structs
 */
class Tarifdata extends AbstractStructBase
{
    /**
     * The tarifpos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Tarifpos[]
     */
    public $tarifpos;
    /**
     * Constructor method for tarifdata
     * @uses Tarifdata::setTarifpos()
     * @param \StructType\Tarifpos[] $tarifpos
     */
    public function __construct(array $tarifpos = array())
    {
        $this
            ->setTarifpos($tarifpos);
    }
    /**
     * Get tarifpos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Tarifpos[]|null
     */
    public function getTarifpos()
    {
        return isset($this->tarifpos) ? $this->tarifpos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTarifpos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarifpos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTarifposForArrayConstraintsFromSetTarifpos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tarifdataTarifposItem) {
            // validation for constraint: itemType
            if (!$tarifdataTarifposItem instanceof \StructType\Tarifpos) {
                $invalidValues[] = is_object($tarifdataTarifposItem) ? get_class($tarifdataTarifposItem) : sprintf('%s(%s)', gettype($tarifdataTarifposItem), var_export($tarifdataTarifposItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tarifpos property can only contain items of type \StructType\Tarifpos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tarifpos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tarifpos[] $tarifpos
     * @return \StructType\Tarifdata
     */
    public function setTarifpos(array $tarifpos = array())
    {
        // validation for constraint: array
        if ('' !== ($tarifposArrayErrorMessage = self::validateTarifposForArrayConstraintsFromSetTarifpos($tarifpos))) {
            throw new \InvalidArgumentException($tarifposArrayErrorMessage, __LINE__);
        }
        if (is_null($tarifpos) || (is_array($tarifpos) && empty($tarifpos))) {
            unset($this->tarifpos);
        } else {
            $this->tarifpos = $tarifpos;
        }
        return $this;
    }
    /**
     * Add item to tarifpos value
     * @throws \InvalidArgumentException
     * @param \StructType\Tarifpos $item
     * @return \StructType\Tarifdata
     */
    public function addToTarifpos(\StructType\Tarifpos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tarifpos) {
            throw new \InvalidArgumentException(sprintf('The tarifpos property can only contain items of type \StructType\Tarifpos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tarifpos[] = $item;
        return $this;
    }
}
