<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchresult StructType
 * @subpackage Structs
 */
class Searchresult extends AbstractStructBase
{
    /**
     * The searchrequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Searchrequest
     */
    public $searchrequest;
    /**
     * The searchresultelement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Searchresultelement[]
     */
    public $searchresultelement;
    /**
     * The searchtime
     * @var int
     */
    public $searchtime;
    /**
     * The aod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $aod;
    /**
     * Constructor method for searchresult
     * @uses Searchresult::setSearchrequest()
     * @uses Searchresult::setSearchresultelement()
     * @uses Searchresult::setSearchtime()
     * @uses Searchresult::setAod()
     * @param \StructType\Searchrequest $searchrequest
     * @param \StructType\Searchresultelement[] $searchresultelement
     * @param int $searchtime
     * @param string[] $aod
     */
    public function __construct(\StructType\Searchrequest $searchrequest = null, array $searchresultelement = array(), $searchtime = null, array $aod = array())
    {
        $this
            ->setSearchrequest($searchrequest)
            ->setSearchresultelement($searchresultelement)
            ->setSearchtime($searchtime)
            ->setAod($aod);
    }
    /**
     * Get searchrequest value
     * @return \StructType\Searchrequest|null
     */
    public function getSearchrequest()
    {
        return $this->searchrequest;
    }
    /**
     * Set searchrequest value
     * @param \StructType\Searchrequest $searchrequest
     * @return \StructType\Searchresult
     */
    public function setSearchrequest(\StructType\Searchrequest $searchrequest = null)
    {
        $this->searchrequest = $searchrequest;
        return $this;
    }
    /**
     * Get searchresultelement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Searchresultelement[]|null
     */
    public function getSearchresultelement()
    {
        return isset($this->searchresultelement) ? $this->searchresultelement : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchresultelement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchresultelement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchresultelementForArrayConstraintsFromSetSearchresultelement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultSearchresultelementItem) {
            // validation for constraint: itemType
            if (!$searchresultSearchresultelementItem instanceof \StructType\Searchresultelement) {
                $invalidValues[] = is_object($searchresultSearchresultelementItem) ? get_class($searchresultSearchresultelementItem) : sprintf('%s(%s)', gettype($searchresultSearchresultelementItem), var_export($searchresultSearchresultelementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The searchresultelement property can only contain items of type \StructType\Searchresultelement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set searchresultelement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultelement[] $searchresultelement
     * @return \StructType\Searchresult
     */
    public function setSearchresultelement(array $searchresultelement = array())
    {
        // validation for constraint: array
        if ('' !== ($searchresultelementArrayErrorMessage = self::validateSearchresultelementForArrayConstraintsFromSetSearchresultelement($searchresultelement))) {
            throw new \InvalidArgumentException($searchresultelementArrayErrorMessage, __LINE__);
        }
        if (is_null($searchresultelement) || (is_array($searchresultelement) && empty($searchresultelement))) {
            unset($this->searchresultelement);
        } else {
            $this->searchresultelement = $searchresultelement;
        }
        return $this;
    }
    /**
     * Add item to searchresultelement value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultelement $item
     * @return \StructType\Searchresult
     */
    public function addToSearchresultelement(\StructType\Searchresultelement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Searchresultelement) {
            throw new \InvalidArgumentException(sprintf('The searchresultelement property can only contain items of type \StructType\Searchresultelement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->searchresultelement[] = $item;
        return $this;
    }
    /**
     * Get searchtime value
     * @return int|null
     */
    public function getSearchtime()
    {
        return $this->searchtime;
    }
    /**
     * Set searchtime value
     * @param int $searchtime
     * @return \StructType\Searchresult
     */
    public function setSearchtime($searchtime = null)
    {
        // validation for constraint: int
        if (!is_null($searchtime) && !(is_int($searchtime) || ctype_digit($searchtime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchtime, true), gettype($searchtime)), __LINE__);
        }
        $this->searchtime = $searchtime;
        return $this;
    }
    /**
     * Get aod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAod()
    {
        return isset($this->aod) ? $this->aod : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAodForArrayConstraintsFromSetAod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultAodItem) {
            // validation for constraint: itemType
            if (!is_string($searchresultAodItem)) {
                $invalidValues[] = is_object($searchresultAodItem) ? get_class($searchresultAodItem) : sprintf('%s(%s)', gettype($searchresultAodItem), var_export($searchresultAodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aod property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $aod
     * @return \StructType\Searchresult
     */
    public function setAod(array $aod = array())
    {
        // validation for constraint: array
        if ('' !== ($aodArrayErrorMessage = self::validateAodForArrayConstraintsFromSetAod($aod))) {
            throw new \InvalidArgumentException($aodArrayErrorMessage, __LINE__);
        }
        if (is_null($aod) || (is_array($aod) && empty($aod))) {
            unset($this->aod);
        } else {
            $this->aod = $aod;
        }
        return $this;
    }
    /**
     * Add item to aod value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Searchresult
     */
    public function addToAod($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aod property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aod[] = $item;
        return $this;
    }
}
