<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchrequest StructType
 * @subpackage Structs
 */
class Searchrequest extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $hausid;
    /**
     * The von
     * @var string
     */
    public $von;
    /**
     * The bis
     * @var string
     */
    public $bis;
    /**
     * The vonString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vonString;
    /**
     * The bisString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bisString;
    /**
     * The uebernachtungen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $uebernachtungen;
    /**
     * The channelid
     * @var int
     */
    public $channelid;
    /**
     * The bookingvolumen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Bookingvolumen[]
     */
    public $bookingvolumen;
    /**
     * The sterne
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $sterne;
    /**
     * The hauskategorien
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $hauskategorien;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The anfrageteilbar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $anfrageteilbar;
    /**
     * The hauseigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bookingtags[]
     */
    public $hauseigenschaften;
    /**
     * The kateigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bookingtags[]
     */
    public $kateigenschaften;
    /**
     * The sortby
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sortby[]
     */
    public $sortby;
    /**
     * The einstellung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Einstellung[]
     */
    public $einstellung;
    /**
     * The restrict2hausname
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $restrict2hausname;
    /**
     * The wanttext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $wanttext;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $flags;
    /**
     * The bezirkids
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $bezirkids;
    /**
     * The kategorieid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $kategorieid;
    /**
     * The schlafraeume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $schlafraeume;
    /**
     * The wohnschlafraeume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $wohnschlafraeume;
    /**
     * The groessevon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $groessevon;
    /**
     * The groessebis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $groessebis;
    /**
     * Constructor method for searchrequest
     * @uses Searchrequest::setOrtid()
     * @uses Searchrequest::setHausid()
     * @uses Searchrequest::setVon()
     * @uses Searchrequest::setBis()
     * @uses Searchrequest::setVonString()
     * @uses Searchrequest::setBisString()
     * @uses Searchrequest::setUebernachtungen()
     * @uses Searchrequest::setChannelid()
     * @uses Searchrequest::setBookingvolumen()
     * @uses Searchrequest::setSterne()
     * @uses Searchrequest::setHauskategorien()
     * @uses Searchrequest::setSprache()
     * @uses Searchrequest::setAnfrageteilbar()
     * @uses Searchrequest::setHauseigenschaften()
     * @uses Searchrequest::setKateigenschaften()
     * @uses Searchrequest::setSortby()
     * @uses Searchrequest::setEinstellung()
     * @uses Searchrequest::setRestrict2hausname()
     * @uses Searchrequest::setWanttext()
     * @uses Searchrequest::setFlags()
     * @uses Searchrequest::setBezirkids()
     * @uses Searchrequest::setKategorieid()
     * @uses Searchrequest::setSchlafraeume()
     * @uses Searchrequest::setWohnschlafraeume()
     * @uses Searchrequest::setGroessevon()
     * @uses Searchrequest::setGroessebis()
     * @param int $ortid
     * @param int[] $hausid
     * @param string $von
     * @param string $bis
     * @param string $vonString
     * @param string $bisString
     * @param int $uebernachtungen
     * @param int $channelid
     * @param \StructType\Bookingvolumen[] $bookingvolumen
     * @param int[] $sterne
     * @param int[] $hauskategorien
     * @param string $sprache
     * @param bool $anfrageteilbar
     * @param \StructType\Bookingtags[] $hauseigenschaften
     * @param \StructType\Bookingtags[] $kateigenschaften
     * @param \StructType\Sortby[] $sortby
     * @param \StructType\Einstellung[] $einstellung
     * @param string[] $restrict2hausname
     * @param bool $wanttext
     * @param string[] $flags
     * @param int[] $bezirkids
     * @param int[] $kategorieid
     * @param int $schlafraeume
     * @param int $wohnschlafraeume
     * @param int $groessevon
     * @param int $groessebis
     */
    public function __construct($ortid = null, array $hausid = array(), $von = null, $bis = null, $vonString = null, $bisString = null, $uebernachtungen = null, $channelid = null, array $bookingvolumen = array(), array $sterne = array(), array $hauskategorien = array(), $sprache = null, $anfrageteilbar = null, array $hauseigenschaften = array(), array $kateigenschaften = array(), array $sortby = array(), array $einstellung = array(), array $restrict2hausname = array(), $wanttext = null, array $flags = array(), array $bezirkids = array(), array $kategorieid = array(), $schlafraeume = null, $wohnschlafraeume = null, $groessevon = null, $groessebis = null)
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setVon($von)
            ->setBis($bis)
            ->setVonString($vonString)
            ->setBisString($bisString)
            ->setUebernachtungen($uebernachtungen)
            ->setChannelid($channelid)
            ->setBookingvolumen($bookingvolumen)
            ->setSterne($sterne)
            ->setHauskategorien($hauskategorien)
            ->setSprache($sprache)
            ->setAnfrageteilbar($anfrageteilbar)
            ->setHauseigenschaften($hauseigenschaften)
            ->setKateigenschaften($kateigenschaften)
            ->setSortby($sortby)
            ->setEinstellung($einstellung)
            ->setRestrict2hausname($restrict2hausname)
            ->setWanttext($wanttext)
            ->setFlags($flags)
            ->setBezirkids($bezirkids)
            ->setKategorieid($kategorieid)
            ->setSchlafraeume($schlafraeume)
            ->setWohnschlafraeume($wohnschlafraeume)
            ->setGroessevon($groessevon)
            ->setGroessebis($groessebis);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Searchrequest
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int[]|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * This method is responsible for validating the values passed to the setHausid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHausid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHausidForArrayConstraintsFromSetHausid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestHausidItem) {
            // validation for constraint: itemType
            if (!(is_int($searchrequestHausidItem) || ctype_digit($searchrequestHausidItem))) {
                $invalidValues[] = is_object($searchrequestHausidItem) ? get_class($searchrequestHausidItem) : sprintf('%s(%s)', gettype($searchrequestHausidItem), var_export($searchrequestHausidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hausid property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hausid value
     * @throws \InvalidArgumentException
     * @param int[] $hausid
     * @return \StructType\Searchrequest
     */
    public function setHausid(array $hausid = array())
    {
        // validation for constraint: array
        if ('' !== ($hausidArrayErrorMessage = self::validateHausidForArrayConstraintsFromSetHausid($hausid))) {
            throw new \InvalidArgumentException($hausidArrayErrorMessage, __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Add item to hausid value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Searchrequest
     */
    public function addToHausid($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The hausid property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hausid[] = $item;
        return $this;
    }
    /**
     * Get von value
     * @return string|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \StructType\Searchrequest
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \StructType\Searchrequest
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get vonString value
     * @return string|null
     */
    public function getVonString()
    {
        return $this->vonString;
    }
    /**
     * Set vonString value
     * @param string $vonString
     * @return \StructType\Searchrequest
     */
    public function setVonString($vonString = null)
    {
        // validation for constraint: string
        if (!is_null($vonString) && !is_string($vonString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vonString, true), gettype($vonString)), __LINE__);
        }
        $this->vonString = $vonString;
        return $this;
    }
    /**
     * Get bisString value
     * @return string|null
     */
    public function getBisString()
    {
        return $this->bisString;
    }
    /**
     * Set bisString value
     * @param string $bisString
     * @return \StructType\Searchrequest
     */
    public function setBisString($bisString = null)
    {
        // validation for constraint: string
        if (!is_null($bisString) && !is_string($bisString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bisString, true), gettype($bisString)), __LINE__);
        }
        $this->bisString = $bisString;
        return $this;
    }
    /**
     * Get uebernachtungen value
     * @return int|null
     */
    public function getUebernachtungen()
    {
        return $this->uebernachtungen;
    }
    /**
     * Set uebernachtungen value
     * @param int $uebernachtungen
     * @return \StructType\Searchrequest
     */
    public function setUebernachtungen($uebernachtungen = null)
    {
        // validation for constraint: int
        if (!is_null($uebernachtungen) && !(is_int($uebernachtungen) || ctype_digit($uebernachtungen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uebernachtungen, true), gettype($uebernachtungen)), __LINE__);
        }
        $this->uebernachtungen = $uebernachtungen;
        return $this;
    }
    /**
     * Get channelid value
     * @return int|null
     */
    public function getChannelid()
    {
        return $this->channelid;
    }
    /**
     * Set channelid value
     * @param int $channelid
     * @return \StructType\Searchrequest
     */
    public function setChannelid($channelid = null)
    {
        // validation for constraint: int
        if (!is_null($channelid) && !(is_int($channelid) || ctype_digit($channelid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($channelid, true), gettype($channelid)), __LINE__);
        }
        $this->channelid = $channelid;
        return $this;
    }
    /**
     * Get bookingvolumen value
     * @return \StructType\Bookingvolumen[]|null
     */
    public function getBookingvolumen()
    {
        return $this->bookingvolumen;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingvolumen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingvolumen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingvolumenForArrayConstraintsFromSetBookingvolumen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestBookingvolumenItem) {
            // validation for constraint: itemType
            if (!$searchrequestBookingvolumenItem instanceof \StructType\Bookingvolumen) {
                $invalidValues[] = is_object($searchrequestBookingvolumenItem) ? get_class($searchrequestBookingvolumenItem) : sprintf('%s(%s)', gettype($searchrequestBookingvolumenItem), var_export($searchrequestBookingvolumenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bookingvolumen property can only contain items of type \StructType\Bookingvolumen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bookingvolumen value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingvolumen[] $bookingvolumen
     * @return \StructType\Searchrequest
     */
    public function setBookingvolumen(array $bookingvolumen = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingvolumenArrayErrorMessage = self::validateBookingvolumenForArrayConstraintsFromSetBookingvolumen($bookingvolumen))) {
            throw new \InvalidArgumentException($bookingvolumenArrayErrorMessage, __LINE__);
        }
        $this->bookingvolumen = $bookingvolumen;
        return $this;
    }
    /**
     * Add item to bookingvolumen value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingvolumen $item
     * @return \StructType\Searchrequest
     */
    public function addToBookingvolumen(\StructType\Bookingvolumen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingvolumen) {
            throw new \InvalidArgumentException(sprintf('The bookingvolumen property can only contain items of type \StructType\Bookingvolumen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bookingvolumen[] = $item;
        return $this;
    }
    /**
     * Get sterne value
     * @return int[]|null
     */
    public function getSterne()
    {
        return $this->sterne;
    }
    /**
     * This method is responsible for validating the values passed to the setSterne method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSterne method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSterneForArrayConstraintsFromSetSterne(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestSterneItem) {
            // validation for constraint: itemType
            if (!(is_int($searchrequestSterneItem) || ctype_digit($searchrequestSterneItem))) {
                $invalidValues[] = is_object($searchrequestSterneItem) ? get_class($searchrequestSterneItem) : sprintf('%s(%s)', gettype($searchrequestSterneItem), var_export($searchrequestSterneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sterne property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sterne value
     * @throws \InvalidArgumentException
     * @param int[] $sterne
     * @return \StructType\Searchrequest
     */
    public function setSterne(array $sterne = array())
    {
        // validation for constraint: array
        if ('' !== ($sterneArrayErrorMessage = self::validateSterneForArrayConstraintsFromSetSterne($sterne))) {
            throw new \InvalidArgumentException($sterneArrayErrorMessage, __LINE__);
        }
        $this->sterne = $sterne;
        return $this;
    }
    /**
     * Add item to sterne value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Searchrequest
     */
    public function addToSterne($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The sterne property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sterne[] = $item;
        return $this;
    }
    /**
     * Get hauskategorien value
     * @return int[]|null
     */
    public function getHauskategorien()
    {
        return $this->hauskategorien;
    }
    /**
     * This method is responsible for validating the values passed to the setHauskategorien method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauskategorien method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauskategorienForArrayConstraintsFromSetHauskategorien(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestHauskategorienItem) {
            // validation for constraint: itemType
            if (!(is_int($searchrequestHauskategorienItem) || ctype_digit($searchrequestHauskategorienItem))) {
                $invalidValues[] = is_object($searchrequestHauskategorienItem) ? get_class($searchrequestHauskategorienItem) : sprintf('%s(%s)', gettype($searchrequestHauskategorienItem), var_export($searchrequestHauskategorienItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauskategorien property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauskategorien value
     * @throws \InvalidArgumentException
     * @param int[] $hauskategorien
     * @return \StructType\Searchrequest
     */
    public function setHauskategorien(array $hauskategorien = array())
    {
        // validation for constraint: array
        if ('' !== ($hauskategorienArrayErrorMessage = self::validateHauskategorienForArrayConstraintsFromSetHauskategorien($hauskategorien))) {
            throw new \InvalidArgumentException($hauskategorienArrayErrorMessage, __LINE__);
        }
        $this->hauskategorien = $hauskategorien;
        return $this;
    }
    /**
     * Add item to hauskategorien value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Searchrequest
     */
    public function addToHauskategorien($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The hauskategorien property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauskategorien[] = $item;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Searchrequest
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get anfrageteilbar value
     * @return bool|null
     */
    public function getAnfrageteilbar()
    {
        return $this->anfrageteilbar;
    }
    /**
     * Set anfrageteilbar value
     * @param bool $anfrageteilbar
     * @return \StructType\Searchrequest
     */
    public function setAnfrageteilbar($anfrageteilbar = null)
    {
        // validation for constraint: boolean
        if (!is_null($anfrageteilbar) && !is_bool($anfrageteilbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anfrageteilbar, true), gettype($anfrageteilbar)), __LINE__);
        }
        $this->anfrageteilbar = $anfrageteilbar;
        return $this;
    }
    /**
     * Get hauseigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bookingtags[]|null
     */
    public function getHauseigenschaften()
    {
        return isset($this->hauseigenschaften) ? $this->hauseigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHauseigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauseigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestHauseigenschaftenItem) {
            // validation for constraint: itemType
            if (!$searchrequestHauseigenschaftenItem instanceof \StructType\Bookingtags) {
                $invalidValues[] = is_object($searchrequestHauseigenschaftenItem) ? get_class($searchrequestHauseigenschaftenItem) : sprintf('%s(%s)', gettype($searchrequestHauseigenschaftenItem), var_export($searchrequestHauseigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauseigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauseigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags[] $hauseigenschaften
     * @return \StructType\Searchrequest
     */
    public function setHauseigenschaften(array $hauseigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($hauseigenschaftenArrayErrorMessage = self::validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften($hauseigenschaften))) {
            throw new \InvalidArgumentException($hauseigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($hauseigenschaften) || (is_array($hauseigenschaften) && empty($hauseigenschaften))) {
            unset($this->hauseigenschaften);
        } else {
            $this->hauseigenschaften = $hauseigenschaften;
        }
        return $this;
    }
    /**
     * Add item to hauseigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags $item
     * @return \StructType\Searchrequest
     */
    public function addToHauseigenschaften(\StructType\Bookingtags $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingtags) {
            throw new \InvalidArgumentException(sprintf('The hauseigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauseigenschaften[] = $item;
        return $this;
    }
    /**
     * Get kateigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bookingtags[]|null
     */
    public function getKateigenschaften()
    {
        return isset($this->kateigenschaften) ? $this->kateigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKateigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKateigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKateigenschaftenForArrayConstraintsFromSetKateigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestKateigenschaftenItem) {
            // validation for constraint: itemType
            if (!$searchrequestKateigenschaftenItem instanceof \StructType\Bookingtags) {
                $invalidValues[] = is_object($searchrequestKateigenschaftenItem) ? get_class($searchrequestKateigenschaftenItem) : sprintf('%s(%s)', gettype($searchrequestKateigenschaftenItem), var_export($searchrequestKateigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kateigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kateigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags[] $kateigenschaften
     * @return \StructType\Searchrequest
     */
    public function setKateigenschaften(array $kateigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($kateigenschaftenArrayErrorMessage = self::validateKateigenschaftenForArrayConstraintsFromSetKateigenschaften($kateigenschaften))) {
            throw new \InvalidArgumentException($kateigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($kateigenschaften) || (is_array($kateigenschaften) && empty($kateigenschaften))) {
            unset($this->kateigenschaften);
        } else {
            $this->kateigenschaften = $kateigenschaften;
        }
        return $this;
    }
    /**
     * Add item to kateigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags $item
     * @return \StructType\Searchrequest
     */
    public function addToKateigenschaften(\StructType\Bookingtags $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingtags) {
            throw new \InvalidArgumentException(sprintf('The kateigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kateigenschaften[] = $item;
        return $this;
    }
    /**
     * Get sortby value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sortby[]|null
     */
    public function getSortby()
    {
        return isset($this->sortby) ? $this->sortby : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSortby method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSortby method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSortbyForArrayConstraintsFromSetSortby(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestSortbyItem) {
            // validation for constraint: itemType
            if (!$searchrequestSortbyItem instanceof \StructType\Sortby) {
                $invalidValues[] = is_object($searchrequestSortbyItem) ? get_class($searchrequestSortbyItem) : sprintf('%s(%s)', gettype($searchrequestSortbyItem), var_export($searchrequestSortbyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sortby property can only contain items of type \StructType\Sortby, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sortby value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sortby[] $sortby
     * @return \StructType\Searchrequest
     */
    public function setSortby(array $sortby = array())
    {
        // validation for constraint: array
        if ('' !== ($sortbyArrayErrorMessage = self::validateSortbyForArrayConstraintsFromSetSortby($sortby))) {
            throw new \InvalidArgumentException($sortbyArrayErrorMessage, __LINE__);
        }
        if (is_null($sortby) || (is_array($sortby) && empty($sortby))) {
            unset($this->sortby);
        } else {
            $this->sortby = $sortby;
        }
        return $this;
    }
    /**
     * Add item to sortby value
     * @throws \InvalidArgumentException
     * @param \StructType\Sortby $item
     * @return \StructType\Searchrequest
     */
    public function addToSortby(\StructType\Sortby $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sortby) {
            throw new \InvalidArgumentException(sprintf('The sortby property can only contain items of type \StructType\Sortby, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sortby[] = $item;
        return $this;
    }
    /**
     * Get einstellung value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Einstellung[]|null
     */
    public function getEinstellung()
    {
        return isset($this->einstellung) ? $this->einstellung : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEinstellung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEinstellung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEinstellungForArrayConstraintsFromSetEinstellung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestEinstellungItem) {
            // validation for constraint: itemType
            if (!$searchrequestEinstellungItem instanceof \StructType\Einstellung) {
                $invalidValues[] = is_object($searchrequestEinstellungItem) ? get_class($searchrequestEinstellungItem) : sprintf('%s(%s)', gettype($searchrequestEinstellungItem), var_export($searchrequestEinstellungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The einstellung property can only contain items of type \StructType\Einstellung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set einstellung value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Einstellung[] $einstellung
     * @return \StructType\Searchrequest
     */
    public function setEinstellung(array $einstellung = array())
    {
        // validation for constraint: array
        if ('' !== ($einstellungArrayErrorMessage = self::validateEinstellungForArrayConstraintsFromSetEinstellung($einstellung))) {
            throw new \InvalidArgumentException($einstellungArrayErrorMessage, __LINE__);
        }
        if (is_null($einstellung) || (is_array($einstellung) && empty($einstellung))) {
            unset($this->einstellung);
        } else {
            $this->einstellung = $einstellung;
        }
        return $this;
    }
    /**
     * Add item to einstellung value
     * @throws \InvalidArgumentException
     * @param \StructType\Einstellung $item
     * @return \StructType\Searchrequest
     */
    public function addToEinstellung(\StructType\Einstellung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Einstellung) {
            throw new \InvalidArgumentException(sprintf('The einstellung property can only contain items of type \StructType\Einstellung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->einstellung[] = $item;
        return $this;
    }
    /**
     * Get restrict2hausname value
     * @return string[]|null
     */
    public function getRestrict2hausname()
    {
        return $this->restrict2hausname;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrict2hausname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrict2hausname method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrict2hausnameForArrayConstraintsFromSetRestrict2hausname(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestRestrict2hausnameItem) {
            // validation for constraint: itemType
            if (!is_string($searchrequestRestrict2hausnameItem)) {
                $invalidValues[] = is_object($searchrequestRestrict2hausnameItem) ? get_class($searchrequestRestrict2hausnameItem) : sprintf('%s(%s)', gettype($searchrequestRestrict2hausnameItem), var_export($searchrequestRestrict2hausnameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The restrict2hausname property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set restrict2hausname value
     * @throws \InvalidArgumentException
     * @param string[] $restrict2hausname
     * @return \StructType\Searchrequest
     */
    public function setRestrict2hausname(array $restrict2hausname = array())
    {
        // validation for constraint: array
        if ('' !== ($restrict2hausnameArrayErrorMessage = self::validateRestrict2hausnameForArrayConstraintsFromSetRestrict2hausname($restrict2hausname))) {
            throw new \InvalidArgumentException($restrict2hausnameArrayErrorMessage, __LINE__);
        }
        $this->restrict2hausname = $restrict2hausname;
        return $this;
    }
    /**
     * Add item to restrict2hausname value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Searchrequest
     */
    public function addToRestrict2hausname($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The restrict2hausname property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->restrict2hausname[] = $item;
        return $this;
    }
    /**
     * Get wanttext value
     * @return bool|null
     */
    public function getWanttext()
    {
        return $this->wanttext;
    }
    /**
     * Set wanttext value
     * @param bool $wanttext
     * @return \StructType\Searchrequest
     */
    public function setWanttext($wanttext = null)
    {
        // validation for constraint: boolean
        if (!is_null($wanttext) && !is_bool($wanttext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wanttext, true), gettype($wanttext)), __LINE__);
        }
        $this->wanttext = $wanttext;
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFlags method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlags method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlagsForArrayConstraintsFromSetFlags(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestFlagsItem) {
            // validation for constraint: itemType
            if (!is_string($searchrequestFlagsItem)) {
                $invalidValues[] = is_object($searchrequestFlagsItem) ? get_class($searchrequestFlagsItem) : sprintf('%s(%s)', gettype($searchrequestFlagsItem), var_export($searchrequestFlagsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The flags property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $flags
     * @return \StructType\Searchrequest
     */
    public function setFlags(array $flags = array())
    {
        // validation for constraint: array
        if ('' !== ($flagsArrayErrorMessage = self::validateFlagsForArrayConstraintsFromSetFlags($flags))) {
            throw new \InvalidArgumentException($flagsArrayErrorMessage, __LINE__);
        }
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Add item to flags value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Searchrequest
     */
    public function addToFlags($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The flags property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->flags[] = $item;
        return $this;
    }
    /**
     * Get bezirkids value
     * @return int[]|null
     */
    public function getBezirkids()
    {
        return $this->bezirkids;
    }
    /**
     * This method is responsible for validating the values passed to the setBezirkids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezirkids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezirkidsForArrayConstraintsFromSetBezirkids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestBezirkidsItem) {
            // validation for constraint: itemType
            if (!(is_int($searchrequestBezirkidsItem) || ctype_digit($searchrequestBezirkidsItem))) {
                $invalidValues[] = is_object($searchrequestBezirkidsItem) ? get_class($searchrequestBezirkidsItem) : sprintf('%s(%s)', gettype($searchrequestBezirkidsItem), var_export($searchrequestBezirkidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezirkids property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezirkids value
     * @throws \InvalidArgumentException
     * @param int[] $bezirkids
     * @return \StructType\Searchrequest
     */
    public function setBezirkids(array $bezirkids = array())
    {
        // validation for constraint: array
        if ('' !== ($bezirkidsArrayErrorMessage = self::validateBezirkidsForArrayConstraintsFromSetBezirkids($bezirkids))) {
            throw new \InvalidArgumentException($bezirkidsArrayErrorMessage, __LINE__);
        }
        $this->bezirkids = $bezirkids;
        return $this;
    }
    /**
     * Add item to bezirkids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Searchrequest
     */
    public function addToBezirkids($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The bezirkids property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezirkids[] = $item;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int[]|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorieid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorieid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieidForArrayConstraintsFromSetKategorieid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchrequestKategorieidItem) {
            // validation for constraint: itemType
            if (!(is_int($searchrequestKategorieidItem) || ctype_digit($searchrequestKategorieidItem))) {
                $invalidValues[] = is_object($searchrequestKategorieidItem) ? get_class($searchrequestKategorieidItem) : sprintf('%s(%s)', gettype($searchrequestKategorieidItem), var_export($searchrequestKategorieidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorieid property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorieid value
     * @throws \InvalidArgumentException
     * @param int[] $kategorieid
     * @return \StructType\Searchrequest
     */
    public function setKategorieid(array $kategorieid = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieidArrayErrorMessage = self::validateKategorieidForArrayConstraintsFromSetKategorieid($kategorieid))) {
            throw new \InvalidArgumentException($kategorieidArrayErrorMessage, __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Add item to kategorieid value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Searchrequest
     */
    public function addToKategorieid($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The kategorieid property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorieid[] = $item;
        return $this;
    }
    /**
     * Get schlafraeume value
     * @return int|null
     */
    public function getSchlafraeume()
    {
        return $this->schlafraeume;
    }
    /**
     * Set schlafraeume value
     * @param int $schlafraeume
     * @return \StructType\Searchrequest
     */
    public function setSchlafraeume($schlafraeume = null)
    {
        // validation for constraint: int
        if (!is_null($schlafraeume) && !(is_int($schlafraeume) || ctype_digit($schlafraeume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schlafraeume, true), gettype($schlafraeume)), __LINE__);
        }
        $this->schlafraeume = $schlafraeume;
        return $this;
    }
    /**
     * Get wohnschlafraeume value
     * @return int|null
     */
    public function getWohnschlafraeume()
    {
        return $this->wohnschlafraeume;
    }
    /**
     * Set wohnschlafraeume value
     * @param int $wohnschlafraeume
     * @return \StructType\Searchrequest
     */
    public function setWohnschlafraeume($wohnschlafraeume = null)
    {
        // validation for constraint: int
        if (!is_null($wohnschlafraeume) && !(is_int($wohnschlafraeume) || ctype_digit($wohnschlafraeume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wohnschlafraeume, true), gettype($wohnschlafraeume)), __LINE__);
        }
        $this->wohnschlafraeume = $wohnschlafraeume;
        return $this;
    }
    /**
     * Get groessevon value
     * @return int|null
     */
    public function getGroessevon()
    {
        return $this->groessevon;
    }
    /**
     * Set groessevon value
     * @param int $groessevon
     * @return \StructType\Searchrequest
     */
    public function setGroessevon($groessevon = null)
    {
        // validation for constraint: int
        if (!is_null($groessevon) && !(is_int($groessevon) || ctype_digit($groessevon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groessevon, true), gettype($groessevon)), __LINE__);
        }
        $this->groessevon = $groessevon;
        return $this;
    }
    /**
     * Get groessebis value
     * @return int|null
     */
    public function getGroessebis()
    {
        return $this->groessebis;
    }
    /**
     * Set groessebis value
     * @param int $groessebis
     * @return \StructType\Searchrequest
     */
    public function setGroessebis($groessebis = null)
    {
        // validation for constraint: int
        if (!is_null($groessebis) && !(is_int($groessebis) || ctype_digit($groessebis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groessebis, true), gettype($groessebis)), __LINE__);
        }
        $this->groessebis = $groessebis;
        return $this;
    }
}
