<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saisonen StructType
 * @subpackage Structs
 */
class Saisonen extends AbstractStructBase
{
    /**
     * The saison
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Saison[]
     */
    public $saison;
    /**
     * Constructor method for saisonen
     * @uses Saisonen::setSaison()
     * @param \StructType\Saison[] $saison
     */
    public function __construct(array $saison = array())
    {
        $this
            ->setSaison($saison);
    }
    /**
     * Get saison value
     * @return \StructType\Saison[]|null
     */
    public function getSaison()
    {
        return $this->saison;
    }
    /**
     * This method is responsible for validating the values passed to the setSaison method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaison method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaisonForArrayConstraintsFromSetSaison(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $saisonenSaisonItem) {
            // validation for constraint: itemType
            if (!$saisonenSaisonItem instanceof \StructType\Saison) {
                $invalidValues[] = is_object($saisonenSaisonItem) ? get_class($saisonenSaisonItem) : sprintf('%s(%s)', gettype($saisonenSaisonItem), var_export($saisonenSaisonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The saison property can only contain items of type \StructType\Saison, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set saison value
     * @throws \InvalidArgumentException
     * @param \StructType\Saison[] $saison
     * @return \StructType\Saisonen
     */
    public function setSaison(array $saison = array())
    {
        // validation for constraint: array
        if ('' !== ($saisonArrayErrorMessage = self::validateSaisonForArrayConstraintsFromSetSaison($saison))) {
            throw new \InvalidArgumentException($saisonArrayErrorMessage, __LINE__);
        }
        $this->saison = $saison;
        return $this;
    }
    /**
     * Add item to saison value
     * @throws \InvalidArgumentException
     * @param \StructType\Saison $item
     * @return \StructType\Saisonen
     */
    public function addToSaison(\StructType\Saison $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Saison) {
            throw new \InvalidArgumentException(sprintf('The saison property can only contain items of type \StructType\Saison, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->saison[] = $item;
        return $this;
    }
}
