<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservierung StructType
 * @subpackage Structs
 */
class Reservierung extends AbstractStructBase
{
    /**
     * The resid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $resid;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The katid
     * @var int
     */
    public $katid;
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The preis
     * @var string
     */
    public $preis;
    /**
     * The anredeid
     * @var int
     */
    public $anredeid;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The landid
     * @var int
     */
    public $landid;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The telefax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The bemerkung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bemerkung;
    /**
     * The sent2email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $sent2email;
    /**
     * The von
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $von;
    /**
     * The bis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $bis;
    /**
     * The anztage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anztage;
    /**
     * The verpflegung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verpflegung;
    /**
     * The anzerw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anzerw;
    /**
     * The anzkinder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anzkinder;
    /**
     * The alterkinder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $alterkinder;
    /**
     * The absendebeleg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $absendebeleg;
    /**
     * The ci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ci;
    /**
     * The zusatzinfoids
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $zusatzinfoids;
    /**
     * Constructor method for reservierung
     * @uses Reservierung::setResid()
     * @uses Reservierung::setOrtid()
     * @uses Reservierung::setHausid()
     * @uses Reservierung::setKatid()
     * @uses Reservierung::setPauid()
     * @uses Reservierung::setPreis()
     * @uses Reservierung::setAnredeid()
     * @uses Reservierung::setVorname()
     * @uses Reservierung::setNachname()
     * @uses Reservierung::setStrasse()
     * @uses Reservierung::setPlz()
     * @uses Reservierung::setOrt()
     * @uses Reservierung::setLandid()
     * @uses Reservierung::setTelefon()
     * @uses Reservierung::setTelefax()
     * @uses Reservierung::setEmail()
     * @uses Reservierung::setBemerkung()
     * @uses Reservierung::setSent2email()
     * @uses Reservierung::setVon()
     * @uses Reservierung::setBis()
     * @uses Reservierung::setAnztage()
     * @uses Reservierung::setVerpflegung()
     * @uses Reservierung::setAnzerw()
     * @uses Reservierung::setAnzkinder()
     * @uses Reservierung::setAlterkinder()
     * @uses Reservierung::setAbsendebeleg()
     * @uses Reservierung::setCi()
     * @uses Reservierung::setZusatzinfoids()
     * @param int $resid
     * @param int $ortid
     * @param int $hausid
     * @param int $katid
     * @param int $pauid
     * @param string $preis
     * @param int $anredeid
     * @param string $vorname
     * @param string $nachname
     * @param string $strasse
     * @param string $plz
     * @param string $ort
     * @param int $landid
     * @param string $telefon
     * @param string $telefax
     * @param string $email
     * @param string $bemerkung
     * @param string[] $sent2email
     * @param anySimpleType $von
     * @param anySimpleType $bis
     * @param int $anztage
     * @param string $verpflegung
     * @param int $anzerw
     * @param int $anzkinder
     * @param string $alterkinder
     * @param int $absendebeleg
     * @param string $ci
     * @param int[] $zusatzinfoids
     */
    public function __construct($resid = null, $ortid = null, $hausid = null, $katid = null, $pauid = null, $preis = null, $anredeid = null, $vorname = null, $nachname = null, $strasse = null, $plz = null, $ort = null, $landid = null, $telefon = null, $telefax = null, $email = null, $bemerkung = null, array $sent2email = array(), anySimpleType $von = null, anySimpleType $bis = null, $anztage = null, $verpflegung = null, $anzerw = null, $anzkinder = null, $alterkinder = null, $absendebeleg = null, $ci = null, array $zusatzinfoids = array())
    {
        $this
            ->setResid($resid)
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setKatid($katid)
            ->setPauid($pauid)
            ->setPreis($preis)
            ->setAnredeid($anredeid)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setStrasse($strasse)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setLandid($landid)
            ->setTelefon($telefon)
            ->setTelefax($telefax)
            ->setEmail($email)
            ->setBemerkung($bemerkung)
            ->setSent2email($sent2email)
            ->setVon($von)
            ->setBis($bis)
            ->setAnztage($anztage)
            ->setVerpflegung($verpflegung)
            ->setAnzerw($anzerw)
            ->setAnzkinder($anzkinder)
            ->setAlterkinder($alterkinder)
            ->setAbsendebeleg($absendebeleg)
            ->setCi($ci)
            ->setZusatzinfoids($zusatzinfoids);
    }
    /**
     * Get resid value
     * @return int|null
     */
    public function getResid()
    {
        return $this->resid;
    }
    /**
     * Set resid value
     * @param int $resid
     * @return \StructType\Reservierung
     */
    public function setResid($resid = null)
    {
        // validation for constraint: int
        if (!is_null($resid) && !(is_int($resid) || ctype_digit($resid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resid, true), gettype($resid)), __LINE__);
        }
        $this->resid = $resid;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Reservierung
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Reservierung
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get katid value
     * @return int|null
     */
    public function getKatid()
    {
        return $this->katid;
    }
    /**
     * Set katid value
     * @param int $katid
     * @return \StructType\Reservierung
     */
    public function setKatid($katid = null)
    {
        // validation for constraint: int
        if (!is_null($katid) && !(is_int($katid) || ctype_digit($katid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katid, true), gettype($katid)), __LINE__);
        }
        $this->katid = $katid;
        return $this;
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Reservierung
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get preis value
     * @return string|null
     */
    public function getPreis()
    {
        return $this->preis;
    }
    /**
     * Set preis value
     * @param string $preis
     * @return \StructType\Reservierung
     */
    public function setPreis($preis = null)
    {
        // validation for constraint: string
        if (!is_null($preis) && !is_string($preis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preis, true), gettype($preis)), __LINE__);
        }
        $this->preis = $preis;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \StructType\Reservierung
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Reservierung
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\Reservierung
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Reservierung
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Reservierung
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Reservierung
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get landid value
     * @return int|null
     */
    public function getLandid()
    {
        return $this->landid;
    }
    /**
     * Set landid value
     * @param int $landid
     * @return \StructType\Reservierung
     */
    public function setLandid($landid = null)
    {
        // validation for constraint: int
        if (!is_null($landid) && !(is_int($landid) || ctype_digit($landid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landid, true), gettype($landid)), __LINE__);
        }
        $this->landid = $landid;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Reservierung
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get telefax value
     * @return string|null
     */
    public function getTelefax()
    {
        return $this->telefax;
    }
    /**
     * Set telefax value
     * @param string $telefax
     * @return \StructType\Reservierung
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax, true), gettype($telefax)), __LINE__);
        }
        $this->telefax = $telefax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Reservierung
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get bemerkung value
     * @return string|null
     */
    public function getBemerkung()
    {
        return $this->bemerkung;
    }
    /**
     * Set bemerkung value
     * @param string $bemerkung
     * @return \StructType\Reservierung
     */
    public function setBemerkung($bemerkung = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkung) && !is_string($bemerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkung, true), gettype($bemerkung)), __LINE__);
        }
        $this->bemerkung = $bemerkung;
        return $this;
    }
    /**
     * Get sent2email value
     * @return string[]|null
     */
    public function getSent2email()
    {
        return $this->sent2email;
    }
    /**
     * This method is responsible for validating the values passed to the setSent2email method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSent2email method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSent2emailForArrayConstraintsFromSetSent2email(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservierungSent2emailItem) {
            // validation for constraint: itemType
            if (!is_string($reservierungSent2emailItem)) {
                $invalidValues[] = is_object($reservierungSent2emailItem) ? get_class($reservierungSent2emailItem) : sprintf('%s(%s)', gettype($reservierungSent2emailItem), var_export($reservierungSent2emailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sent2email property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sent2email value
     * @throws \InvalidArgumentException
     * @param string[] $sent2email
     * @return \StructType\Reservierung
     */
    public function setSent2email(array $sent2email = array())
    {
        // validation for constraint: array
        if ('' !== ($sent2emailArrayErrorMessage = self::validateSent2emailForArrayConstraintsFromSetSent2email($sent2email))) {
            throw new \InvalidArgumentException($sent2emailArrayErrorMessage, __LINE__);
        }
        $this->sent2email = $sent2email;
        return $this;
    }
    /**
     * Add item to sent2email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Reservierung
     */
    public function addToSent2email($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sent2email property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sent2email[] = $item;
        return $this;
    }
    /**
     * Get von value
     * @return anySimpleType|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param anySimpleType $von
     * @return \StructType\Reservierung
     */
    public function setVon(anySimpleType $von = null)
    {
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return anySimpleType|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param anySimpleType $bis
     * @return \StructType\Reservierung
     */
    public function setBis(anySimpleType $bis = null)
    {
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get anztage value
     * @return int|null
     */
    public function getAnztage()
    {
        return $this->anztage;
    }
    /**
     * Set anztage value
     * @param int $anztage
     * @return \StructType\Reservierung
     */
    public function setAnztage($anztage = null)
    {
        // validation for constraint: int
        if (!is_null($anztage) && !(is_int($anztage) || ctype_digit($anztage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anztage, true), gettype($anztage)), __LINE__);
        }
        $this->anztage = $anztage;
        return $this;
    }
    /**
     * Get verpflegung value
     * @return string|null
     */
    public function getVerpflegung()
    {
        return $this->verpflegung;
    }
    /**
     * Set verpflegung value
     * @param string $verpflegung
     * @return \StructType\Reservierung
     */
    public function setVerpflegung($verpflegung = null)
    {
        // validation for constraint: string
        if (!is_null($verpflegung) && !is_string($verpflegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpflegung, true), gettype($verpflegung)), __LINE__);
        }
        $this->verpflegung = $verpflegung;
        return $this;
    }
    /**
     * Get anzerw value
     * @return int|null
     */
    public function getAnzerw()
    {
        return $this->anzerw;
    }
    /**
     * Set anzerw value
     * @param int $anzerw
     * @return \StructType\Reservierung
     */
    public function setAnzerw($anzerw = null)
    {
        // validation for constraint: int
        if (!is_null($anzerw) && !(is_int($anzerw) || ctype_digit($anzerw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzerw, true), gettype($anzerw)), __LINE__);
        }
        $this->anzerw = $anzerw;
        return $this;
    }
    /**
     * Get anzkinder value
     * @return int|null
     */
    public function getAnzkinder()
    {
        return $this->anzkinder;
    }
    /**
     * Set anzkinder value
     * @param int $anzkinder
     * @return \StructType\Reservierung
     */
    public function setAnzkinder($anzkinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzkinder) && !(is_int($anzkinder) || ctype_digit($anzkinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkinder, true), gettype($anzkinder)), __LINE__);
        }
        $this->anzkinder = $anzkinder;
        return $this;
    }
    /**
     * Get alterkinder value
     * @return string|null
     */
    public function getAlterkinder()
    {
        return $this->alterkinder;
    }
    /**
     * Set alterkinder value
     * @param string $alterkinder
     * @return \StructType\Reservierung
     */
    public function setAlterkinder($alterkinder = null)
    {
        // validation for constraint: string
        if (!is_null($alterkinder) && !is_string($alterkinder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alterkinder, true), gettype($alterkinder)), __LINE__);
        }
        $this->alterkinder = $alterkinder;
        return $this;
    }
    /**
     * Get absendebeleg value
     * @return int|null
     */
    public function getAbsendebeleg()
    {
        return $this->absendebeleg;
    }
    /**
     * Set absendebeleg value
     * @param int $absendebeleg
     * @return \StructType\Reservierung
     */
    public function setAbsendebeleg($absendebeleg = null)
    {
        // validation for constraint: int
        if (!is_null($absendebeleg) && !(is_int($absendebeleg) || ctype_digit($absendebeleg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($absendebeleg, true), gettype($absendebeleg)), __LINE__);
        }
        $this->absendebeleg = $absendebeleg;
        return $this;
    }
    /**
     * Get ci value
     * @return string|null
     */
    public function getCi()
    {
        return $this->ci;
    }
    /**
     * Set ci value
     * @param string $ci
     * @return \StructType\Reservierung
     */
    public function setCi($ci = null)
    {
        // validation for constraint: string
        if (!is_null($ci) && !is_string($ci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ci, true), gettype($ci)), __LINE__);
        }
        $this->ci = $ci;
        return $this;
    }
    /**
     * Get zusatzinfoids value
     * @return int[]|null
     */
    public function getZusatzinfoids()
    {
        return $this->zusatzinfoids;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzinfoids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzinfoids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzinfoidsForArrayConstraintsFromSetZusatzinfoids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservierungZusatzinfoidsItem) {
            // validation for constraint: itemType
            if (!(is_int($reservierungZusatzinfoidsItem) || ctype_digit($reservierungZusatzinfoidsItem))) {
                $invalidValues[] = is_object($reservierungZusatzinfoidsItem) ? get_class($reservierungZusatzinfoidsItem) : sprintf('%s(%s)', gettype($reservierungZusatzinfoidsItem), var_export($reservierungZusatzinfoidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzinfoids property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzinfoids value
     * @throws \InvalidArgumentException
     * @param int[] $zusatzinfoids
     * @return \StructType\Reservierung
     */
    public function setZusatzinfoids(array $zusatzinfoids = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzinfoidsArrayErrorMessage = self::validateZusatzinfoidsForArrayConstraintsFromSetZusatzinfoids($zusatzinfoids))) {
            throw new \InvalidArgumentException($zusatzinfoidsArrayErrorMessage, __LINE__);
        }
        $this->zusatzinfoids = $zusatzinfoids;
        return $this;
    }
    /**
     * Add item to zusatzinfoids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Reservierung
     */
    public function addToZusatzinfoids($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The zusatzinfoids property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzinfoids[] = $item;
        return $this;
    }
}
