<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pauschalenpreis StructType
 * @subpackage Structs
 */
class Pauschalenpreis extends AbstractStructBase
{
    /**
     * The preisid
     * @var int
     */
    public $preisid;
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The rateid
     * @var int
     */
    public $rateid;
    /**
     * The katid
     * @var int
     */
    public $katid;
    /**
     * The katbez
     * @var string
     */
    public $katbez;
    /**
     * The anzueb
     * @var int
     */
    public $anzueb;
    /**
     * The anzerw
     * @var int
     */
    public $anzerw;
    /**
     * The erwpreis
     * @var int
     */
    public $erwpreis;
    /**
     * The kindbpreis
     * @var int
     */
    public $kindbpreis;
    /**
     * The kindcpreis
     * @var int
     */
    public $kindcpreis;
    /**
     * The kinddpreis
     * @var int
     */
    public $kinddpreis;
    /**
     * The kindbavailable
     * @var int
     */
    public $kindbavailable;
    /**
     * The kindcavailable
     * @var int
     */
    public $kindcavailable;
    /**
     * The kinddavailable
     * @var int
     */
    public $kinddavailable;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The pauschalenzeitraum
     * @var \StructType\Pauschalenzeitraum
     */
    public $pauschalenzeitraum;
    /**
     * The pauschalenpreissegment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pauschalenpreissegment[]
     */
    public $pauschalenpreissegment;
    /**
     * Constructor method for pauschalenpreis
     * @uses Pauschalenpreis::setPreisid()
     * @uses Pauschalenpreis::setPauid()
     * @uses Pauschalenpreis::setRateid()
     * @uses Pauschalenpreis::setKatid()
     * @uses Pauschalenpreis::setKatbez()
     * @uses Pauschalenpreis::setAnzueb()
     * @uses Pauschalenpreis::setAnzerw()
     * @uses Pauschalenpreis::setErwpreis()
     * @uses Pauschalenpreis::setKindbpreis()
     * @uses Pauschalenpreis::setKindcpreis()
     * @uses Pauschalenpreis::setKinddpreis()
     * @uses Pauschalenpreis::setKindbavailable()
     * @uses Pauschalenpreis::setKindcavailable()
     * @uses Pauschalenpreis::setKinddavailable()
     * @uses Pauschalenpreis::setStatus()
     * @uses Pauschalenpreis::setPauschalenzeitraum()
     * @uses Pauschalenpreis::setPauschalenpreissegment()
     * @param int $preisid
     * @param int $pauid
     * @param int $rateid
     * @param int $katid
     * @param string $katbez
     * @param int $anzueb
     * @param int $anzerw
     * @param int $erwpreis
     * @param int $kindbpreis
     * @param int $kindcpreis
     * @param int $kinddpreis
     * @param int $kindbavailable
     * @param int $kindcavailable
     * @param int $kinddavailable
     * @param int $status
     * @param \StructType\Pauschalenzeitraum $pauschalenzeitraum
     * @param \StructType\Pauschalenpreissegment[] $pauschalenpreissegment
     */
    public function __construct($preisid = null, $pauid = null, $rateid = null, $katid = null, $katbez = null, $anzueb = null, $anzerw = null, $erwpreis = null, $kindbpreis = null, $kindcpreis = null, $kinddpreis = null, $kindbavailable = null, $kindcavailable = null, $kinddavailable = null, $status = null, \StructType\Pauschalenzeitraum $pauschalenzeitraum = null, array $pauschalenpreissegment = array())
    {
        $this
            ->setPreisid($preisid)
            ->setPauid($pauid)
            ->setRateid($rateid)
            ->setKatid($katid)
            ->setKatbez($katbez)
            ->setAnzueb($anzueb)
            ->setAnzerw($anzerw)
            ->setErwpreis($erwpreis)
            ->setKindbpreis($kindbpreis)
            ->setKindcpreis($kindcpreis)
            ->setKinddpreis($kinddpreis)
            ->setKindbavailable($kindbavailable)
            ->setKindcavailable($kindcavailable)
            ->setKinddavailable($kinddavailable)
            ->setStatus($status)
            ->setPauschalenzeitraum($pauschalenzeitraum)
            ->setPauschalenpreissegment($pauschalenpreissegment);
    }
    /**
     * Get preisid value
     * @return int|null
     */
    public function getPreisid()
    {
        return $this->preisid;
    }
    /**
     * Set preisid value
     * @param int $preisid
     * @return \StructType\Pauschalenpreis
     */
    public function setPreisid($preisid = null)
    {
        // validation for constraint: int
        if (!is_null($preisid) && !(is_int($preisid) || ctype_digit($preisid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisid, true), gettype($preisid)), __LINE__);
        }
        $this->preisid = $preisid;
        return $this;
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Pauschalenpreis
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get rateid value
     * @return int|null
     */
    public function getRateid()
    {
        return $this->rateid;
    }
    /**
     * Set rateid value
     * @param int $rateid
     * @return \StructType\Pauschalenpreis
     */
    public function setRateid($rateid = null)
    {
        // validation for constraint: int
        if (!is_null($rateid) && !(is_int($rateid) || ctype_digit($rateid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rateid, true), gettype($rateid)), __LINE__);
        }
        $this->rateid = $rateid;
        return $this;
    }
    /**
     * Get katid value
     * @return int|null
     */
    public function getKatid()
    {
        return $this->katid;
    }
    /**
     * Set katid value
     * @param int $katid
     * @return \StructType\Pauschalenpreis
     */
    public function setKatid($katid = null)
    {
        // validation for constraint: int
        if (!is_null($katid) && !(is_int($katid) || ctype_digit($katid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katid, true), gettype($katid)), __LINE__);
        }
        $this->katid = $katid;
        return $this;
    }
    /**
     * Get katbez value
     * @return string|null
     */
    public function getKatbez()
    {
        return $this->katbez;
    }
    /**
     * Set katbez value
     * @param string $katbez
     * @return \StructType\Pauschalenpreis
     */
    public function setKatbez($katbez = null)
    {
        // validation for constraint: string
        if (!is_null($katbez) && !is_string($katbez)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($katbez, true), gettype($katbez)), __LINE__);
        }
        $this->katbez = $katbez;
        return $this;
    }
    /**
     * Get anzueb value
     * @return int|null
     */
    public function getAnzueb()
    {
        return $this->anzueb;
    }
    /**
     * Set anzueb value
     * @param int $anzueb
     * @return \StructType\Pauschalenpreis
     */
    public function setAnzueb($anzueb = null)
    {
        // validation for constraint: int
        if (!is_null($anzueb) && !(is_int($anzueb) || ctype_digit($anzueb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzueb, true), gettype($anzueb)), __LINE__);
        }
        $this->anzueb = $anzueb;
        return $this;
    }
    /**
     * Get anzerw value
     * @return int|null
     */
    public function getAnzerw()
    {
        return $this->anzerw;
    }
    /**
     * Set anzerw value
     * @param int $anzerw
     * @return \StructType\Pauschalenpreis
     */
    public function setAnzerw($anzerw = null)
    {
        // validation for constraint: int
        if (!is_null($anzerw) && !(is_int($anzerw) || ctype_digit($anzerw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzerw, true), gettype($anzerw)), __LINE__);
        }
        $this->anzerw = $anzerw;
        return $this;
    }
    /**
     * Get erwpreis value
     * @return int|null
     */
    public function getErwpreis()
    {
        return $this->erwpreis;
    }
    /**
     * Set erwpreis value
     * @param int $erwpreis
     * @return \StructType\Pauschalenpreis
     */
    public function setErwpreis($erwpreis = null)
    {
        // validation for constraint: int
        if (!is_null($erwpreis) && !(is_int($erwpreis) || ctype_digit($erwpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($erwpreis, true), gettype($erwpreis)), __LINE__);
        }
        $this->erwpreis = $erwpreis;
        return $this;
    }
    /**
     * Get kindbpreis value
     * @return int|null
     */
    public function getKindbpreis()
    {
        return $this->kindbpreis;
    }
    /**
     * Set kindbpreis value
     * @param int $kindbpreis
     * @return \StructType\Pauschalenpreis
     */
    public function setKindbpreis($kindbpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kindbpreis) && !(is_int($kindbpreis) || ctype_digit($kindbpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindbpreis, true), gettype($kindbpreis)), __LINE__);
        }
        $this->kindbpreis = $kindbpreis;
        return $this;
    }
    /**
     * Get kindcpreis value
     * @return int|null
     */
    public function getKindcpreis()
    {
        return $this->kindcpreis;
    }
    /**
     * Set kindcpreis value
     * @param int $kindcpreis
     * @return \StructType\Pauschalenpreis
     */
    public function setKindcpreis($kindcpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kindcpreis) && !(is_int($kindcpreis) || ctype_digit($kindcpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindcpreis, true), gettype($kindcpreis)), __LINE__);
        }
        $this->kindcpreis = $kindcpreis;
        return $this;
    }
    /**
     * Get kinddpreis value
     * @return int|null
     */
    public function getKinddpreis()
    {
        return $this->kinddpreis;
    }
    /**
     * Set kinddpreis value
     * @param int $kinddpreis
     * @return \StructType\Pauschalenpreis
     */
    public function setKinddpreis($kinddpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kinddpreis) && !(is_int($kinddpreis) || ctype_digit($kinddpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kinddpreis, true), gettype($kinddpreis)), __LINE__);
        }
        $this->kinddpreis = $kinddpreis;
        return $this;
    }
    /**
     * Get kindbavailable value
     * @return int|null
     */
    public function getKindbavailable()
    {
        return $this->kindbavailable;
    }
    /**
     * Set kindbavailable value
     * @param int $kindbavailable
     * @return \StructType\Pauschalenpreis
     */
    public function setKindbavailable($kindbavailable = null)
    {
        // validation for constraint: int
        if (!is_null($kindbavailable) && !(is_int($kindbavailable) || ctype_digit($kindbavailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindbavailable, true), gettype($kindbavailable)), __LINE__);
        }
        $this->kindbavailable = $kindbavailable;
        return $this;
    }
    /**
     * Get kindcavailable value
     * @return int|null
     */
    public function getKindcavailable()
    {
        return $this->kindcavailable;
    }
    /**
     * Set kindcavailable value
     * @param int $kindcavailable
     * @return \StructType\Pauschalenpreis
     */
    public function setKindcavailable($kindcavailable = null)
    {
        // validation for constraint: int
        if (!is_null($kindcavailable) && !(is_int($kindcavailable) || ctype_digit($kindcavailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindcavailable, true), gettype($kindcavailable)), __LINE__);
        }
        $this->kindcavailable = $kindcavailable;
        return $this;
    }
    /**
     * Get kinddavailable value
     * @return int|null
     */
    public function getKinddavailable()
    {
        return $this->kinddavailable;
    }
    /**
     * Set kinddavailable value
     * @param int $kinddavailable
     * @return \StructType\Pauschalenpreis
     */
    public function setKinddavailable($kinddavailable = null)
    {
        // validation for constraint: int
        if (!is_null($kinddavailable) && !(is_int($kinddavailable) || ctype_digit($kinddavailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kinddavailable, true), gettype($kinddavailable)), __LINE__);
        }
        $this->kinddavailable = $kinddavailable;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Pauschalenpreis
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get pauschalenzeitraum value
     * @return \StructType\Pauschalenzeitraum|null
     */
    public function getPauschalenzeitraum()
    {
        return $this->pauschalenzeitraum;
    }
    /**
     * Set pauschalenzeitraum value
     * @param \StructType\Pauschalenzeitraum $pauschalenzeitraum
     * @return \StructType\Pauschalenpreis
     */
    public function setPauschalenzeitraum(\StructType\Pauschalenzeitraum $pauschalenzeitraum = null)
    {
        $this->pauschalenzeitraum = $pauschalenzeitraum;
        return $this;
    }
    /**
     * Get pauschalenpreissegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pauschalenpreissegment[]|null
     */
    public function getPauschalenpreissegment()
    {
        return isset($this->pauschalenpreissegment) ? $this->pauschalenpreissegment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPauschalenpreissegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPauschalenpreissegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePauschalenpreissegmentForArrayConstraintsFromSetPauschalenpreissegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschalenpreisPauschalenpreissegmentItem) {
            // validation for constraint: itemType
            if (!$pauschalenpreisPauschalenpreissegmentItem instanceof \StructType\Pauschalenpreissegment) {
                $invalidValues[] = is_object($pauschalenpreisPauschalenpreissegmentItem) ? get_class($pauschalenpreisPauschalenpreissegmentItem) : sprintf('%s(%s)', gettype($pauschalenpreisPauschalenpreissegmentItem), var_export($pauschalenpreisPauschalenpreissegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pauschalenpreissegment property can only contain items of type \StructType\Pauschalenpreissegment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pauschalenpreissegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenpreissegment[] $pauschalenpreissegment
     * @return \StructType\Pauschalenpreis
     */
    public function setPauschalenpreissegment(array $pauschalenpreissegment = array())
    {
        // validation for constraint: array
        if ('' !== ($pauschalenpreissegmentArrayErrorMessage = self::validatePauschalenpreissegmentForArrayConstraintsFromSetPauschalenpreissegment($pauschalenpreissegment))) {
            throw new \InvalidArgumentException($pauschalenpreissegmentArrayErrorMessage, __LINE__);
        }
        if (is_null($pauschalenpreissegment) || (is_array($pauschalenpreissegment) && empty($pauschalenpreissegment))) {
            unset($this->pauschalenpreissegment);
        } else {
            $this->pauschalenpreissegment = $pauschalenpreissegment;
        }
        return $this;
    }
    /**
     * Add item to pauschalenpreissegment value
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenpreissegment $item
     * @return \StructType\Pauschalenpreis
     */
    public function addToPauschalenpreissegment(\StructType\Pauschalenpreissegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pauschalenpreissegment) {
            throw new \InvalidArgumentException(sprintf('The pauschalenpreissegment property can only contain items of type \StructType\Pauschalenpreissegment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pauschalenpreissegment[] = $item;
        return $this;
    }
}
