<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pauschalangebot StructType
 * @subpackage Structs
 */
class Pauschalangebot extends AbstractStructBase
{
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The katid
     * @var int
     */
    public $katid;
    /**
     * The preisid
     * @var int
     */
    public $preisid;
    /**
     * The textid
     * @var int
     */
    public $textid;
    /**
     * The zeitraumid
     * @var int
     */
    public $zeitraumid;
    /**
     * The abzuid
     * @var int
     */
    public $abzuid;
    /**
     * The gueltigvon
     * @var string
     */
    public $gueltigvon;
    /**
     * The gueltigbis
     * @var string
     */
    public $gueltigbis;
    /**
     * The anzueb
     * @var int
     */
    public $anzueb;
    /**
     * The gesamtpreis
     * @var int
     */
    public $gesamtpreis;
    /**
     * The anzerw
     * @var int
     */
    public $anzerw;
    /**
     * The anzkinder
     * @var int
     */
    public $anzkinder;
    /**
     * The anzkinda
     * @var int
     */
    public $anzkinda;
    /**
     * The anzkindb
     * @var int
     */
    public $anzkindb;
    /**
     * The anzkindc
     * @var int
     */
    public $anzkindc;
    /**
     * The anzkindd
     * @var int
     */
    public $anzkindd;
    /**
     * The alterkinda
     * @var int
     */
    public $alterkinda;
    /**
     * The alterkindb
     * @var int
     */
    public $alterkindb;
    /**
     * The alterkindc
     * @var int
     */
    public $alterkindc;
    /**
     * The alterkindd
     * @var int
     */
    public $alterkindd;
    /**
     * The erwpreis
     * @var int
     */
    public $erwpreis;
    /**
     * The kindbpreis
     * @var int
     */
    public $kindbpreis;
    /**
     * The kindcpreis
     * @var int
     */
    public $kindcpreis;
    /**
     * The kinddpreis
     * @var int
     */
    public $kinddpreis;
    /**
     * The abzuschlagart
     * @var string
     */
    public $abzuschlagart;
    /**
     * The abzuschlagbetrag
     * @var int
     */
    public $abzuschlagbetrag;
    /**
     * The abzuschlagprozent
     * @var int
     */
    public $abzuschlagprozent;
    /**
     * The abzuschlagbuchungvon
     * @var string
     */
    public $abzuschlagbuchungvon;
    /**
     * The abzuschlagbuchungbis
     * @var string
     */
    public $abzuschlagbuchungbis;
    /**
     * The abzuschlagtagevoranreisevon
     * @var int
     */
    public $abzuschlagtagevoranreisevon;
    /**
     * The abzuschlagtagevoranreisebis
     * @var int
     */
    public $abzuschlagtagevoranreisebis;
    /**
     * The titel
     * @var string
     */
    public $titel;
    /**
     * The text
     * @var string
     */
    public $text;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The berechnung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $berechnung;
    /**
     * The kinderpreise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kinderpreise;
    /**
     * The anreisen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Anabreiseregelung
     */
    public $anreisen;
    /**
     * The abreisen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Anabreiseregelung
     */
    public $abreisen;
    /**
     * The xcluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Xcluded
     */
    public $xcluded;
    /**
     * The tipauschale
     * @var int
     */
    public $tipauschale;
    /**
     * The rubrik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rubrik;
    /**
     * The verpflegung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verpflegung;
    /**
     * Constructor method for pauschalangebot
     * @uses Pauschalangebot::setPauid()
     * @uses Pauschalangebot::setOrtid()
     * @uses Pauschalangebot::setHausid()
     * @uses Pauschalangebot::setKatid()
     * @uses Pauschalangebot::setPreisid()
     * @uses Pauschalangebot::setTextid()
     * @uses Pauschalangebot::setZeitraumid()
     * @uses Pauschalangebot::setAbzuid()
     * @uses Pauschalangebot::setGueltigvon()
     * @uses Pauschalangebot::setGueltigbis()
     * @uses Pauschalangebot::setAnzueb()
     * @uses Pauschalangebot::setGesamtpreis()
     * @uses Pauschalangebot::setAnzerw()
     * @uses Pauschalangebot::setAnzkinder()
     * @uses Pauschalangebot::setAnzkinda()
     * @uses Pauschalangebot::setAnzkindb()
     * @uses Pauschalangebot::setAnzkindc()
     * @uses Pauschalangebot::setAnzkindd()
     * @uses Pauschalangebot::setAlterkinda()
     * @uses Pauschalangebot::setAlterkindb()
     * @uses Pauschalangebot::setAlterkindc()
     * @uses Pauschalangebot::setAlterkindd()
     * @uses Pauschalangebot::setErwpreis()
     * @uses Pauschalangebot::setKindbpreis()
     * @uses Pauschalangebot::setKindcpreis()
     * @uses Pauschalangebot::setKinddpreis()
     * @uses Pauschalangebot::setAbzuschlagart()
     * @uses Pauschalangebot::setAbzuschlagbetrag()
     * @uses Pauschalangebot::setAbzuschlagprozent()
     * @uses Pauschalangebot::setAbzuschlagbuchungvon()
     * @uses Pauschalangebot::setAbzuschlagbuchungbis()
     * @uses Pauschalangebot::setAbzuschlagtagevoranreisevon()
     * @uses Pauschalangebot::setAbzuschlagtagevoranreisebis()
     * @uses Pauschalangebot::setTitel()
     * @uses Pauschalangebot::setText()
     * @uses Pauschalangebot::setSprache()
     * @uses Pauschalangebot::setBerechnung()
     * @uses Pauschalangebot::setKinderpreise()
     * @uses Pauschalangebot::setAnreisen()
     * @uses Pauschalangebot::setAbreisen()
     * @uses Pauschalangebot::setXcluded()
     * @uses Pauschalangebot::setTipauschale()
     * @uses Pauschalangebot::setRubrik()
     * @uses Pauschalangebot::setVerpflegung()
     * @param int $pauid
     * @param int $ortid
     * @param int $hausid
     * @param int $katid
     * @param int $preisid
     * @param int $textid
     * @param int $zeitraumid
     * @param int $abzuid
     * @param string $gueltigvon
     * @param string $gueltigbis
     * @param int $anzueb
     * @param int $gesamtpreis
     * @param int $anzerw
     * @param int $anzkinder
     * @param int $anzkinda
     * @param int $anzkindb
     * @param int $anzkindc
     * @param int $anzkindd
     * @param int $alterkinda
     * @param int $alterkindb
     * @param int $alterkindc
     * @param int $alterkindd
     * @param int $erwpreis
     * @param int $kindbpreis
     * @param int $kindcpreis
     * @param int $kinddpreis
     * @param string $abzuschlagart
     * @param int $abzuschlagbetrag
     * @param int $abzuschlagprozent
     * @param string $abzuschlagbuchungvon
     * @param string $abzuschlagbuchungbis
     * @param int $abzuschlagtagevoranreisevon
     * @param int $abzuschlagtagevoranreisebis
     * @param string $titel
     * @param string $text
     * @param string $sprache
     * @param string $berechnung
     * @param string $kinderpreise
     * @param \StructType\Anabreiseregelung $anreisen
     * @param \StructType\Anabreiseregelung $abreisen
     * @param \StructType\Xcluded $xcluded
     * @param int $tipauschale
     * @param string $rubrik
     * @param string $verpflegung
     */
    public function __construct($pauid = null, $ortid = null, $hausid = null, $katid = null, $preisid = null, $textid = null, $zeitraumid = null, $abzuid = null, $gueltigvon = null, $gueltigbis = null, $anzueb = null, $gesamtpreis = null, $anzerw = null, $anzkinder = null, $anzkinda = null, $anzkindb = null, $anzkindc = null, $anzkindd = null, $alterkinda = null, $alterkindb = null, $alterkindc = null, $alterkindd = null, $erwpreis = null, $kindbpreis = null, $kindcpreis = null, $kinddpreis = null, $abzuschlagart = null, $abzuschlagbetrag = null, $abzuschlagprozent = null, $abzuschlagbuchungvon = null, $abzuschlagbuchungbis = null, $abzuschlagtagevoranreisevon = null, $abzuschlagtagevoranreisebis = null, $titel = null, $text = null, $sprache = null, $berechnung = null, $kinderpreise = null, \StructType\Anabreiseregelung $anreisen = null, \StructType\Anabreiseregelung $abreisen = null, \StructType\Xcluded $xcluded = null, $tipauschale = null, $rubrik = null, $verpflegung = null)
    {
        $this
            ->setPauid($pauid)
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setKatid($katid)
            ->setPreisid($preisid)
            ->setTextid($textid)
            ->setZeitraumid($zeitraumid)
            ->setAbzuid($abzuid)
            ->setGueltigvon($gueltigvon)
            ->setGueltigbis($gueltigbis)
            ->setAnzueb($anzueb)
            ->setGesamtpreis($gesamtpreis)
            ->setAnzerw($anzerw)
            ->setAnzkinder($anzkinder)
            ->setAnzkinda($anzkinda)
            ->setAnzkindb($anzkindb)
            ->setAnzkindc($anzkindc)
            ->setAnzkindd($anzkindd)
            ->setAlterkinda($alterkinda)
            ->setAlterkindb($alterkindb)
            ->setAlterkindc($alterkindc)
            ->setAlterkindd($alterkindd)
            ->setErwpreis($erwpreis)
            ->setKindbpreis($kindbpreis)
            ->setKindcpreis($kindcpreis)
            ->setKinddpreis($kinddpreis)
            ->setAbzuschlagart($abzuschlagart)
            ->setAbzuschlagbetrag($abzuschlagbetrag)
            ->setAbzuschlagprozent($abzuschlagprozent)
            ->setAbzuschlagbuchungvon($abzuschlagbuchungvon)
            ->setAbzuschlagbuchungbis($abzuschlagbuchungbis)
            ->setAbzuschlagtagevoranreisevon($abzuschlagtagevoranreisevon)
            ->setAbzuschlagtagevoranreisebis($abzuschlagtagevoranreisebis)
            ->setTitel($titel)
            ->setText($text)
            ->setSprache($sprache)
            ->setBerechnung($berechnung)
            ->setKinderpreise($kinderpreise)
            ->setAnreisen($anreisen)
            ->setAbreisen($abreisen)
            ->setXcluded($xcluded)
            ->setTipauschale($tipauschale)
            ->setRubrik($rubrik)
            ->setVerpflegung($verpflegung);
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Pauschalangebot
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Pauschalangebot
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Pauschalangebot
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get katid value
     * @return int|null
     */
    public function getKatid()
    {
        return $this->katid;
    }
    /**
     * Set katid value
     * @param int $katid
     * @return \StructType\Pauschalangebot
     */
    public function setKatid($katid = null)
    {
        // validation for constraint: int
        if (!is_null($katid) && !(is_int($katid) || ctype_digit($katid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katid, true), gettype($katid)), __LINE__);
        }
        $this->katid = $katid;
        return $this;
    }
    /**
     * Get preisid value
     * @return int|null
     */
    public function getPreisid()
    {
        return $this->preisid;
    }
    /**
     * Set preisid value
     * @param int $preisid
     * @return \StructType\Pauschalangebot
     */
    public function setPreisid($preisid = null)
    {
        // validation for constraint: int
        if (!is_null($preisid) && !(is_int($preisid) || ctype_digit($preisid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisid, true), gettype($preisid)), __LINE__);
        }
        $this->preisid = $preisid;
        return $this;
    }
    /**
     * Get textid value
     * @return int|null
     */
    public function getTextid()
    {
        return $this->textid;
    }
    /**
     * Set textid value
     * @param int $textid
     * @return \StructType\Pauschalangebot
     */
    public function setTextid($textid = null)
    {
        // validation for constraint: int
        if (!is_null($textid) && !(is_int($textid) || ctype_digit($textid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($textid, true), gettype($textid)), __LINE__);
        }
        $this->textid = $textid;
        return $this;
    }
    /**
     * Get zeitraumid value
     * @return int|null
     */
    public function getZeitraumid()
    {
        return $this->zeitraumid;
    }
    /**
     * Set zeitraumid value
     * @param int $zeitraumid
     * @return \StructType\Pauschalangebot
     */
    public function setZeitraumid($zeitraumid = null)
    {
        // validation for constraint: int
        if (!is_null($zeitraumid) && !(is_int($zeitraumid) || ctype_digit($zeitraumid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zeitraumid, true), gettype($zeitraumid)), __LINE__);
        }
        $this->zeitraumid = $zeitraumid;
        return $this;
    }
    /**
     * Get abzuid value
     * @return int|null
     */
    public function getAbzuid()
    {
        return $this->abzuid;
    }
    /**
     * Set abzuid value
     * @param int $abzuid
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuid($abzuid = null)
    {
        // validation for constraint: int
        if (!is_null($abzuid) && !(is_int($abzuid) || ctype_digit($abzuid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abzuid, true), gettype($abzuid)), __LINE__);
        }
        $this->abzuid = $abzuid;
        return $this;
    }
    /**
     * Get gueltigvon value
     * @return string|null
     */
    public function getGueltigvon()
    {
        return $this->gueltigvon;
    }
    /**
     * Set gueltigvon value
     * @param string $gueltigvon
     * @return \StructType\Pauschalangebot
     */
    public function setGueltigvon($gueltigvon = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigvon) && !is_string($gueltigvon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigvon, true), gettype($gueltigvon)), __LINE__);
        }
        $this->gueltigvon = $gueltigvon;
        return $this;
    }
    /**
     * Get gueltigbis value
     * @return string|null
     */
    public function getGueltigbis()
    {
        return $this->gueltigbis;
    }
    /**
     * Set gueltigbis value
     * @param string $gueltigbis
     * @return \StructType\Pauschalangebot
     */
    public function setGueltigbis($gueltigbis = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigbis) && !is_string($gueltigbis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigbis, true), gettype($gueltigbis)), __LINE__);
        }
        $this->gueltigbis = $gueltigbis;
        return $this;
    }
    /**
     * Get anzueb value
     * @return int|null
     */
    public function getAnzueb()
    {
        return $this->anzueb;
    }
    /**
     * Set anzueb value
     * @param int $anzueb
     * @return \StructType\Pauschalangebot
     */
    public function setAnzueb($anzueb = null)
    {
        // validation for constraint: int
        if (!is_null($anzueb) && !(is_int($anzueb) || ctype_digit($anzueb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzueb, true), gettype($anzueb)), __LINE__);
        }
        $this->anzueb = $anzueb;
        return $this;
    }
    /**
     * Get gesamtpreis value
     * @return int|null
     */
    public function getGesamtpreis()
    {
        return $this->gesamtpreis;
    }
    /**
     * Set gesamtpreis value
     * @param int $gesamtpreis
     * @return \StructType\Pauschalangebot
     */
    public function setGesamtpreis($gesamtpreis = null)
    {
        // validation for constraint: int
        if (!is_null($gesamtpreis) && !(is_int($gesamtpreis) || ctype_digit($gesamtpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamtpreis, true), gettype($gesamtpreis)), __LINE__);
        }
        $this->gesamtpreis = $gesamtpreis;
        return $this;
    }
    /**
     * Get anzerw value
     * @return int|null
     */
    public function getAnzerw()
    {
        return $this->anzerw;
    }
    /**
     * Set anzerw value
     * @param int $anzerw
     * @return \StructType\Pauschalangebot
     */
    public function setAnzerw($anzerw = null)
    {
        // validation for constraint: int
        if (!is_null($anzerw) && !(is_int($anzerw) || ctype_digit($anzerw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzerw, true), gettype($anzerw)), __LINE__);
        }
        $this->anzerw = $anzerw;
        return $this;
    }
    /**
     * Get anzkinder value
     * @return int|null
     */
    public function getAnzkinder()
    {
        return $this->anzkinder;
    }
    /**
     * Set anzkinder value
     * @param int $anzkinder
     * @return \StructType\Pauschalangebot
     */
    public function setAnzkinder($anzkinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzkinder) && !(is_int($anzkinder) || ctype_digit($anzkinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkinder, true), gettype($anzkinder)), __LINE__);
        }
        $this->anzkinder = $anzkinder;
        return $this;
    }
    /**
     * Get anzkinda value
     * @return int|null
     */
    public function getAnzkinda()
    {
        return $this->anzkinda;
    }
    /**
     * Set anzkinda value
     * @param int $anzkinda
     * @return \StructType\Pauschalangebot
     */
    public function setAnzkinda($anzkinda = null)
    {
        // validation for constraint: int
        if (!is_null($anzkinda) && !(is_int($anzkinda) || ctype_digit($anzkinda))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkinda, true), gettype($anzkinda)), __LINE__);
        }
        $this->anzkinda = $anzkinda;
        return $this;
    }
    /**
     * Get anzkindb value
     * @return int|null
     */
    public function getAnzkindb()
    {
        return $this->anzkindb;
    }
    /**
     * Set anzkindb value
     * @param int $anzkindb
     * @return \StructType\Pauschalangebot
     */
    public function setAnzkindb($anzkindb = null)
    {
        // validation for constraint: int
        if (!is_null($anzkindb) && !(is_int($anzkindb) || ctype_digit($anzkindb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkindb, true), gettype($anzkindb)), __LINE__);
        }
        $this->anzkindb = $anzkindb;
        return $this;
    }
    /**
     * Get anzkindc value
     * @return int|null
     */
    public function getAnzkindc()
    {
        return $this->anzkindc;
    }
    /**
     * Set anzkindc value
     * @param int $anzkindc
     * @return \StructType\Pauschalangebot
     */
    public function setAnzkindc($anzkindc = null)
    {
        // validation for constraint: int
        if (!is_null($anzkindc) && !(is_int($anzkindc) || ctype_digit($anzkindc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkindc, true), gettype($anzkindc)), __LINE__);
        }
        $this->anzkindc = $anzkindc;
        return $this;
    }
    /**
     * Get anzkindd value
     * @return int|null
     */
    public function getAnzkindd()
    {
        return $this->anzkindd;
    }
    /**
     * Set anzkindd value
     * @param int $anzkindd
     * @return \StructType\Pauschalangebot
     */
    public function setAnzkindd($anzkindd = null)
    {
        // validation for constraint: int
        if (!is_null($anzkindd) && !(is_int($anzkindd) || ctype_digit($anzkindd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkindd, true), gettype($anzkindd)), __LINE__);
        }
        $this->anzkindd = $anzkindd;
        return $this;
    }
    /**
     * Get alterkinda value
     * @return int|null
     */
    public function getAlterkinda()
    {
        return $this->alterkinda;
    }
    /**
     * Set alterkinda value
     * @param int $alterkinda
     * @return \StructType\Pauschalangebot
     */
    public function setAlterkinda($alterkinda = null)
    {
        // validation for constraint: int
        if (!is_null($alterkinda) && !(is_int($alterkinda) || ctype_digit($alterkinda))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterkinda, true), gettype($alterkinda)), __LINE__);
        }
        $this->alterkinda = $alterkinda;
        return $this;
    }
    /**
     * Get alterkindb value
     * @return int|null
     */
    public function getAlterkindb()
    {
        return $this->alterkindb;
    }
    /**
     * Set alterkindb value
     * @param int $alterkindb
     * @return \StructType\Pauschalangebot
     */
    public function setAlterkindb($alterkindb = null)
    {
        // validation for constraint: int
        if (!is_null($alterkindb) && !(is_int($alterkindb) || ctype_digit($alterkindb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterkindb, true), gettype($alterkindb)), __LINE__);
        }
        $this->alterkindb = $alterkindb;
        return $this;
    }
    /**
     * Get alterkindc value
     * @return int|null
     */
    public function getAlterkindc()
    {
        return $this->alterkindc;
    }
    /**
     * Set alterkindc value
     * @param int $alterkindc
     * @return \StructType\Pauschalangebot
     */
    public function setAlterkindc($alterkindc = null)
    {
        // validation for constraint: int
        if (!is_null($alterkindc) && !(is_int($alterkindc) || ctype_digit($alterkindc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterkindc, true), gettype($alterkindc)), __LINE__);
        }
        $this->alterkindc = $alterkindc;
        return $this;
    }
    /**
     * Get alterkindd value
     * @return int|null
     */
    public function getAlterkindd()
    {
        return $this->alterkindd;
    }
    /**
     * Set alterkindd value
     * @param int $alterkindd
     * @return \StructType\Pauschalangebot
     */
    public function setAlterkindd($alterkindd = null)
    {
        // validation for constraint: int
        if (!is_null($alterkindd) && !(is_int($alterkindd) || ctype_digit($alterkindd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterkindd, true), gettype($alterkindd)), __LINE__);
        }
        $this->alterkindd = $alterkindd;
        return $this;
    }
    /**
     * Get erwpreis value
     * @return int|null
     */
    public function getErwpreis()
    {
        return $this->erwpreis;
    }
    /**
     * Set erwpreis value
     * @param int $erwpreis
     * @return \StructType\Pauschalangebot
     */
    public function setErwpreis($erwpreis = null)
    {
        // validation for constraint: int
        if (!is_null($erwpreis) && !(is_int($erwpreis) || ctype_digit($erwpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($erwpreis, true), gettype($erwpreis)), __LINE__);
        }
        $this->erwpreis = $erwpreis;
        return $this;
    }
    /**
     * Get kindbpreis value
     * @return int|null
     */
    public function getKindbpreis()
    {
        return $this->kindbpreis;
    }
    /**
     * Set kindbpreis value
     * @param int $kindbpreis
     * @return \StructType\Pauschalangebot
     */
    public function setKindbpreis($kindbpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kindbpreis) && !(is_int($kindbpreis) || ctype_digit($kindbpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindbpreis, true), gettype($kindbpreis)), __LINE__);
        }
        $this->kindbpreis = $kindbpreis;
        return $this;
    }
    /**
     * Get kindcpreis value
     * @return int|null
     */
    public function getKindcpreis()
    {
        return $this->kindcpreis;
    }
    /**
     * Set kindcpreis value
     * @param int $kindcpreis
     * @return \StructType\Pauschalangebot
     */
    public function setKindcpreis($kindcpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kindcpreis) && !(is_int($kindcpreis) || ctype_digit($kindcpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kindcpreis, true), gettype($kindcpreis)), __LINE__);
        }
        $this->kindcpreis = $kindcpreis;
        return $this;
    }
    /**
     * Get kinddpreis value
     * @return int|null
     */
    public function getKinddpreis()
    {
        return $this->kinddpreis;
    }
    /**
     * Set kinddpreis value
     * @param int $kinddpreis
     * @return \StructType\Pauschalangebot
     */
    public function setKinddpreis($kinddpreis = null)
    {
        // validation for constraint: int
        if (!is_null($kinddpreis) && !(is_int($kinddpreis) || ctype_digit($kinddpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kinddpreis, true), gettype($kinddpreis)), __LINE__);
        }
        $this->kinddpreis = $kinddpreis;
        return $this;
    }
    /**
     * Get abzuschlagart value
     * @return string|null
     */
    public function getAbzuschlagart()
    {
        return $this->abzuschlagart;
    }
    /**
     * Set abzuschlagart value
     * @param string $abzuschlagart
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagart($abzuschlagart = null)
    {
        // validation for constraint: string
        if (!is_null($abzuschlagart) && !is_string($abzuschlagart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abzuschlagart, true), gettype($abzuschlagart)), __LINE__);
        }
        $this->abzuschlagart = $abzuschlagart;
        return $this;
    }
    /**
     * Get abzuschlagbetrag value
     * @return int|null
     */
    public function getAbzuschlagbetrag()
    {
        return $this->abzuschlagbetrag;
    }
    /**
     * Set abzuschlagbetrag value
     * @param int $abzuschlagbetrag
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagbetrag($abzuschlagbetrag = null)
    {
        // validation for constraint: int
        if (!is_null($abzuschlagbetrag) && !(is_int($abzuschlagbetrag) || ctype_digit($abzuschlagbetrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abzuschlagbetrag, true), gettype($abzuschlagbetrag)), __LINE__);
        }
        $this->abzuschlagbetrag = $abzuschlagbetrag;
        return $this;
    }
    /**
     * Get abzuschlagprozent value
     * @return int|null
     */
    public function getAbzuschlagprozent()
    {
        return $this->abzuschlagprozent;
    }
    /**
     * Set abzuschlagprozent value
     * @param int $abzuschlagprozent
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagprozent($abzuschlagprozent = null)
    {
        // validation for constraint: int
        if (!is_null($abzuschlagprozent) && !(is_int($abzuschlagprozent) || ctype_digit($abzuschlagprozent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abzuschlagprozent, true), gettype($abzuschlagprozent)), __LINE__);
        }
        $this->abzuschlagprozent = $abzuschlagprozent;
        return $this;
    }
    /**
     * Get abzuschlagbuchungvon value
     * @return string|null
     */
    public function getAbzuschlagbuchungvon()
    {
        return $this->abzuschlagbuchungvon;
    }
    /**
     * Set abzuschlagbuchungvon value
     * @param string $abzuschlagbuchungvon
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagbuchungvon($abzuschlagbuchungvon = null)
    {
        // validation for constraint: string
        if (!is_null($abzuschlagbuchungvon) && !is_string($abzuschlagbuchungvon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abzuschlagbuchungvon, true), gettype($abzuschlagbuchungvon)), __LINE__);
        }
        $this->abzuschlagbuchungvon = $abzuschlagbuchungvon;
        return $this;
    }
    /**
     * Get abzuschlagbuchungbis value
     * @return string|null
     */
    public function getAbzuschlagbuchungbis()
    {
        return $this->abzuschlagbuchungbis;
    }
    /**
     * Set abzuschlagbuchungbis value
     * @param string $abzuschlagbuchungbis
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagbuchungbis($abzuschlagbuchungbis = null)
    {
        // validation for constraint: string
        if (!is_null($abzuschlagbuchungbis) && !is_string($abzuschlagbuchungbis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abzuschlagbuchungbis, true), gettype($abzuschlagbuchungbis)), __LINE__);
        }
        $this->abzuschlagbuchungbis = $abzuschlagbuchungbis;
        return $this;
    }
    /**
     * Get abzuschlagtagevoranreisevon value
     * @return int|null
     */
    public function getAbzuschlagtagevoranreisevon()
    {
        return $this->abzuschlagtagevoranreisevon;
    }
    /**
     * Set abzuschlagtagevoranreisevon value
     * @param int $abzuschlagtagevoranreisevon
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagtagevoranreisevon($abzuschlagtagevoranreisevon = null)
    {
        // validation for constraint: int
        if (!is_null($abzuschlagtagevoranreisevon) && !(is_int($abzuschlagtagevoranreisevon) || ctype_digit($abzuschlagtagevoranreisevon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abzuschlagtagevoranreisevon, true), gettype($abzuschlagtagevoranreisevon)), __LINE__);
        }
        $this->abzuschlagtagevoranreisevon = $abzuschlagtagevoranreisevon;
        return $this;
    }
    /**
     * Get abzuschlagtagevoranreisebis value
     * @return int|null
     */
    public function getAbzuschlagtagevoranreisebis()
    {
        return $this->abzuschlagtagevoranreisebis;
    }
    /**
     * Set abzuschlagtagevoranreisebis value
     * @param int $abzuschlagtagevoranreisebis
     * @return \StructType\Pauschalangebot
     */
    public function setAbzuschlagtagevoranreisebis($abzuschlagtagevoranreisebis = null)
    {
        // validation for constraint: int
        if (!is_null($abzuschlagtagevoranreisebis) && !(is_int($abzuschlagtagevoranreisebis) || ctype_digit($abzuschlagtagevoranreisebis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abzuschlagtagevoranreisebis, true), gettype($abzuschlagtagevoranreisebis)), __LINE__);
        }
        $this->abzuschlagtagevoranreisebis = $abzuschlagtagevoranreisebis;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\Pauschalangebot
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Pauschalangebot
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Pauschalangebot
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get berechnung value
     * @return string|null
     */
    public function getBerechnung()
    {
        return $this->berechnung;
    }
    /**
     * Set berechnung value
     * @param string $berechnung
     * @return \StructType\Pauschalangebot
     */
    public function setBerechnung($berechnung = null)
    {
        // validation for constraint: string
        if (!is_null($berechnung) && !is_string($berechnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berechnung, true), gettype($berechnung)), __LINE__);
        }
        $this->berechnung = $berechnung;
        return $this;
    }
    /**
     * Get kinderpreise value
     * @return string|null
     */
    public function getKinderpreise()
    {
        return $this->kinderpreise;
    }
    /**
     * Set kinderpreise value
     * @param string $kinderpreise
     * @return \StructType\Pauschalangebot
     */
    public function setKinderpreise($kinderpreise = null)
    {
        // validation for constraint: string
        if (!is_null($kinderpreise) && !is_string($kinderpreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kinderpreise, true), gettype($kinderpreise)), __LINE__);
        }
        $this->kinderpreise = $kinderpreise;
        return $this;
    }
    /**
     * Get anreisen value
     * @return \StructType\Anabreiseregelung|null
     */
    public function getAnreisen()
    {
        return $this->anreisen;
    }
    /**
     * Set anreisen value
     * @param \StructType\Anabreiseregelung $anreisen
     * @return \StructType\Pauschalangebot
     */
    public function setAnreisen(\StructType\Anabreiseregelung $anreisen = null)
    {
        $this->anreisen = $anreisen;
        return $this;
    }
    /**
     * Get abreisen value
     * @return \StructType\Anabreiseregelung|null
     */
    public function getAbreisen()
    {
        return $this->abreisen;
    }
    /**
     * Set abreisen value
     * @param \StructType\Anabreiseregelung $abreisen
     * @return \StructType\Pauschalangebot
     */
    public function setAbreisen(\StructType\Anabreiseregelung $abreisen = null)
    {
        $this->abreisen = $abreisen;
        return $this;
    }
    /**
     * Get xcluded value
     * @return \StructType\Xcluded|null
     */
    public function getXcluded()
    {
        return $this->xcluded;
    }
    /**
     * Set xcluded value
     * @param \StructType\Xcluded $xcluded
     * @return \StructType\Pauschalangebot
     */
    public function setXcluded(\StructType\Xcluded $xcluded = null)
    {
        $this->xcluded = $xcluded;
        return $this;
    }
    /**
     * Get tipauschale value
     * @return int|null
     */
    public function getTipauschale()
    {
        return $this->tipauschale;
    }
    /**
     * Set tipauschale value
     * @param int $tipauschale
     * @return \StructType\Pauschalangebot
     */
    public function setTipauschale($tipauschale = null)
    {
        // validation for constraint: int
        if (!is_null($tipauschale) && !(is_int($tipauschale) || ctype_digit($tipauschale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipauschale, true), gettype($tipauschale)), __LINE__);
        }
        $this->tipauschale = $tipauschale;
        return $this;
    }
    /**
     * Get rubrik value
     * @return string|null
     */
    public function getRubrik()
    {
        return $this->rubrik;
    }
    /**
     * Set rubrik value
     * @param string $rubrik
     * @return \StructType\Pauschalangebot
     */
    public function setRubrik($rubrik = null)
    {
        // validation for constraint: string
        if (!is_null($rubrik) && !is_string($rubrik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rubrik, true), gettype($rubrik)), __LINE__);
        }
        $this->rubrik = $rubrik;
        return $this;
    }
    /**
     * Get verpflegung value
     * @return string|null
     */
    public function getVerpflegung()
    {
        return $this->verpflegung;
    }
    /**
     * Set verpflegung value
     * @param string $verpflegung
     * @return \StructType\Pauschalangebot
     */
    public function setVerpflegung($verpflegung = null)
    {
        // validation for constraint: string
        if (!is_null($verpflegung) && !is_string($verpflegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpflegung, true), gettype($verpflegung)), __LINE__);
        }
        $this->verpflegung = $verpflegung;
        return $this;
    }
}
