<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for katstamm StructType
 * @subpackage Structs
 */
class Katstamm extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * @var string
     */
    public $kurzbezeichnung;
    /**
     * Constructor method for katstamm
     * @uses Katstamm::setId()
     * @uses Katstamm::setSprache()
     * @uses Katstamm::setBezeichnung()
     * @uses Katstamm::setKurzbezeichnung()
     * @param int $id
     * @param string $sprache
     * @param string $bezeichnung
     * @param string $kurzbezeichnung
     */
    public function __construct($id = null, $sprache = null, $bezeichnung = null, $kurzbezeichnung = null)
    {
        $this
            ->setId($id)
            ->setSprache($sprache)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Katstamm
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Katstamm
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Katstamm
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return string|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * Set kurzbezeichnung value
     * @param string $kurzbezeichnung
     * @return \StructType\Katstamm
     */
    public function setKurzbezeichnung($kurzbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($kurzbezeichnung) && !is_string($kurzbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurzbezeichnung, true), gettype($kurzbezeichnung)), __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
}
