<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kategoriemitpreis StructType
 * @subpackage Structs
 */
class Kategoriemitpreis extends AbstractStructBase
{
    /**
     * The kategorie
     * @var \StructType\Kategorie
     */
    public $kategorie;
    /**
     * The eigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hauseigenschaften[]
     */
    public $eigenschaften;
    /**
     * The preismitsaison
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Preismitsaison[]
     */
    public $preismitsaison;
    /**
     * The bilder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $bilder;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kattext[]
     */
    public $beschreibung;
    /**
     * The zusatzleistungIncl
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ZusatzleistungIncl[]
     */
    public $zusatzleistungIncl;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * Constructor method for kategoriemitpreis
     * @uses Kategoriemitpreis::setKategorie()
     * @uses Kategoriemitpreis::setEigenschaften()
     * @uses Kategoriemitpreis::setPreismitsaison()
     * @uses Kategoriemitpreis::setBilder()
     * @uses Kategoriemitpreis::setBeschreibung()
     * @uses Kategoriemitpreis::setZusatzleistungIncl()
     * @uses Kategoriemitpreis::setStatus()
     * @param \StructType\Kategorie $kategorie
     * @param \StructType\Hauseigenschaften[] $eigenschaften
     * @param \StructType\Preismitsaison[] $preismitsaison
     * @param int[] $bilder
     * @param \StructType\Kattext[] $beschreibung
     * @param \StructType\ZusatzleistungIncl[] $zusatzleistungIncl
     * @param int $status
     */
    public function __construct(\StructType\Kategorie $kategorie = null, array $eigenschaften = array(), array $preismitsaison = array(), array $bilder = array(), array $beschreibung = array(), array $zusatzleistungIncl = array(), $status = null)
    {
        $this
            ->setKategorie($kategorie)
            ->setEigenschaften($eigenschaften)
            ->setPreismitsaison($preismitsaison)
            ->setBilder($bilder)
            ->setBeschreibung($beschreibung)
            ->setZusatzleistungIncl($zusatzleistungIncl)
            ->setStatus($status);
    }
    /**
     * Get kategorie value
     * @return \StructType\Kategorie|null
     */
    public function getKategorie()
    {
        return $this->kategorie;
    }
    /**
     * Set kategorie value
     * @param \StructType\Kategorie $kategorie
     * @return \StructType\Kategoriemitpreis
     */
    public function setKategorie(\StructType\Kategorie $kategorie = null)
    {
        $this->kategorie = $kategorie;
        return $this;
    }
    /**
     * Get eigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hauseigenschaften[]|null
     */
    public function getEigenschaften()
    {
        return isset($this->eigenschaften) ? $this->eigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigenschaftenForArrayConstraintsFromSetEigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategoriemitpreisEigenschaftenItem) {
            // validation for constraint: itemType
            if (!$kategoriemitpreisEigenschaftenItem instanceof \StructType\Hauseigenschaften) {
                $invalidValues[] = is_object($kategoriemitpreisEigenschaftenItem) ? get_class($kategoriemitpreisEigenschaftenItem) : sprintf('%s(%s)', gettype($kategoriemitpreisEigenschaftenItem), var_export($kategoriemitpreisEigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eigenschaften property can only contain items of type \StructType\Hauseigenschaften, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hauseigenschaften[] $eigenschaften
     * @return \StructType\Kategoriemitpreis
     */
    public function setEigenschaften(array $eigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($eigenschaftenArrayErrorMessage = self::validateEigenschaftenForArrayConstraintsFromSetEigenschaften($eigenschaften))) {
            throw new \InvalidArgumentException($eigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($eigenschaften) || (is_array($eigenschaften) && empty($eigenschaften))) {
            unset($this->eigenschaften);
        } else {
            $this->eigenschaften = $eigenschaften;
        }
        return $this;
    }
    /**
     * Add item to eigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Hauseigenschaften $item
     * @return \StructType\Kategoriemitpreis
     */
    public function addToEigenschaften(\StructType\Hauseigenschaften $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hauseigenschaften) {
            throw new \InvalidArgumentException(sprintf('The eigenschaften property can only contain items of type \StructType\Hauseigenschaften, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eigenschaften[] = $item;
        return $this;
    }
    /**
     * Get preismitsaison value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Preismitsaison[]|null
     */
    public function getPreismitsaison()
    {
        return isset($this->preismitsaison) ? $this->preismitsaison : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPreismitsaison method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreismitsaison method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreismitsaisonForArrayConstraintsFromSetPreismitsaison(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategoriemitpreisPreismitsaisonItem) {
            // validation for constraint: itemType
            if (!$kategoriemitpreisPreismitsaisonItem instanceof \StructType\Preismitsaison) {
                $invalidValues[] = is_object($kategoriemitpreisPreismitsaisonItem) ? get_class($kategoriemitpreisPreismitsaisonItem) : sprintf('%s(%s)', gettype($kategoriemitpreisPreismitsaisonItem), var_export($kategoriemitpreisPreismitsaisonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The preismitsaison property can only contain items of type \StructType\Preismitsaison, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set preismitsaison value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Preismitsaison[] $preismitsaison
     * @return \StructType\Kategoriemitpreis
     */
    public function setPreismitsaison(array $preismitsaison = array())
    {
        // validation for constraint: array
        if ('' !== ($preismitsaisonArrayErrorMessage = self::validatePreismitsaisonForArrayConstraintsFromSetPreismitsaison($preismitsaison))) {
            throw new \InvalidArgumentException($preismitsaisonArrayErrorMessage, __LINE__);
        }
        if (is_null($preismitsaison) || (is_array($preismitsaison) && empty($preismitsaison))) {
            unset($this->preismitsaison);
        } else {
            $this->preismitsaison = $preismitsaison;
        }
        return $this;
    }
    /**
     * Add item to preismitsaison value
     * @throws \InvalidArgumentException
     * @param \StructType\Preismitsaison $item
     * @return \StructType\Kategoriemitpreis
     */
    public function addToPreismitsaison(\StructType\Preismitsaison $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Preismitsaison) {
            throw new \InvalidArgumentException(sprintf('The preismitsaison property can only contain items of type \StructType\Preismitsaison, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->preismitsaison[] = $item;
        return $this;
    }
    /**
     * Get bilder value
     * @return int[]|null
     */
    public function getBilder()
    {
        return $this->bilder;
    }
    /**
     * This method is responsible for validating the values passed to the setBilder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilderForArrayConstraintsFromSetBilder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategoriemitpreisBilderItem) {
            // validation for constraint: itemType
            if (!(is_int($kategoriemitpreisBilderItem) || ctype_digit($kategoriemitpreisBilderItem))) {
                $invalidValues[] = is_object($kategoriemitpreisBilderItem) ? get_class($kategoriemitpreisBilderItem) : sprintf('%s(%s)', gettype($kategoriemitpreisBilderItem), var_export($kategoriemitpreisBilderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bilder property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bilder value
     * @throws \InvalidArgumentException
     * @param int[] $bilder
     * @return \StructType\Kategoriemitpreis
     */
    public function setBilder(array $bilder = array())
    {
        // validation for constraint: array
        if ('' !== ($bilderArrayErrorMessage = self::validateBilderForArrayConstraintsFromSetBilder($bilder))) {
            throw new \InvalidArgumentException($bilderArrayErrorMessage, __LINE__);
        }
        $this->bilder = $bilder;
        return $this;
    }
    /**
     * Add item to bilder value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Kategoriemitpreis
     */
    public function addToBilder($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The bilder property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bilder[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kattext[]|null
     */
    public function getBeschreibung()
    {
        return isset($this->beschreibung) ? $this->beschreibung : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategoriemitpreisBeschreibungItem) {
            // validation for constraint: itemType
            if (!$kategoriemitpreisBeschreibungItem instanceof \StructType\Kattext) {
                $invalidValues[] = is_object($kategoriemitpreisBeschreibungItem) ? get_class($kategoriemitpreisBeschreibungItem) : sprintf('%s(%s)', gettype($kategoriemitpreisBeschreibungItem), var_export($kategoriemitpreisBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\Kattext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kattext[] $beschreibung
     * @return \StructType\Kategoriemitpreis
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        if (is_null($beschreibung) || (is_array($beschreibung) && empty($beschreibung))) {
            unset($this->beschreibung);
        } else {
            $this->beschreibung = $beschreibung;
        }
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\Kattext $item
     * @return \StructType\Kategoriemitpreis
     */
    public function addToBeschreibung(\StructType\Kattext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kattext) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\Kattext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get zusatzleistungIncl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ZusatzleistungIncl[]|null
     */
    public function getZusatzleistungIncl()
    {
        return isset($this->zusatzleistungIncl) ? $this->zusatzleistungIncl : null;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzleistungIncl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzleistungIncl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzleistungInclForArrayConstraintsFromSetZusatzleistungIncl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategoriemitpreisZusatzleistungInclItem) {
            // validation for constraint: itemType
            if (!$kategoriemitpreisZusatzleistungInclItem instanceof \StructType\ZusatzleistungIncl) {
                $invalidValues[] = is_object($kategoriemitpreisZusatzleistungInclItem) ? get_class($kategoriemitpreisZusatzleistungInclItem) : sprintf('%s(%s)', gettype($kategoriemitpreisZusatzleistungInclItem), var_export($kategoriemitpreisZusatzleistungInclItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzleistungIncl property can only contain items of type \StructType\ZusatzleistungIncl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzleistungIncl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ZusatzleistungIncl[] $zusatzleistungIncl
     * @return \StructType\Kategoriemitpreis
     */
    public function setZusatzleistungIncl(array $zusatzleistungIncl = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzleistungInclArrayErrorMessage = self::validateZusatzleistungInclForArrayConstraintsFromSetZusatzleistungIncl($zusatzleistungIncl))) {
            throw new \InvalidArgumentException($zusatzleistungInclArrayErrorMessage, __LINE__);
        }
        if (is_null($zusatzleistungIncl) || (is_array($zusatzleistungIncl) && empty($zusatzleistungIncl))) {
            unset($this->zusatzleistungIncl);
        } else {
            $this->zusatzleistungIncl = $zusatzleistungIncl;
        }
        return $this;
    }
    /**
     * Add item to zusatzleistungIncl value
     * @throws \InvalidArgumentException
     * @param \StructType\ZusatzleistungIncl $item
     * @return \StructType\Kategoriemitpreis
     */
    public function addToZusatzleistungIncl(\StructType\ZusatzleistungIncl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ZusatzleistungIncl) {
            throw new \InvalidArgumentException(sprintf('The zusatzleistungIncl property can only contain items of type \StructType\ZusatzleistungIncl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzleistungIncl[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Kategoriemitpreis
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
