<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSaisonen StructType
 * Meta information extracted from the WSDL
 * - type: tns:getSaisonen
 * @subpackage Structs
 */
class GetSaisonen extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Login
     */
    public $login;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * Constructor method for getSaisonen
     * @uses GetSaisonen::setLogin()
     * @uses GetSaisonen::setHausid()
     * @param \StructType\Login $login
     * @param int $hausid
     */
    public function __construct(\StructType\Login $login = null, $hausid = null)
    {
        $this
            ->setLogin($login)
            ->setHausid($hausid);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetSaisonen
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\GetSaisonen
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
}
