<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anrede StructType
 * @subpackage Structs
 */
class Anrede extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The kuerzel
     * @var string
     */
    public $kuerzel;
    /**
     * The anrede
     * @var string
     */
    public $anrede;
    /**
     * The briefanrede
     * @var string
     */
    public $briefanrede;
    /**
     * The personenanrede
     * @var int
     */
    public $personenanrede;
    /**
     * The geschlecht
     * @var string
     */
    public $geschlecht;
    /**
     * Constructor method for anrede
     * @uses Anrede::setId()
     * @uses Anrede::setSprache()
     * @uses Anrede::setKuerzel()
     * @uses Anrede::setAnrede()
     * @uses Anrede::setBriefanrede()
     * @uses Anrede::setPersonenanrede()
     * @uses Anrede::setGeschlecht()
     * @param int $id
     * @param string $sprache
     * @param string $kuerzel
     * @param string $anrede
     * @param string $briefanrede
     * @param int $personenanrede
     * @param string $geschlecht
     */
    public function __construct($id = null, $sprache = null, $kuerzel = null, $anrede = null, $briefanrede = null, $personenanrede = null, $geschlecht = null)
    {
        $this
            ->setId($id)
            ->setSprache($sprache)
            ->setKuerzel($kuerzel)
            ->setAnrede($anrede)
            ->setBriefanrede($briefanrede)
            ->setPersonenanrede($personenanrede)
            ->setGeschlecht($geschlecht);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Anrede
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Anrede
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get kuerzel value
     * @return string|null
     */
    public function getKuerzel()
    {
        return $this->kuerzel;
    }
    /**
     * Set kuerzel value
     * @param string $kuerzel
     * @return \StructType\Anrede
     */
    public function setKuerzel($kuerzel = null)
    {
        // validation for constraint: string
        if (!is_null($kuerzel) && !is_string($kuerzel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kuerzel, true), gettype($kuerzel)), __LINE__);
        }
        $this->kuerzel = $kuerzel;
        return $this;
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @param string $anrede
     * @return \StructType\Anrede
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: string
        if (!is_null($anrede) && !is_string($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anrede, true), gettype($anrede)), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get briefanrede value
     * @return string|null
     */
    public function getBriefanrede()
    {
        return $this->briefanrede;
    }
    /**
     * Set briefanrede value
     * @param string $briefanrede
     * @return \StructType\Anrede
     */
    public function setBriefanrede($briefanrede = null)
    {
        // validation for constraint: string
        if (!is_null($briefanrede) && !is_string($briefanrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($briefanrede, true), gettype($briefanrede)), __LINE__);
        }
        $this->briefanrede = $briefanrede;
        return $this;
    }
    /**
     * Get personenanrede value
     * @return int|null
     */
    public function getPersonenanrede()
    {
        return $this->personenanrede;
    }
    /**
     * Set personenanrede value
     * @param int $personenanrede
     * @return \StructType\Anrede
     */
    public function setPersonenanrede($personenanrede = null)
    {
        // validation for constraint: int
        if (!is_null($personenanrede) && !(is_int($personenanrede) || ctype_digit($personenanrede))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personenanrede, true), gettype($personenanrede)), __LINE__);
        }
        $this->personenanrede = $personenanrede;
        return $this;
    }
    /**
     * Get geschlecht value
     * @return string|null
     */
    public function getGeschlecht()
    {
        return $this->geschlecht;
    }
    /**
     * Set geschlecht value
     * @param string $geschlecht
     * @return \StructType\Anrede
     */
    public function setGeschlecht($geschlecht = null)
    {
        // validation for constraint: string
        if (!is_null($geschlecht) && !is_string($geschlecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geschlecht, true), gettype($geschlecht)), __LINE__);
        }
        $this->geschlecht = $geschlecht;
        return $this;
    }
}
