<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getKategorien
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorien $parameters
     * @return \StructType\GetKategorienResponse|bool
     */
    public function getKategorien(\StructType\GetKategorien $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorien($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVersion $parameters
     * @return \StructType\GetVersionResponse|bool
     */
    public function getVersion(\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrte
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrte $parameters
     * @return \StructType\GetOrteResponse|bool
     */
    public function getOrte(\StructType\GetOrte $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrte($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMeldefristen4Php
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMeldefristen4Php $parameters
     * @return \StructType\GetMeldefristen4PhpResponse|bool
     */
    public function getMeldefristen4Php(\StructType\GetMeldefristen4Php $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMeldefristen4Php($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPauschalen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPauschalen $parameters
     * @return \StructType\GetPauschalenResponse|bool
     */
    public function getPauschalen(\StructType\GetPauschalen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPauschalen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGGVZDaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGGVZDaten $parameters
     * @return \StructType\GetGGVZDatenResponse|bool
     */
    public function getGGVZDaten(\StructType\GetGGVZDaten $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGGVZDaten($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHaus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHaus $parameters
     * @return \StructType\GetHausResponse|bool
     */
    public function getHaus(\StructType\GetHaus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHaus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausIds $parameters
     * @return \StructType\GetHausIdsResponse|bool
     */
    public function getHausIds(\StructType\GetHausIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHaustext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHaustext $parameters
     * @return \StructType\GetHaustextResponse|bool
     */
    public function getHaustext(\StructType\GetHaustext $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHaustext($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKurzonen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKurzonen $parameters
     * @return \StructType\GetKurzonenResponse|bool
     */
    public function getKurzonen(\StructType\GetKurzonen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKurzonen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLaender
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLaender $parameters
     * @return \StructType\GetLaenderResponse|bool
     */
    public function getLaender(\StructType\GetLaender $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLaender($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrtsteile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrtsteile $parameters
     * @return \StructType\GetOrtsteileResponse|bool
     */
    public function getOrtsteile(\StructType\GetOrtsteile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrtsteile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaison
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaison $parameters
     * @return \StructType\GetSaisonResponse|bool
     */
    public function getSaison(\StructType\GetSaison $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaison($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaisonen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaisonen $parameters
     * @return \StructType\GetSaisonenResponse|bool
     */
    public function getSaisonen(\StructType\GetSaisonen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaisonen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSprachen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSprachen $parameters
     * @return \StructType\GetSprachenResponse|bool
     */
    public function getSprachen(\StructType\GetSprachen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSprachen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTarife
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTarife $parameters
     * @return \StructType\GetTarifeResponse|bool
     */
    public function getTarife(\StructType\GetTarife $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTarife($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChanges $parameters
     * @return \StructType\GetChangesResponse|bool
     */
    public function getChanges(\StructType\GetChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBelegungen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBelegungen $parameters
     * @return \StructType\GetBelegungenResponse|bool
     */
    public function getBelegungen(\StructType\GetBelegungen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBelegungen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausbilderMetadaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausbilderMetadaten $parameters
     * @return \StructType\GetHausbilderMetadatenResponse|bool
     */
    public function getHausbilderMetadaten(\StructType\GetHausbilderMetadaten $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausbilderMetadaten($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKategorieInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorieInfo $parameters
     * @return \StructType\GetKategorieInfoResponse|bool
     */
    public function getKategorieInfo(\StructType\GetKategorieInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorieInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProspekteListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProspekteListe $parameters
     * @return \StructType\GetProspekteListeResponse|bool
     */
    public function getProspekteListe(\StructType\GetProspekteListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProspekteListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausEigenschaftenstamm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausEigenschaftenstamm $parameters
     * @return \StructType\GetHausEigenschaftenstammResponse|bool
     */
    public function getHausEigenschaftenstamm(\StructType\GetHausEigenschaftenstamm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausEigenschaftenstamm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrtsteileListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrtsteileListe $parameters
     * @return \StructType\GetOrtsteileListeResponse|bool
     */
    public function getOrtsteileListe(\StructType\GetOrtsteileListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrtsteileListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausbilderListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausbilderListe $parameters
     * @return \StructType\GetHausbilderListeResponse|bool
     */
    public function getHausbilderListe(\StructType\GetHausbilderListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausbilderListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBildklassenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBildklassenListe $parameters
     * @return \StructType\GetBildklassenListeResponse|bool
     */
    public function getBildklassenListe(\StructType\GetBildklassenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBildklassenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLaenderListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLaenderListe $parameters
     * @return \StructType\GetLaenderListeResponse|bool
     */
    public function getLaenderListe(\StructType\GetLaenderListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLaenderListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWohneinheitenBeschreibung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWohneinheitenBeschreibung $parameters
     * @return \StructType\GetWohneinheitenBeschreibungResponse|bool
     */
    public function getWohneinheitenBeschreibung(\StructType\GetWohneinheitenBeschreibung $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWohneinheitenBeschreibung($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKategorieEigenschaftenstamm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorieEigenschaftenstamm $parameters
     * @return \StructType\GetKategorieEigenschaftenstammResponse|bool
     */
    public function getKategorieEigenschaftenstamm(\StructType\GetKategorieEigenschaftenstamm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorieEigenschaftenstamm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWohneinheitenKategoriestamm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWohneinheitenKategoriestamm $parameters
     * @return \StructType\GetWohneinheitenKategoriestammResponse|bool
     */
    public function getWohneinheitenKategoriestamm(\StructType\GetWohneinheitenKategoriestamm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWohneinheitenKategoriestamm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMeldefristen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMeldefristen $parameters
     * @return \StructType\GetMeldefristenResponse|bool
     */
    public function getMeldefristen(\StructType\GetMeldefristen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMeldefristen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausEigenschaftenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausEigenschaftenListe $parameters
     * @return \StructType\GetHausEigenschaftenListeResponse|bool
     */
    public function getHausEigenschaftenListe(\StructType\GetHausEigenschaftenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausEigenschaftenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnredenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnredenListe $parameters
     * @return \StructType\GetAnredenListeResponse|bool
     */
    public function getAnredenListe(\StructType\GetAnredenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnredenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBezirkeListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBezirkeListe $parameters
     * @return \StructType\GetBezirkeListeResponse|bool
     */
    public function getBezirkeListe(\StructType\GetBezirkeListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBezirkeListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausKategorieListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausKategorieListe $parameters
     * @return \StructType\GetHausKategorieListeResponse|bool
     */
    public function getHausKategorieListe(\StructType\GetHausKategorieListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausKategorieListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausKategoriestamm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausKategoriestamm $parameters
     * @return \StructType\GetHausKategoriestammResponse|bool
     */
    public function getHausKategoriestamm(\StructType\GetHausKategoriestamm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausKategoriestamm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnredenstamm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnredenstamm $parameters
     * @return \StructType\GetAnredenstammResponse|bool
     */
    public function getAnredenstamm(\StructType\GetAnredenstamm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnredenstamm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZusatzleistungListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZusatzleistungListe $parameters
     * @return \StructType\GetZusatzleistungListeResponse|bool
     */
    public function getZusatzleistungListe(\StructType\GetZusatzleistungListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getZusatzleistungListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaisonListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaisonListe $parameters
     * @return \StructType\GetSaisonListeResponse|bool
     */
    public function getSaisonListe(\StructType\GetSaisonListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaisonListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSprachenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSprachenListe $parameters
     * @return \StructType\GetSprachenListeResponse|bool
     */
    public function getSprachenListe(\StructType\GetSprachenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSprachenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKategorieEigenschaften
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorieEigenschaften $parameters
     * @return \StructType\GetKategorieEigenschaftenResponse|bool
     */
    public function getKategorieEigenschaften(\StructType\GetKategorieEigenschaften $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorieEigenschaften($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKategorieBezeichnung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorieBezeichnung $parameters
     * @return \StructType\GetKategorieBezeichnungResponse|bool
     */
    public function getKategorieBezeichnung(\StructType\GetKategorieBezeichnung $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorieBezeichnung($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBildklassen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBildklassen $parameters
     * @return \StructType\GetBildklassenResponse|bool
     */
    public function getBildklassen(\StructType\GetBildklassen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBildklassen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKategorieEigenschaftenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorieEigenschaftenListe $parameters
     * @return \StructType\GetKategorieEigenschaftenListeResponse|bool
     */
    public function getKategorieEigenschaftenListe(\StructType\GetKategorieEigenschaftenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKategorieEigenschaftenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWintop4Ortkuerzel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWintop4Ortkuerzel $parameters
     * @return \StructType\GetWintop4OrtkuerzelResponse|bool
     */
    public function getWintop4Ortkuerzel(\StructType\GetWintop4Ortkuerzel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWintop4Ortkuerzel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKurzonenListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKurzonenListe $parameters
     * @return \StructType\GetKurzonenListeResponse|bool
     */
    public function getKurzonenListe(\StructType\GetKurzonenListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKurzonenListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSaisonListeMitZeitraum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaisonListeMitZeitraum $parameters
     * @return \StructType\GetSaisonListeMitZeitraumResponse|bool
     */
    public function getSaisonListeMitZeitraum(\StructType\GetSaisonListeMitZeitraum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSaisonListeMitZeitraum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHausprospekteListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHausprospekteListe $parameters
     * @return \StructType\GetHausprospekteListeResponse|bool
     */
    public function getHausprospekteListe(\StructType\GetHausprospekteListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHausprospekteListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTarife4Php
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTarife4Php $parameters
     * @return \StructType\GetTarife4PhpResponse|bool
     */
    public function getTarife4Php(\StructType\GetTarife4Php $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTarife4Php($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChanges4Php
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChanges4Php $parameters
     * @return \StructType\GetChanges4PhpResponse|bool
     */
    public function getChanges4Php(\StructType\GetChanges4Php $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getChanges4Php($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllPauschalen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPauschalen $parameters
     * @return \StructType\GetAllPauschalenResponse|bool
     */
    public function getAllPauschalen(\StructType\GetAllPauschalen $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllPauschalen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServerTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServerTime $parameters
     * @return \StructType\GetServerTimeResponse|bool
     */
    public function getServerTime(\StructType\GetServerTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getServerTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBezirke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBezirke $parameters
     * @return \StructType\GetBezirkeResponse|bool
     */
    public function getBezirke(\StructType\GetBezirke $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBezirke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllPauschalenResponse|\StructType\GetAnredenListeResponse|\StructType\GetAnredenstammResponse|\StructType\GetBelegungenResponse|\StructType\GetBezirkeListeResponse|\StructType\GetBezirkeResponse|\StructType\GetBildklassenListeResponse|\StructType\GetBildklassenResponse|\StructType\GetChanges4PhpResponse|\StructType\GetChangesResponse|\StructType\GetGGVZDatenResponse|\StructType\GetHausbilderListeResponse|\StructType\GetHausbilderMetadatenResponse|\StructType\GetHausEigenschaftenListeResponse|\StructType\GetHausEigenschaftenstammResponse|\StructType\GetHausIdsResponse|\StructType\GetHausKategorieListeResponse|\StructType\GetHausKategoriestammResponse|\StructType\GetHausprospekteListeResponse|\StructType\GetHausResponse|\StructType\GetHaustextResponse|\StructType\GetKategorieBezeichnungResponse|\StructType\GetKategorieEigenschaftenListeResponse|\StructType\GetKategorieEigenschaftenResponse|\StructType\GetKategorieEigenschaftenstammResponse|\StructType\GetKategorieInfoResponse|\StructType\GetKategorienResponse|\StructType\GetKurzonenListeResponse|\StructType\GetKurzonenResponse|\StructType\GetLaenderListeResponse|\StructType\GetLaenderResponse|\StructType\GetMeldefristen4PhpResponse|\StructType\GetMeldefristenResponse|\StructType\GetOrteResponse|\StructType\GetOrtsteileListeResponse|\StructType\GetOrtsteileResponse|\StructType\GetPauschalenResponse|\StructType\GetProspekteListeResponse|\StructType\GetSaisonenResponse|\StructType\GetSaisonListeMitZeitraumResponse|\StructType\GetSaisonListeResponse|\StructType\GetSaisonResponse|\StructType\GetServerTimeResponse|\StructType\GetSprachenListeResponse|\StructType\GetSprachenResponse|\StructType\GetTarife4PhpResponse|\StructType\GetTarifeResponse|\StructType\GetVersionResponse|\StructType\GetWintop4OrtkuerzelResponse|\StructType\GetWohneinheitenBeschreibungResponse|\StructType\GetWohneinheitenKategoriestammResponse|\StructType\GetZusatzleistungListeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
