<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for return StructType
 * @subpackage Structs
 */
class _return extends AbstractStructBase
{
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The kategorieeinhaus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kategorieeinhaus[]
     */
    public $kategorieeinhaus;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Ort[]
     */
    public $ort;
    /**
     * Constructor method for return
     * @uses _return::setHausid()
     * @uses _return::setKategorieeinhaus()
     * @uses _return::setOrt()
     * @param int $hausid
     * @param \StructType\Kategorieeinhaus[] $kategorieeinhaus
     * @param \StructType\Ort[] $ort
     */
    public function __construct($hausid = null, array $kategorieeinhaus = array(), array $ort = array())
    {
        $this
            ->setHausid($hausid)
            ->setKategorieeinhaus($kategorieeinhaus)
            ->setOrt($ort);
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\_return
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get kategorieeinhaus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kategorieeinhaus[]|null
     */
    public function getKategorieeinhaus()
    {
        return isset($this->kategorieeinhaus) ? $this->kategorieeinhaus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorieeinhaus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorieeinhaus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieeinhausForArrayConstraintsFromSetKategorieeinhaus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnKategorieeinhausItem) {
            // validation for constraint: itemType
            if (!$returnKategorieeinhausItem instanceof \StructType\Kategorieeinhaus) {
                $invalidValues[] = is_object($returnKategorieeinhausItem) ? get_class($returnKategorieeinhausItem) : sprintf('%s(%s)', gettype($returnKategorieeinhausItem), var_export($returnKategorieeinhausItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorieeinhaus property can only contain items of type \StructType\Kategorieeinhaus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorieeinhaus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kategorieeinhaus[] $kategorieeinhaus
     * @return \StructType\_return
     */
    public function setKategorieeinhaus(array $kategorieeinhaus = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieeinhausArrayErrorMessage = self::validateKategorieeinhausForArrayConstraintsFromSetKategorieeinhaus($kategorieeinhaus))) {
            throw new \InvalidArgumentException($kategorieeinhausArrayErrorMessage, __LINE__);
        }
        if (is_null($kategorieeinhaus) || (is_array($kategorieeinhaus) && empty($kategorieeinhaus))) {
            unset($this->kategorieeinhaus);
        } else {
            $this->kategorieeinhaus = $kategorieeinhaus;
        }
        return $this;
    }
    /**
     * Add item to kategorieeinhaus value
     * @throws \InvalidArgumentException
     * @param \StructType\Kategorieeinhaus $item
     * @return \StructType\_return
     */
    public function addToKategorieeinhaus(\StructType\Kategorieeinhaus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kategorieeinhaus) {
            throw new \InvalidArgumentException(sprintf('The kategorieeinhaus property can only contain items of type \StructType\Kategorieeinhaus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorieeinhaus[] = $item;
        return $this;
    }
    /**
     * Get ort value
     * @return \StructType\Ort[]|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * This method is responsible for validating the values passed to the setOrt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrtForArrayConstraintsFromSetOrt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnOrtItem) {
            // validation for constraint: itemType
            if (!$returnOrtItem instanceof \StructType\Ort) {
                $invalidValues[] = is_object($returnOrtItem) ? get_class($returnOrtItem) : sprintf('%s(%s)', gettype($returnOrtItem), var_export($returnOrtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ort property can only contain items of type \StructType\Ort, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ort value
     * @throws \InvalidArgumentException
     * @param \StructType\Ort[] $ort
     * @return \StructType\_return
     */
    public function setOrt(array $ort = array())
    {
        // validation for constraint: array
        if ('' !== ($ortArrayErrorMessage = self::validateOrtForArrayConstraintsFromSetOrt($ort))) {
            throw new \InvalidArgumentException($ortArrayErrorMessage, __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Add item to ort value
     * @throws \InvalidArgumentException
     * @param \StructType\Ort $item
     * @return \StructType\_return
     */
    public function addToOrt(\StructType\Ort $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ort) {
            throw new \InvalidArgumentException(sprintf('The ort property can only contain items of type \StructType\Ort, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ort[] = $item;
        return $this;
    }
}
