<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zusatzleistung StructType
 * @subpackage Structs
 */
class Zusatzleistung extends AbstractStructBase
{
    /**
     * The zusatzid
     * @var int
     */
    public $zusatzid;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The saisonid
     * @var int
     */
    public $saisonid;
    /**
     * The preiserw
     * @var int
     */
    public $preiserw;
    /**
     * The preiskindb
     * @var int
     */
    public $preiskindb;
    /**
     * The preiskindc
     * @var int
     */
    public $preiskindc;
    /**
     * The preiskindd
     * @var int
     */
    public $preiskindd;
    /**
     * The einzelpreis
     * @var int
     */
    public $einzelpreis;
    /**
     * The preisproperson
     * @var bool
     */
    public $preisproperson;
    /**
     * The preispronacht
     * @var bool
     */
    public $preispronacht;
    /**
     * The typid
     * @var int
     */
    public $typid;
    /**
     * The gueltigab
     * @var string
     */
    public $gueltigab;
    /**
     * The gueltigbis
     * @var string
     */
    public $gueltigbis;
    /**
     * The lastchange
     * @var string
     */
    public $lastchange;
    /**
     * The zusatzbezeichnung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Zusatzbezeichnung[]
     */
    public $zusatzbezeichnung;
    /**
     * Constructor method for zusatzleistung
     * @uses Zusatzleistung::setZusatzid()
     * @uses Zusatzleistung::setBezeichnung()
     * @uses Zusatzleistung::setSaisonid()
     * @uses Zusatzleistung::setPreiserw()
     * @uses Zusatzleistung::setPreiskindb()
     * @uses Zusatzleistung::setPreiskindc()
     * @uses Zusatzleistung::setPreiskindd()
     * @uses Zusatzleistung::setEinzelpreis()
     * @uses Zusatzleistung::setPreisproperson()
     * @uses Zusatzleistung::setPreispronacht()
     * @uses Zusatzleistung::setTypid()
     * @uses Zusatzleistung::setGueltigab()
     * @uses Zusatzleistung::setGueltigbis()
     * @uses Zusatzleistung::setLastchange()
     * @uses Zusatzleistung::setZusatzbezeichnung()
     * @param int $zusatzid
     * @param string $bezeichnung
     * @param int $saisonid
     * @param int $preiserw
     * @param int $preiskindb
     * @param int $preiskindc
     * @param int $preiskindd
     * @param int $einzelpreis
     * @param bool $preisproperson
     * @param bool $preispronacht
     * @param int $typid
     * @param string $gueltigab
     * @param string $gueltigbis
     * @param string $lastchange
     * @param \StructType\Zusatzbezeichnung[] $zusatzbezeichnung
     */
    public function __construct($zusatzid = null, $bezeichnung = null, $saisonid = null, $preiserw = null, $preiskindb = null, $preiskindc = null, $preiskindd = null, $einzelpreis = null, $preisproperson = null, $preispronacht = null, $typid = null, $gueltigab = null, $gueltigbis = null, $lastchange = null, array $zusatzbezeichnung = array())
    {
        $this
            ->setZusatzid($zusatzid)
            ->setBezeichnung($bezeichnung)
            ->setSaisonid($saisonid)
            ->setPreiserw($preiserw)
            ->setPreiskindb($preiskindb)
            ->setPreiskindc($preiskindc)
            ->setPreiskindd($preiskindd)
            ->setEinzelpreis($einzelpreis)
            ->setPreisproperson($preisproperson)
            ->setPreispronacht($preispronacht)
            ->setTypid($typid)
            ->setGueltigab($gueltigab)
            ->setGueltigbis($gueltigbis)
            ->setLastchange($lastchange)
            ->setZusatzbezeichnung($zusatzbezeichnung);
    }
    /**
     * Get zusatzid value
     * @return int|null
     */
    public function getZusatzid()
    {
        return $this->zusatzid;
    }
    /**
     * Set zusatzid value
     * @param int $zusatzid
     * @return \StructType\Zusatzleistung
     */
    public function setZusatzid($zusatzid = null)
    {
        // validation for constraint: int
        if (!is_null($zusatzid) && !(is_int($zusatzid) || ctype_digit($zusatzid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zusatzid, true), gettype($zusatzid)), __LINE__);
        }
        $this->zusatzid = $zusatzid;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Zusatzleistung
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get saisonid value
     * @return int|null
     */
    public function getSaisonid()
    {
        return $this->saisonid;
    }
    /**
     * Set saisonid value
     * @param int $saisonid
     * @return \StructType\Zusatzleistung
     */
    public function setSaisonid($saisonid = null)
    {
        // validation for constraint: int
        if (!is_null($saisonid) && !(is_int($saisonid) || ctype_digit($saisonid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saisonid, true), gettype($saisonid)), __LINE__);
        }
        $this->saisonid = $saisonid;
        return $this;
    }
    /**
     * Get preiserw value
     * @return int|null
     */
    public function getPreiserw()
    {
        return $this->preiserw;
    }
    /**
     * Set preiserw value
     * @param int $preiserw
     * @return \StructType\Zusatzleistung
     */
    public function setPreiserw($preiserw = null)
    {
        // validation for constraint: int
        if (!is_null($preiserw) && !(is_int($preiserw) || ctype_digit($preiserw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiserw, true), gettype($preiserw)), __LINE__);
        }
        $this->preiserw = $preiserw;
        return $this;
    }
    /**
     * Get preiskindb value
     * @return int|null
     */
    public function getPreiskindb()
    {
        return $this->preiskindb;
    }
    /**
     * Set preiskindb value
     * @param int $preiskindb
     * @return \StructType\Zusatzleistung
     */
    public function setPreiskindb($preiskindb = null)
    {
        // validation for constraint: int
        if (!is_null($preiskindb) && !(is_int($preiskindb) || ctype_digit($preiskindb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiskindb, true), gettype($preiskindb)), __LINE__);
        }
        $this->preiskindb = $preiskindb;
        return $this;
    }
    /**
     * Get preiskindc value
     * @return int|null
     */
    public function getPreiskindc()
    {
        return $this->preiskindc;
    }
    /**
     * Set preiskindc value
     * @param int $preiskindc
     * @return \StructType\Zusatzleistung
     */
    public function setPreiskindc($preiskindc = null)
    {
        // validation for constraint: int
        if (!is_null($preiskindc) && !(is_int($preiskindc) || ctype_digit($preiskindc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiskindc, true), gettype($preiskindc)), __LINE__);
        }
        $this->preiskindc = $preiskindc;
        return $this;
    }
    /**
     * Get preiskindd value
     * @return int|null
     */
    public function getPreiskindd()
    {
        return $this->preiskindd;
    }
    /**
     * Set preiskindd value
     * @param int $preiskindd
     * @return \StructType\Zusatzleistung
     */
    public function setPreiskindd($preiskindd = null)
    {
        // validation for constraint: int
        if (!is_null($preiskindd) && !(is_int($preiskindd) || ctype_digit($preiskindd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiskindd, true), gettype($preiskindd)), __LINE__);
        }
        $this->preiskindd = $preiskindd;
        return $this;
    }
    /**
     * Get einzelpreis value
     * @return int|null
     */
    public function getEinzelpreis()
    {
        return $this->einzelpreis;
    }
    /**
     * Set einzelpreis value
     * @param int $einzelpreis
     * @return \StructType\Zusatzleistung
     */
    public function setEinzelpreis($einzelpreis = null)
    {
        // validation for constraint: int
        if (!is_null($einzelpreis) && !(is_int($einzelpreis) || ctype_digit($einzelpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($einzelpreis, true), gettype($einzelpreis)), __LINE__);
        }
        $this->einzelpreis = $einzelpreis;
        return $this;
    }
    /**
     * Get preisproperson value
     * @return bool|null
     */
    public function getPreisproperson()
    {
        return $this->preisproperson;
    }
    /**
     * Set preisproperson value
     * @param bool $preisproperson
     * @return \StructType\Zusatzleistung
     */
    public function setPreisproperson($preisproperson = null)
    {
        // validation for constraint: boolean
        if (!is_null($preisproperson) && !is_bool($preisproperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preisproperson, true), gettype($preisproperson)), __LINE__);
        }
        $this->preisproperson = $preisproperson;
        return $this;
    }
    /**
     * Get preispronacht value
     * @return bool|null
     */
    public function getPreispronacht()
    {
        return $this->preispronacht;
    }
    /**
     * Set preispronacht value
     * @param bool $preispronacht
     * @return \StructType\Zusatzleistung
     */
    public function setPreispronacht($preispronacht = null)
    {
        // validation for constraint: boolean
        if (!is_null($preispronacht) && !is_bool($preispronacht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preispronacht, true), gettype($preispronacht)), __LINE__);
        }
        $this->preispronacht = $preispronacht;
        return $this;
    }
    /**
     * Get typid value
     * @return int|null
     */
    public function getTypid()
    {
        return $this->typid;
    }
    /**
     * Set typid value
     * @param int $typid
     * @return \StructType\Zusatzleistung
     */
    public function setTypid($typid = null)
    {
        // validation for constraint: int
        if (!is_null($typid) && !(is_int($typid) || ctype_digit($typid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typid, true), gettype($typid)), __LINE__);
        }
        $this->typid = $typid;
        return $this;
    }
    /**
     * Get gueltigab value
     * @return string|null
     */
    public function getGueltigab()
    {
        return $this->gueltigab;
    }
    /**
     * Set gueltigab value
     * @param string $gueltigab
     * @return \StructType\Zusatzleistung
     */
    public function setGueltigab($gueltigab = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigab) && !is_string($gueltigab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigab, true), gettype($gueltigab)), __LINE__);
        }
        $this->gueltigab = $gueltigab;
        return $this;
    }
    /**
     * Get gueltigbis value
     * @return string|null
     */
    public function getGueltigbis()
    {
        return $this->gueltigbis;
    }
    /**
     * Set gueltigbis value
     * @param string $gueltigbis
     * @return \StructType\Zusatzleistung
     */
    public function setGueltigbis($gueltigbis = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigbis) && !is_string($gueltigbis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigbis, true), gettype($gueltigbis)), __LINE__);
        }
        $this->gueltigbis = $gueltigbis;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Zusatzleistung
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
    /**
     * Get zusatzbezeichnung value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Zusatzbezeichnung[]|null
     */
    public function getZusatzbezeichnung()
    {
        return isset($this->zusatzbezeichnung) ? $this->zusatzbezeichnung : null;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzbezeichnungForArrayConstraintsFromSetZusatzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zusatzleistungZusatzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$zusatzleistungZusatzbezeichnungItem instanceof \StructType\Zusatzbezeichnung) {
                $invalidValues[] = is_object($zusatzleistungZusatzbezeichnungItem) ? get_class($zusatzleistungZusatzbezeichnungItem) : sprintf('%s(%s)', gettype($zusatzleistungZusatzbezeichnungItem), var_export($zusatzleistungZusatzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzbezeichnung property can only contain items of type \StructType\Zusatzbezeichnung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzbezeichnung value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Zusatzbezeichnung[] $zusatzbezeichnung
     * @return \StructType\Zusatzleistung
     */
    public function setZusatzbezeichnung(array $zusatzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzbezeichnungArrayErrorMessage = self::validateZusatzbezeichnungForArrayConstraintsFromSetZusatzbezeichnung($zusatzbezeichnung))) {
            throw new \InvalidArgumentException($zusatzbezeichnungArrayErrorMessage, __LINE__);
        }
        if (is_null($zusatzbezeichnung) || (is_array($zusatzbezeichnung) && empty($zusatzbezeichnung))) {
            unset($this->zusatzbezeichnung);
        } else {
            $this->zusatzbezeichnung = $zusatzbezeichnung;
        }
        return $this;
    }
    /**
     * Add item to zusatzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\Zusatzbezeichnung $item
     * @return \StructType\Zusatzleistung
     */
    public function addToZusatzbezeichnung(\StructType\Zusatzbezeichnung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zusatzbezeichnung) {
            throw new \InvalidArgumentException(sprintf('The zusatzbezeichnung property can only contain items of type \StructType\Zusatzbezeichnung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzbezeichnung[] = $item;
        return $this;
    }
}
