<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tomasdatahausvariants StructType
 * @subpackage Structs
 */
class Tomasdatahausvariants extends AbstractStructBase
{
    /**
     * The isBuchbar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBuchbar;
    /**
     * The isAlternative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAlternative;
    /**
     * The von
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $von;
    /**
     * The bis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bis;
    /**
     * The minpreis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minpreis;
    /**
     * The verpflegung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verpflegung;
    /**
     * The personen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personen;
    /**
     * The katids
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $katids;
    /**
     * The tbookingurl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tbookingurl;
    /**
     * Constructor method for tomasdatahausvariants
     * @uses Tomasdatahausvariants::setIsBuchbar()
     * @uses Tomasdatahausvariants::setIsAlternative()
     * @uses Tomasdatahausvariants::setVon()
     * @uses Tomasdatahausvariants::setBis()
     * @uses Tomasdatahausvariants::setMinpreis()
     * @uses Tomasdatahausvariants::setVerpflegung()
     * @uses Tomasdatahausvariants::setPersonen()
     * @uses Tomasdatahausvariants::setKatids()
     * @uses Tomasdatahausvariants::setTbookingurl()
     * @param bool $isBuchbar
     * @param bool $isAlternative
     * @param string $von
     * @param string $bis
     * @param string $minpreis
     * @param string $verpflegung
     * @param int $personen
     * @param int[] $katids
     * @param string $tbookingurl
     */
    public function __construct($isBuchbar = null, $isAlternative = null, $von = null, $bis = null, $minpreis = null, $verpflegung = null, $personen = null, array $katids = array(), $tbookingurl = null)
    {
        $this
            ->setIsBuchbar($isBuchbar)
            ->setIsAlternative($isAlternative)
            ->setVon($von)
            ->setBis($bis)
            ->setMinpreis($minpreis)
            ->setVerpflegung($verpflegung)
            ->setPersonen($personen)
            ->setKatids($katids)
            ->setTbookingurl($tbookingurl);
    }
    /**
     * Get isBuchbar value
     * @return bool|null
     */
    public function getIsBuchbar()
    {
        return $this->isBuchbar;
    }
    /**
     * Set isBuchbar value
     * @param bool $isBuchbar
     * @return \StructType\Tomasdatahausvariants
     */
    public function setIsBuchbar($isBuchbar = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBuchbar) && !is_bool($isBuchbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBuchbar, true), gettype($isBuchbar)), __LINE__);
        }
        $this->isBuchbar = $isBuchbar;
        return $this;
    }
    /**
     * Get isAlternative value
     * @return bool|null
     */
    public function getIsAlternative()
    {
        return $this->isAlternative;
    }
    /**
     * Set isAlternative value
     * @param bool $isAlternative
     * @return \StructType\Tomasdatahausvariants
     */
    public function setIsAlternative($isAlternative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternative) && !is_bool($isAlternative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternative, true), gettype($isAlternative)), __LINE__);
        }
        $this->isAlternative = $isAlternative;
        return $this;
    }
    /**
     * Get von value
     * @return string|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \StructType\Tomasdatahausvariants
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \StructType\Tomasdatahausvariants
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get minpreis value
     * @return string|null
     */
    public function getMinpreis()
    {
        return $this->minpreis;
    }
    /**
     * Set minpreis value
     * @param string $minpreis
     * @return \StructType\Tomasdatahausvariants
     */
    public function setMinpreis($minpreis = null)
    {
        // validation for constraint: string
        if (!is_null($minpreis) && !is_string($minpreis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minpreis, true), gettype($minpreis)), __LINE__);
        }
        $this->minpreis = $minpreis;
        return $this;
    }
    /**
     * Get verpflegung value
     * @return string|null
     */
    public function getVerpflegung()
    {
        return $this->verpflegung;
    }
    /**
     * Set verpflegung value
     * @param string $verpflegung
     * @return \StructType\Tomasdatahausvariants
     */
    public function setVerpflegung($verpflegung = null)
    {
        // validation for constraint: string
        if (!is_null($verpflegung) && !is_string($verpflegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpflegung, true), gettype($verpflegung)), __LINE__);
        }
        $this->verpflegung = $verpflegung;
        return $this;
    }
    /**
     * Get personen value
     * @return int|null
     */
    public function getPersonen()
    {
        return $this->personen;
    }
    /**
     * Set personen value
     * @param int $personen
     * @return \StructType\Tomasdatahausvariants
     */
    public function setPersonen($personen = null)
    {
        // validation for constraint: int
        if (!is_null($personen) && !(is_int($personen) || ctype_digit($personen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personen, true), gettype($personen)), __LINE__);
        }
        $this->personen = $personen;
        return $this;
    }
    /**
     * Get katids value
     * @return int[]|null
     */
    public function getKatids()
    {
        return $this->katids;
    }
    /**
     * This method is responsible for validating the values passed to the setKatids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKatids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKatidsForArrayConstraintsFromSetKatids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tomasdatahausvariantsKatidsItem) {
            // validation for constraint: itemType
            if (!(is_int($tomasdatahausvariantsKatidsItem) || ctype_digit($tomasdatahausvariantsKatidsItem))) {
                $invalidValues[] = is_object($tomasdatahausvariantsKatidsItem) ? get_class($tomasdatahausvariantsKatidsItem) : sprintf('%s(%s)', gettype($tomasdatahausvariantsKatidsItem), var_export($tomasdatahausvariantsKatidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The katids property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set katids value
     * @throws \InvalidArgumentException
     * @param int[] $katids
     * @return \StructType\Tomasdatahausvariants
     */
    public function setKatids(array $katids = array())
    {
        // validation for constraint: array
        if ('' !== ($katidsArrayErrorMessage = self::validateKatidsForArrayConstraintsFromSetKatids($katids))) {
            throw new \InvalidArgumentException($katidsArrayErrorMessage, __LINE__);
        }
        $this->katids = $katids;
        return $this;
    }
    /**
     * Add item to katids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Tomasdatahausvariants
     */
    public function addToKatids($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The katids property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->katids[] = $item;
        return $this;
    }
    /**
     * Get tbookingurl value
     * @return string|null
     */
    public function getTbookingurl()
    {
        return $this->tbookingurl;
    }
    /**
     * Set tbookingurl value
     * @param string $tbookingurl
     * @return \StructType\Tomasdatahausvariants
     */
    public function setTbookingurl($tbookingurl = null)
    {
        // validation for constraint: string
        if (!is_null($tbookingurl) && !is_string($tbookingurl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tbookingurl, true), gettype($tbookingurl)), __LINE__);
        }
        $this->tbookingurl = $tbookingurl;
        return $this;
    }
}
