<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tarifpos StructType
 * @subpackage Structs
 */
class Tarifpos extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The tarifposone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Tarifposone[]
     */
    public $tarifposone;
    /**
     * Constructor method for tarifpos
     * @uses Tarifpos::setOrtid()
     * @uses Tarifpos::setHausid()
     * @uses Tarifpos::setTarifposone()
     * @param int $ortid
     * @param int $hausid
     * @param \StructType\Tarifposone[] $tarifposone
     */
    public function __construct($ortid = null, $hausid = null, array $tarifposone = array())
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setTarifposone($tarifposone);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Tarifpos
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Tarifpos
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get tarifposone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Tarifposone[]|null
     */
    public function getTarifposone()
    {
        return isset($this->tarifposone) ? $this->tarifposone : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTarifposone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarifposone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTarifposoneForArrayConstraintsFromSetTarifposone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tarifposTarifposoneItem) {
            // validation for constraint: itemType
            if (!$tarifposTarifposoneItem instanceof \StructType\Tarifposone) {
                $invalidValues[] = is_object($tarifposTarifposoneItem) ? get_class($tarifposTarifposoneItem) : sprintf('%s(%s)', gettype($tarifposTarifposoneItem), var_export($tarifposTarifposoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tarifposone property can only contain items of type \StructType\Tarifposone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tarifposone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tarifposone[] $tarifposone
     * @return \StructType\Tarifpos
     */
    public function setTarifposone(array $tarifposone = array())
    {
        // validation for constraint: array
        if ('' !== ($tarifposoneArrayErrorMessage = self::validateTarifposoneForArrayConstraintsFromSetTarifposone($tarifposone))) {
            throw new \InvalidArgumentException($tarifposoneArrayErrorMessage, __LINE__);
        }
        if (is_null($tarifposone) || (is_array($tarifposone) && empty($tarifposone))) {
            unset($this->tarifposone);
        } else {
            $this->tarifposone = $tarifposone;
        }
        return $this;
    }
    /**
     * Add item to tarifposone value
     * @throws \InvalidArgumentException
     * @param \StructType\Tarifposone $item
     * @return \StructType\Tarifpos
     */
    public function addToTarifposone(\StructType\Tarifposone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tarifposone) {
            throw new \InvalidArgumentException(sprintf('The tarifposone property can only contain items of type \StructType\Tarifposone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tarifposone[] = $item;
        return $this;
    }
}
