<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tagespreis StructType
 * @subpackage Structs
 */
class Tagespreis extends AbstractStructBase
{
    /**
     * The datum
     * @var string
     */
    public $datum;
    /**
     * The preis
     * @var int
     */
    public $preis;
    /**
     * The saisonid
     * @var int
     */
    public $saisonid;
    /**
     * The aktionid
     * @var int
     */
    public $aktionid;
    /**
     * The preiskurzzeitperson
     * @var int
     */
    public $preiskurzzeitperson;
    /**
     * The preiskurzzeitpauschal
     * @var int
     */
    public $preiskurzzeitpauschal;
    /**
     * Constructor method for tagespreis
     * @uses Tagespreis::setDatum()
     * @uses Tagespreis::setPreis()
     * @uses Tagespreis::setSaisonid()
     * @uses Tagespreis::setAktionid()
     * @uses Tagespreis::setPreiskurzzeitperson()
     * @uses Tagespreis::setPreiskurzzeitpauschal()
     * @param string $datum
     * @param int $preis
     * @param int $saisonid
     * @param int $aktionid
     * @param int $preiskurzzeitperson
     * @param int $preiskurzzeitpauschal
     */
    public function __construct($datum = null, $preis = null, $saisonid = null, $aktionid = null, $preiskurzzeitperson = null, $preiskurzzeitpauschal = null)
    {
        $this
            ->setDatum($datum)
            ->setPreis($preis)
            ->setSaisonid($saisonid)
            ->setAktionid($aktionid)
            ->setPreiskurzzeitperson($preiskurzzeitperson)
            ->setPreiskurzzeitpauschal($preiskurzzeitpauschal);
    }
    /**
     * Get datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \StructType\Tagespreis
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get preis value
     * @return int|null
     */
    public function getPreis()
    {
        return $this->preis;
    }
    /**
     * Set preis value
     * @param int $preis
     * @return \StructType\Tagespreis
     */
    public function setPreis($preis = null)
    {
        // validation for constraint: int
        if (!is_null($preis) && !(is_int($preis) || ctype_digit($preis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preis, true), gettype($preis)), __LINE__);
        }
        $this->preis = $preis;
        return $this;
    }
    /**
     * Get saisonid value
     * @return int|null
     */
    public function getSaisonid()
    {
        return $this->saisonid;
    }
    /**
     * Set saisonid value
     * @param int $saisonid
     * @return \StructType\Tagespreis
     */
    public function setSaisonid($saisonid = null)
    {
        // validation for constraint: int
        if (!is_null($saisonid) && !(is_int($saisonid) || ctype_digit($saisonid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saisonid, true), gettype($saisonid)), __LINE__);
        }
        $this->saisonid = $saisonid;
        return $this;
    }
    /**
     * Get aktionid value
     * @return int|null
     */
    public function getAktionid()
    {
        return $this->aktionid;
    }
    /**
     * Set aktionid value
     * @param int $aktionid
     * @return \StructType\Tagespreis
     */
    public function setAktionid($aktionid = null)
    {
        // validation for constraint: int
        if (!is_null($aktionid) && !(is_int($aktionid) || ctype_digit($aktionid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aktionid, true), gettype($aktionid)), __LINE__);
        }
        $this->aktionid = $aktionid;
        return $this;
    }
    /**
     * Get preiskurzzeitperson value
     * @return int|null
     */
    public function getPreiskurzzeitperson()
    {
        return $this->preiskurzzeitperson;
    }
    /**
     * Set preiskurzzeitperson value
     * @param int $preiskurzzeitperson
     * @return \StructType\Tagespreis
     */
    public function setPreiskurzzeitperson($preiskurzzeitperson = null)
    {
        // validation for constraint: int
        if (!is_null($preiskurzzeitperson) && !(is_int($preiskurzzeitperson) || ctype_digit($preiskurzzeitperson))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiskurzzeitperson, true), gettype($preiskurzzeitperson)), __LINE__);
        }
        $this->preiskurzzeitperson = $preiskurzzeitperson;
        return $this;
    }
    /**
     * Get preiskurzzeitpauschal value
     * @return int|null
     */
    public function getPreiskurzzeitpauschal()
    {
        return $this->preiskurzzeitpauschal;
    }
    /**
     * Set preiskurzzeitpauschal value
     * @param int $preiskurzzeitpauschal
     * @return \StructType\Tagespreis
     */
    public function setPreiskurzzeitpauschal($preiskurzzeitpauschal = null)
    {
        // validation for constraint: int
        if (!is_null($preiskurzzeitpauschal) && !(is_int($preiskurzzeitpauschal) || ctype_digit($preiskurzzeitpauschal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preiskurzzeitpauschal, true), gettype($preiskurzzeitpauschal)), __LINE__);
        }
        $this->preiskurzzeitpauschal = $preiskurzzeitpauschal;
        return $this;
    }
}
