<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sprachen StructType
 * @subpackage Structs
 */
class Sprachen extends AbstractStructBase
{
    /**
     * The sprache
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $sprache;
    /**
     * Constructor method for sprachen
     * @uses Sprachen::setSprache()
     * @param string[] $sprache
     */
    public function __construct(array $sprache = array())
    {
        $this
            ->setSprache($sprache);
    }
    /**
     * Get sprache value
     * @return string[]|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * This method is responsible for validating the values passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForArrayConstraintsFromSetSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sprachenSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($sprachenSpracheItem)) {
                $invalidValues[] = is_object($sprachenSpracheItem) ? get_class($sprachenSpracheItem) : sprintf('%s(%s)', gettype($sprachenSpracheItem), var_export($sprachenSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprache property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprache value
     * @throws \InvalidArgumentException
     * @param string[] $sprache
     * @return \StructType\Sprachen
     */
    public function setSprache(array $sprache = array())
    {
        // validation for constraint: array
        if ('' !== ($spracheArrayErrorMessage = self::validateSpracheForArrayConstraintsFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheArrayErrorMessage, __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Add item to sprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Sprachen
     */
    public function addToSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sprache property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprache[] = $item;
        return $this;
    }
}
