<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchresultpos StructType
 * @subpackage Structs
 */
class Searchresultpos extends AbstractStructBase
{
    /**
     * The anzpers
     * @var int
     */
    public $anzpers;
    /**
     * The anzerw
     * @var int
     */
    public $anzerw;
    /**
     * The anzkinder
     * @var int
     */
    public $anzkinder;
    /**
     * The von
     * @var string
     */
    public $von;
    /**
     * The bis
     * @var string
     */
    public $bis;
    /**
     * The uebernachtungen
     * @var int
     */
    public $uebernachtungen;
    /**
     * The maxuebernachtungen
     * @var int
     */
    public $maxuebernachtungen;
    /**
     * The wohneinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Searchresultwohneinheit[]
     */
    public $wohneinheit;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The optionaleleistungen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Buchbareleistungen[]
     */
    public $optionaleleistungen;
    /**
     * Constructor method for searchresultpos
     * @uses Searchresultpos::setAnzpers()
     * @uses Searchresultpos::setAnzerw()
     * @uses Searchresultpos::setAnzkinder()
     * @uses Searchresultpos::setVon()
     * @uses Searchresultpos::setBis()
     * @uses Searchresultpos::setUebernachtungen()
     * @uses Searchresultpos::setMaxuebernachtungen()
     * @uses Searchresultpos::setWohneinheit()
     * @uses Searchresultpos::setOrtid()
     * @uses Searchresultpos::setHausid()
     * @uses Searchresultpos::setOptionaleleistungen()
     * @param int $anzpers
     * @param int $anzerw
     * @param int $anzkinder
     * @param string $von
     * @param string $bis
     * @param int $uebernachtungen
     * @param int $maxuebernachtungen
     * @param \StructType\Searchresultwohneinheit[] $wohneinheit
     * @param int $ortid
     * @param int $hausid
     * @param \StructType\Buchbareleistungen[] $optionaleleistungen
     */
    public function __construct($anzpers = null, $anzerw = null, $anzkinder = null, $von = null, $bis = null, $uebernachtungen = null, $maxuebernachtungen = null, array $wohneinheit = array(), $ortid = null, $hausid = null, array $optionaleleistungen = array())
    {
        $this
            ->setAnzpers($anzpers)
            ->setAnzerw($anzerw)
            ->setAnzkinder($anzkinder)
            ->setVon($von)
            ->setBis($bis)
            ->setUebernachtungen($uebernachtungen)
            ->setMaxuebernachtungen($maxuebernachtungen)
            ->setWohneinheit($wohneinheit)
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setOptionaleleistungen($optionaleleistungen);
    }
    /**
     * Get anzpers value
     * @return int|null
     */
    public function getAnzpers()
    {
        return $this->anzpers;
    }
    /**
     * Set anzpers value
     * @param int $anzpers
     * @return \StructType\Searchresultpos
     */
    public function setAnzpers($anzpers = null)
    {
        // validation for constraint: int
        if (!is_null($anzpers) && !(is_int($anzpers) || ctype_digit($anzpers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzpers, true), gettype($anzpers)), __LINE__);
        }
        $this->anzpers = $anzpers;
        return $this;
    }
    /**
     * Get anzerw value
     * @return int|null
     */
    public function getAnzerw()
    {
        return $this->anzerw;
    }
    /**
     * Set anzerw value
     * @param int $anzerw
     * @return \StructType\Searchresultpos
     */
    public function setAnzerw($anzerw = null)
    {
        // validation for constraint: int
        if (!is_null($anzerw) && !(is_int($anzerw) || ctype_digit($anzerw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzerw, true), gettype($anzerw)), __LINE__);
        }
        $this->anzerw = $anzerw;
        return $this;
    }
    /**
     * Get anzkinder value
     * @return int|null
     */
    public function getAnzkinder()
    {
        return $this->anzkinder;
    }
    /**
     * Set anzkinder value
     * @param int $anzkinder
     * @return \StructType\Searchresultpos
     */
    public function setAnzkinder($anzkinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzkinder) && !(is_int($anzkinder) || ctype_digit($anzkinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzkinder, true), gettype($anzkinder)), __LINE__);
        }
        $this->anzkinder = $anzkinder;
        return $this;
    }
    /**
     * Get von value
     * @return string|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \StructType\Searchresultpos
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \StructType\Searchresultpos
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get uebernachtungen value
     * @return int|null
     */
    public function getUebernachtungen()
    {
        return $this->uebernachtungen;
    }
    /**
     * Set uebernachtungen value
     * @param int $uebernachtungen
     * @return \StructType\Searchresultpos
     */
    public function setUebernachtungen($uebernachtungen = null)
    {
        // validation for constraint: int
        if (!is_null($uebernachtungen) && !(is_int($uebernachtungen) || ctype_digit($uebernachtungen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uebernachtungen, true), gettype($uebernachtungen)), __LINE__);
        }
        $this->uebernachtungen = $uebernachtungen;
        return $this;
    }
    /**
     * Get maxuebernachtungen value
     * @return int|null
     */
    public function getMaxuebernachtungen()
    {
        return $this->maxuebernachtungen;
    }
    /**
     * Set maxuebernachtungen value
     * @param int $maxuebernachtungen
     * @return \StructType\Searchresultpos
     */
    public function setMaxuebernachtungen($maxuebernachtungen = null)
    {
        // validation for constraint: int
        if (!is_null($maxuebernachtungen) && !(is_int($maxuebernachtungen) || ctype_digit($maxuebernachtungen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxuebernachtungen, true), gettype($maxuebernachtungen)), __LINE__);
        }
        $this->maxuebernachtungen = $maxuebernachtungen;
        return $this;
    }
    /**
     * Get wohneinheit value
     * @return \StructType\Searchresultwohneinheit[]|null
     */
    public function getWohneinheit()
    {
        return $this->wohneinheit;
    }
    /**
     * This method is responsible for validating the values passed to the setWohneinheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWohneinheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWohneinheitForArrayConstraintsFromSetWohneinheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultposWohneinheitItem) {
            // validation for constraint: itemType
            if (!$searchresultposWohneinheitItem instanceof \StructType\Searchresultwohneinheit) {
                $invalidValues[] = is_object($searchresultposWohneinheitItem) ? get_class($searchresultposWohneinheitItem) : sprintf('%s(%s)', gettype($searchresultposWohneinheitItem), var_export($searchresultposWohneinheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wohneinheit property can only contain items of type \StructType\Searchresultwohneinheit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set wohneinheit value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultwohneinheit[] $wohneinheit
     * @return \StructType\Searchresultpos
     */
    public function setWohneinheit(array $wohneinheit = array())
    {
        // validation for constraint: array
        if ('' !== ($wohneinheitArrayErrorMessage = self::validateWohneinheitForArrayConstraintsFromSetWohneinheit($wohneinheit))) {
            throw new \InvalidArgumentException($wohneinheitArrayErrorMessage, __LINE__);
        }
        $this->wohneinheit = $wohneinheit;
        return $this;
    }
    /**
     * Add item to wohneinheit value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultwohneinheit $item
     * @return \StructType\Searchresultpos
     */
    public function addToWohneinheit(\StructType\Searchresultwohneinheit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Searchresultwohneinheit) {
            throw new \InvalidArgumentException(sprintf('The wohneinheit property can only contain items of type \StructType\Searchresultwohneinheit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->wohneinheit[] = $item;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Searchresultpos
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Searchresultpos
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get optionaleleistungen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Buchbareleistungen[]|null
     */
    public function getOptionaleleistungen()
    {
        return isset($this->optionaleleistungen) ? $this->optionaleleistungen : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOptionaleleistungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptionaleleistungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionaleleistungenForArrayConstraintsFromSetOptionaleleistungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultposOptionaleleistungenItem) {
            // validation for constraint: itemType
            if (!$searchresultposOptionaleleistungenItem instanceof \StructType\Buchbareleistungen) {
                $invalidValues[] = is_object($searchresultposOptionaleleistungenItem) ? get_class($searchresultposOptionaleleistungenItem) : sprintf('%s(%s)', gettype($searchresultposOptionaleleistungenItem), var_export($searchresultposOptionaleleistungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The optionaleleistungen property can only contain items of type \StructType\Buchbareleistungen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set optionaleleistungen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Buchbareleistungen[] $optionaleleistungen
     * @return \StructType\Searchresultpos
     */
    public function setOptionaleleistungen(array $optionaleleistungen = array())
    {
        // validation for constraint: array
        if ('' !== ($optionaleleistungenArrayErrorMessage = self::validateOptionaleleistungenForArrayConstraintsFromSetOptionaleleistungen($optionaleleistungen))) {
            throw new \InvalidArgumentException($optionaleleistungenArrayErrorMessage, __LINE__);
        }
        if (is_null($optionaleleistungen) || (is_array($optionaleleistungen) && empty($optionaleleistungen))) {
            unset($this->optionaleleistungen);
        } else {
            $this->optionaleleistungen = $optionaleleistungen;
        }
        return $this;
    }
    /**
     * Add item to optionaleleistungen value
     * @throws \InvalidArgumentException
     * @param \StructType\Buchbareleistungen $item
     * @return \StructType\Searchresultpos
     */
    public function addToOptionaleleistungen(\StructType\Buchbareleistungen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Buchbareleistungen) {
            throw new \InvalidArgumentException(sprintf('The optionaleleistungen property can only contain items of type \StructType\Buchbareleistungen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->optionaleleistungen[] = $item;
        return $this;
    }
}
