<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchresultelement StructType
 * @subpackage Structs
 */
class Searchresultelement extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The ganzeshaus
     * @var \StructType\Haus
     */
    public $ganzeshaus;
    /**
     * The erfuellt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Searchresultpos[]
     */
    public $erfuellt;
    /**
     * The nichterfuellt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Searchresultpos[]
     */
    public $nichterfuellt;
    /**
     * The nochverfuegbar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Searchresultpos[]
     */
    public $nochverfuegbar;
    /**
     * The haustext
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Haustext[]
     */
    public $haustext;
    /**
     * The tomasdatahaus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tomasdatahaus
     */
    public $tomasdatahaus;
    /**
     * The tomasdatavariants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tomasdatavariants
     */
    public $tomasdatavariants;
    /**
     * Constructor method for searchresultelement
     * @uses Searchresultelement::setOrtid()
     * @uses Searchresultelement::setHausid()
     * @uses Searchresultelement::setGanzeshaus()
     * @uses Searchresultelement::setErfuellt()
     * @uses Searchresultelement::setNichterfuellt()
     * @uses Searchresultelement::setNochverfuegbar()
     * @uses Searchresultelement::setHaustext()
     * @uses Searchresultelement::setTomasdatahaus()
     * @uses Searchresultelement::setTomasdatavariants()
     * @param int $ortid
     * @param int $hausid
     * @param \StructType\Haus $ganzeshaus
     * @param \StructType\Searchresultpos[] $erfuellt
     * @param \StructType\Searchresultpos[] $nichterfuellt
     * @param \StructType\Searchresultpos[] $nochverfuegbar
     * @param \StructType\Haustext[] $haustext
     * @param \StructType\Tomasdatahaus $tomasdatahaus
     * @param \StructType\Tomasdatavariants $tomasdatavariants
     */
    public function __construct($ortid = null, $hausid = null, \StructType\Haus $ganzeshaus = null, array $erfuellt = array(), array $nichterfuellt = array(), array $nochverfuegbar = array(), array $haustext = array(), \StructType\Tomasdatahaus $tomasdatahaus = null, \StructType\Tomasdatavariants $tomasdatavariants = null)
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setGanzeshaus($ganzeshaus)
            ->setErfuellt($erfuellt)
            ->setNichterfuellt($nichterfuellt)
            ->setNochverfuegbar($nochverfuegbar)
            ->setHaustext($haustext)
            ->setTomasdatahaus($tomasdatahaus)
            ->setTomasdatavariants($tomasdatavariants);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Searchresultelement
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Searchresultelement
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get ganzeshaus value
     * @return \StructType\Haus|null
     */
    public function getGanzeshaus()
    {
        return $this->ganzeshaus;
    }
    /**
     * Set ganzeshaus value
     * @param \StructType\Haus $ganzeshaus
     * @return \StructType\Searchresultelement
     */
    public function setGanzeshaus(\StructType\Haus $ganzeshaus = null)
    {
        $this->ganzeshaus = $ganzeshaus;
        return $this;
    }
    /**
     * Get erfuellt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Searchresultpos[]|null
     */
    public function getErfuellt()
    {
        return isset($this->erfuellt) ? $this->erfuellt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErfuellt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErfuellt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErfuelltForArrayConstraintsFromSetErfuellt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultelementErfuelltItem) {
            // validation for constraint: itemType
            if (!$searchresultelementErfuelltItem instanceof \StructType\Searchresultpos) {
                $invalidValues[] = is_object($searchresultelementErfuelltItem) ? get_class($searchresultelementErfuelltItem) : sprintf('%s(%s)', gettype($searchresultelementErfuelltItem), var_export($searchresultelementErfuelltItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The erfuellt property can only contain items of type \StructType\Searchresultpos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set erfuellt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos[] $erfuellt
     * @return \StructType\Searchresultelement
     */
    public function setErfuellt(array $erfuellt = array())
    {
        // validation for constraint: array
        if ('' !== ($erfuelltArrayErrorMessage = self::validateErfuelltForArrayConstraintsFromSetErfuellt($erfuellt))) {
            throw new \InvalidArgumentException($erfuelltArrayErrorMessage, __LINE__);
        }
        if (is_null($erfuellt) || (is_array($erfuellt) && empty($erfuellt))) {
            unset($this->erfuellt);
        } else {
            $this->erfuellt = $erfuellt;
        }
        return $this;
    }
    /**
     * Add item to erfuellt value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos $item
     * @return \StructType\Searchresultelement
     */
    public function addToErfuellt(\StructType\Searchresultpos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Searchresultpos) {
            throw new \InvalidArgumentException(sprintf('The erfuellt property can only contain items of type \StructType\Searchresultpos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->erfuellt[] = $item;
        return $this;
    }
    /**
     * Get nichterfuellt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Searchresultpos[]|null
     */
    public function getNichterfuellt()
    {
        return isset($this->nichterfuellt) ? $this->nichterfuellt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNichterfuellt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNichterfuellt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNichterfuelltForArrayConstraintsFromSetNichterfuellt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultelementNichterfuelltItem) {
            // validation for constraint: itemType
            if (!$searchresultelementNichterfuelltItem instanceof \StructType\Searchresultpos) {
                $invalidValues[] = is_object($searchresultelementNichterfuelltItem) ? get_class($searchresultelementNichterfuelltItem) : sprintf('%s(%s)', gettype($searchresultelementNichterfuelltItem), var_export($searchresultelementNichterfuelltItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nichterfuellt property can only contain items of type \StructType\Searchresultpos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nichterfuellt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos[] $nichterfuellt
     * @return \StructType\Searchresultelement
     */
    public function setNichterfuellt(array $nichterfuellt = array())
    {
        // validation for constraint: array
        if ('' !== ($nichterfuelltArrayErrorMessage = self::validateNichterfuelltForArrayConstraintsFromSetNichterfuellt($nichterfuellt))) {
            throw new \InvalidArgumentException($nichterfuelltArrayErrorMessage, __LINE__);
        }
        if (is_null($nichterfuellt) || (is_array($nichterfuellt) && empty($nichterfuellt))) {
            unset($this->nichterfuellt);
        } else {
            $this->nichterfuellt = $nichterfuellt;
        }
        return $this;
    }
    /**
     * Add item to nichterfuellt value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos $item
     * @return \StructType\Searchresultelement
     */
    public function addToNichterfuellt(\StructType\Searchresultpos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Searchresultpos) {
            throw new \InvalidArgumentException(sprintf('The nichterfuellt property can only contain items of type \StructType\Searchresultpos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nichterfuellt[] = $item;
        return $this;
    }
    /**
     * Get nochverfuegbar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Searchresultpos[]|null
     */
    public function getNochverfuegbar()
    {
        return isset($this->nochverfuegbar) ? $this->nochverfuegbar : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNochverfuegbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNochverfuegbar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNochverfuegbarForArrayConstraintsFromSetNochverfuegbar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultelementNochverfuegbarItem) {
            // validation for constraint: itemType
            if (!$searchresultelementNochverfuegbarItem instanceof \StructType\Searchresultpos) {
                $invalidValues[] = is_object($searchresultelementNochverfuegbarItem) ? get_class($searchresultelementNochverfuegbarItem) : sprintf('%s(%s)', gettype($searchresultelementNochverfuegbarItem), var_export($searchresultelementNochverfuegbarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nochverfuegbar property can only contain items of type \StructType\Searchresultpos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nochverfuegbar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos[] $nochverfuegbar
     * @return \StructType\Searchresultelement
     */
    public function setNochverfuegbar(array $nochverfuegbar = array())
    {
        // validation for constraint: array
        if ('' !== ($nochverfuegbarArrayErrorMessage = self::validateNochverfuegbarForArrayConstraintsFromSetNochverfuegbar($nochverfuegbar))) {
            throw new \InvalidArgumentException($nochverfuegbarArrayErrorMessage, __LINE__);
        }
        if (is_null($nochverfuegbar) || (is_array($nochverfuegbar) && empty($nochverfuegbar))) {
            unset($this->nochverfuegbar);
        } else {
            $this->nochverfuegbar = $nochverfuegbar;
        }
        return $this;
    }
    /**
     * Add item to nochverfuegbar value
     * @throws \InvalidArgumentException
     * @param \StructType\Searchresultpos $item
     * @return \StructType\Searchresultelement
     */
    public function addToNochverfuegbar(\StructType\Searchresultpos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Searchresultpos) {
            throw new \InvalidArgumentException(sprintf('The nochverfuegbar property can only contain items of type \StructType\Searchresultpos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nochverfuegbar[] = $item;
        return $this;
    }
    /**
     * Get haustext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Haustext[]|null
     */
    public function getHaustext()
    {
        return isset($this->haustext) ? $this->haustext : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHaustext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHaustext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHaustextForArrayConstraintsFromSetHaustext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchresultelementHaustextItem) {
            // validation for constraint: itemType
            if (!$searchresultelementHaustextItem instanceof \StructType\Haustext) {
                $invalidValues[] = is_object($searchresultelementHaustextItem) ? get_class($searchresultelementHaustextItem) : sprintf('%s(%s)', gettype($searchresultelementHaustextItem), var_export($searchresultelementHaustextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The haustext property can only contain items of type \StructType\Haustext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set haustext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Haustext[] $haustext
     * @return \StructType\Searchresultelement
     */
    public function setHaustext(array $haustext = array())
    {
        // validation for constraint: array
        if ('' !== ($haustextArrayErrorMessage = self::validateHaustextForArrayConstraintsFromSetHaustext($haustext))) {
            throw new \InvalidArgumentException($haustextArrayErrorMessage, __LINE__);
        }
        if (is_null($haustext) || (is_array($haustext) && empty($haustext))) {
            unset($this->haustext);
        } else {
            $this->haustext = $haustext;
        }
        return $this;
    }
    /**
     * Add item to haustext value
     * @throws \InvalidArgumentException
     * @param \StructType\Haustext $item
     * @return \StructType\Searchresultelement
     */
    public function addToHaustext(\StructType\Haustext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Haustext) {
            throw new \InvalidArgumentException(sprintf('The haustext property can only contain items of type \StructType\Haustext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->haustext[] = $item;
        return $this;
    }
    /**
     * Get tomasdatahaus value
     * @return \StructType\Tomasdatahaus|null
     */
    public function getTomasdatahaus()
    {
        return $this->tomasdatahaus;
    }
    /**
     * Set tomasdatahaus value
     * @param \StructType\Tomasdatahaus $tomasdatahaus
     * @return \StructType\Searchresultelement
     */
    public function setTomasdatahaus(\StructType\Tomasdatahaus $tomasdatahaus = null)
    {
        $this->tomasdatahaus = $tomasdatahaus;
        return $this;
    }
    /**
     * Get tomasdatavariants value
     * @return \StructType\Tomasdatavariants|null
     */
    public function getTomasdatavariants()
    {
        return $this->tomasdatavariants;
    }
    /**
     * Set tomasdatavariants value
     * @param \StructType\Tomasdatavariants $tomasdatavariants
     * @return \StructType\Searchresultelement
     */
    public function setTomasdatavariants(\StructType\Tomasdatavariants $tomasdatavariants = null)
    {
        $this->tomasdatavariants = $tomasdatavariants;
        return $this;
    }
}
