<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prospekte StructType
 * @subpackage Structs
 */
class Prospekte extends AbstractStructBase
{
    /**
     * The prospektid
     * @var int
     */
    public $prospektid;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The printmedium
     * @var string
     */
    public $printmedium;
    /**
     * The exturl
     * @var string
     */
    public $exturl;
    /**
     * The pdfurl
     * @var string
     */
    public $pdfurl;
    /**
     * The lastchange
     * @var string
     */
    public $lastchange;
    /**
     * Constructor method for prospekte
     * @uses Prospekte::setProspektid()
     * @uses Prospekte::setOrtid()
     * @uses Prospekte::setHausid()
     * @uses Prospekte::setSprache()
     * @uses Prospekte::setBezeichnung()
     * @uses Prospekte::setPrintmedium()
     * @uses Prospekte::setExturl()
     * @uses Prospekte::setPdfurl()
     * @uses Prospekte::setLastchange()
     * @param int $prospektid
     * @param int $ortid
     * @param int $hausid
     * @param string $sprache
     * @param string $bezeichnung
     * @param string $printmedium
     * @param string $exturl
     * @param string $pdfurl
     * @param string $lastchange
     */
    public function __construct($prospektid = null, $ortid = null, $hausid = null, $sprache = null, $bezeichnung = null, $printmedium = null, $exturl = null, $pdfurl = null, $lastchange = null)
    {
        $this
            ->setProspektid($prospektid)
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setSprache($sprache)
            ->setBezeichnung($bezeichnung)
            ->setPrintmedium($printmedium)
            ->setExturl($exturl)
            ->setPdfurl($pdfurl)
            ->setLastchange($lastchange);
    }
    /**
     * Get prospektid value
     * @return int|null
     */
    public function getProspektid()
    {
        return $this->prospektid;
    }
    /**
     * Set prospektid value
     * @param int $prospektid
     * @return \StructType\Prospekte
     */
    public function setProspektid($prospektid = null)
    {
        // validation for constraint: int
        if (!is_null($prospektid) && !(is_int($prospektid) || ctype_digit($prospektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prospektid, true), gettype($prospektid)), __LINE__);
        }
        $this->prospektid = $prospektid;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Prospekte
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Prospekte
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Prospekte
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Prospekte
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get printmedium value
     * @return string|null
     */
    public function getPrintmedium()
    {
        return $this->printmedium;
    }
    /**
     * Set printmedium value
     * @param string $printmedium
     * @return \StructType\Prospekte
     */
    public function setPrintmedium($printmedium = null)
    {
        // validation for constraint: string
        if (!is_null($printmedium) && !is_string($printmedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printmedium, true), gettype($printmedium)), __LINE__);
        }
        $this->printmedium = $printmedium;
        return $this;
    }
    /**
     * Get exturl value
     * @return string|null
     */
    public function getExturl()
    {
        return $this->exturl;
    }
    /**
     * Set exturl value
     * @param string $exturl
     * @return \StructType\Prospekte
     */
    public function setExturl($exturl = null)
    {
        // validation for constraint: string
        if (!is_null($exturl) && !is_string($exturl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exturl, true), gettype($exturl)), __LINE__);
        }
        $this->exturl = $exturl;
        return $this;
    }
    /**
     * Get pdfurl value
     * @return string|null
     */
    public function getPdfurl()
    {
        return $this->pdfurl;
    }
    /**
     * Set pdfurl value
     * @param string $pdfurl
     * @return \StructType\Prospekte
     */
    public function setPdfurl($pdfurl = null)
    {
        // validation for constraint: string
        if (!is_null($pdfurl) && !is_string($pdfurl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfurl, true), gettype($pdfurl)), __LINE__);
        }
        $this->pdfurl = $pdfurl;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Prospekte
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
}
