<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for portal StructType
 * @subpackage Structs
 */
class Portal extends AbstractStructBase
{
    /**
     * The kennzeichen
     * @var string
     */
    public $kennzeichen;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The beschreibung
     * @var string
     */
    public $beschreibung;
    /**
     * Constructor method for portal
     * @uses Portal::setKennzeichen()
     * @uses Portal::setBezeichnung()
     * @uses Portal::setBeschreibung()
     * @param string $kennzeichen
     * @param string $bezeichnung
     * @param string $beschreibung
     */
    public function __construct($kennzeichen = null, $bezeichnung = null, $beschreibung = null)
    {
        $this
            ->setKennzeichen($kennzeichen)
            ->setBezeichnung($bezeichnung)
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get kennzeichen value
     * @return string|null
     */
    public function getKennzeichen()
    {
        return $this->kennzeichen;
    }
    /**
     * Set kennzeichen value
     * @param string $kennzeichen
     * @return \StructType\Portal
     */
    public function setKennzeichen($kennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($kennzeichen) && !is_string($kennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennzeichen, true), gettype($kennzeichen)), __LINE__);
        }
        $this->kennzeichen = $kennzeichen;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Portal
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\Portal
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
}
