<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pauschalenzeitraum StructType
 * @subpackage Structs
 */
class Pauschalenzeitraum extends AbstractStructBase
{
    /**
     * The zeitraumid
     * @var int
     */
    public $zeitraumid;
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The von
     * @var string
     */
    public $von;
    /**
     * The bis
     * @var string
     */
    public $bis;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * Constructor method for pauschalenzeitraum
     * @uses Pauschalenzeitraum::setZeitraumid()
     * @uses Pauschalenzeitraum::setPauid()
     * @uses Pauschalenzeitraum::setVon()
     * @uses Pauschalenzeitraum::setBis()
     * @uses Pauschalenzeitraum::setStatus()
     * @param int $zeitraumid
     * @param int $pauid
     * @param string $von
     * @param string $bis
     * @param int $status
     */
    public function __construct($zeitraumid = null, $pauid = null, $von = null, $bis = null, $status = null)
    {
        $this
            ->setZeitraumid($zeitraumid)
            ->setPauid($pauid)
            ->setVon($von)
            ->setBis($bis)
            ->setStatus($status);
    }
    /**
     * Get zeitraumid value
     * @return int|null
     */
    public function getZeitraumid()
    {
        return $this->zeitraumid;
    }
    /**
     * Set zeitraumid value
     * @param int $zeitraumid
     * @return \StructType\Pauschalenzeitraum
     */
    public function setZeitraumid($zeitraumid = null)
    {
        // validation for constraint: int
        if (!is_null($zeitraumid) && !(is_int($zeitraumid) || ctype_digit($zeitraumid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zeitraumid, true), gettype($zeitraumid)), __LINE__);
        }
        $this->zeitraumid = $zeitraumid;
        return $this;
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Pauschalenzeitraum
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get von value
     * @return string|null
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \StructType\Pauschalenzeitraum
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string|null
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \StructType\Pauschalenzeitraum
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Pauschalenzeitraum
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
