<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pauschale StructType
 * @subpackage Structs
 */
class Pauschale extends AbstractStructBase
{
    /**
     * The pauid
     * @var int
     */
    public $pauid;
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bezeichnung;
    /**
     * The berechnung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $berechnung;
    /**
     * The kinderpreis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kinderpreis;
    /**
     * The anreisen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Anabreiseregelung
     */
    public $anreisen;
    /**
     * The abreisen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Anabreiseregelung
     */
    public $abreisen;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The lastchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastchange;
    /**
     * The hausids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $hausids;
    /**
     * The katids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $katids;
    /**
     * The pauschalenpreis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pauschalenpreis[]
     */
    public $pauschalenpreis;
    /**
     * The pauschalenabzuschlaege
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pauschalenabzuschlaege[]
     */
    public $pauschalenabzuschlaege;
    /**
     * The pauschalentext
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pauschalentext[]
     */
    public $pauschalentext;
    /**
     * The tipauschale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tipauschale;
    /**
     * The haeuser
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Haus[]
     */
    public $haeuser;
    /**
     * The pauschalenzeitraeume
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pauschalenzeitraum[]
     */
    public $pauschalenzeitraeume;
    /**
     * The tipauschaledefiniton
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tipauschaledefiniton
     */
    public $tipauschaledefiniton;
    /**
     * The rubrik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rubrik;
    /**
     * Constructor method for pauschale
     * @uses Pauschale::setPauid()
     * @uses Pauschale::setOrtid()
     * @uses Pauschale::setBezeichnung()
     * @uses Pauschale::setBerechnung()
     * @uses Pauschale::setKinderpreis()
     * @uses Pauschale::setAnreisen()
     * @uses Pauschale::setAbreisen()
     * @uses Pauschale::setStatus()
     * @uses Pauschale::setLastchange()
     * @uses Pauschale::setHausids()
     * @uses Pauschale::setKatids()
     * @uses Pauschale::setPauschalenpreis()
     * @uses Pauschale::setPauschalenabzuschlaege()
     * @uses Pauschale::setPauschalentext()
     * @uses Pauschale::setTipauschale()
     * @uses Pauschale::setHaeuser()
     * @uses Pauschale::setPauschalenzeitraeume()
     * @uses Pauschale::setTipauschaledefiniton()
     * @uses Pauschale::setRubrik()
     * @param int $pauid
     * @param int $ortid
     * @param string $bezeichnung
     * @param string $berechnung
     * @param string $kinderpreis
     * @param \StructType\Anabreiseregelung $anreisen
     * @param \StructType\Anabreiseregelung $abreisen
     * @param int $status
     * @param string $lastchange
     * @param int $hausids
     * @param int $katids
     * @param \StructType\Pauschalenpreis[] $pauschalenpreis
     * @param \StructType\Pauschalenabzuschlaege[] $pauschalenabzuschlaege
     * @param \StructType\Pauschalentext[] $pauschalentext
     * @param int $tipauschale
     * @param \StructType\Haus[] $haeuser
     * @param \StructType\Pauschalenzeitraum[] $pauschalenzeitraeume
     * @param \StructType\Tipauschaledefiniton $tipauschaledefiniton
     * @param string $rubrik
     */
    public function __construct($pauid = null, $ortid = null, $bezeichnung = null, $berechnung = null, $kinderpreis = null, \StructType\Anabreiseregelung $anreisen = null, \StructType\Anabreiseregelung $abreisen = null, $status = null, $lastchange = null, $hausids = null, $katids = null, array $pauschalenpreis = array(), array $pauschalenabzuschlaege = array(), array $pauschalentext = array(), $tipauschale = null, array $haeuser = array(), array $pauschalenzeitraeume = array(), \StructType\Tipauschaledefiniton $tipauschaledefiniton = null, $rubrik = null)
    {
        $this
            ->setPauid($pauid)
            ->setOrtid($ortid)
            ->setBezeichnung($bezeichnung)
            ->setBerechnung($berechnung)
            ->setKinderpreis($kinderpreis)
            ->setAnreisen($anreisen)
            ->setAbreisen($abreisen)
            ->setStatus($status)
            ->setLastchange($lastchange)
            ->setHausids($hausids)
            ->setKatids($katids)
            ->setPauschalenpreis($pauschalenpreis)
            ->setPauschalenabzuschlaege($pauschalenabzuschlaege)
            ->setPauschalentext($pauschalentext)
            ->setTipauschale($tipauschale)
            ->setHaeuser($haeuser)
            ->setPauschalenzeitraeume($pauschalenzeitraeume)
            ->setTipauschaledefiniton($tipauschaledefiniton)
            ->setRubrik($rubrik);
    }
    /**
     * Get pauid value
     * @return int|null
     */
    public function getPauid()
    {
        return $this->pauid;
    }
    /**
     * Set pauid value
     * @param int $pauid
     * @return \StructType\Pauschale
     */
    public function setPauid($pauid = null)
    {
        // validation for constraint: int
        if (!is_null($pauid) && !(is_int($pauid) || ctype_digit($pauid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pauid, true), gettype($pauid)), __LINE__);
        }
        $this->pauid = $pauid;
        return $this;
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Pauschale
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Pauschale
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get berechnung value
     * @return string|null
     */
    public function getBerechnung()
    {
        return $this->berechnung;
    }
    /**
     * Set berechnung value
     * @param string $berechnung
     * @return \StructType\Pauschale
     */
    public function setBerechnung($berechnung = null)
    {
        // validation for constraint: string
        if (!is_null($berechnung) && !is_string($berechnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berechnung, true), gettype($berechnung)), __LINE__);
        }
        $this->berechnung = $berechnung;
        return $this;
    }
    /**
     * Get kinderpreis value
     * @return string|null
     */
    public function getKinderpreis()
    {
        return $this->kinderpreis;
    }
    /**
     * Set kinderpreis value
     * @param string $kinderpreis
     * @return \StructType\Pauschale
     */
    public function setKinderpreis($kinderpreis = null)
    {
        // validation for constraint: string
        if (!is_null($kinderpreis) && !is_string($kinderpreis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kinderpreis, true), gettype($kinderpreis)), __LINE__);
        }
        $this->kinderpreis = $kinderpreis;
        return $this;
    }
    /**
     * Get anreisen value
     * @return \StructType\Anabreiseregelung|null
     */
    public function getAnreisen()
    {
        return $this->anreisen;
    }
    /**
     * Set anreisen value
     * @param \StructType\Anabreiseregelung $anreisen
     * @return \StructType\Pauschale
     */
    public function setAnreisen(\StructType\Anabreiseregelung $anreisen = null)
    {
        $this->anreisen = $anreisen;
        return $this;
    }
    /**
     * Get abreisen value
     * @return \StructType\Anabreiseregelung|null
     */
    public function getAbreisen()
    {
        return $this->abreisen;
    }
    /**
     * Set abreisen value
     * @param \StructType\Anabreiseregelung $abreisen
     * @return \StructType\Pauschale
     */
    public function setAbreisen(\StructType\Anabreiseregelung $abreisen = null)
    {
        $this->abreisen = $abreisen;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Pauschale
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Pauschale
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
    /**
     * Get hausids value
     * @return int|null
     */
    public function getHausids()
    {
        return $this->hausids;
    }
    /**
     * Set hausids value
     * @param int $hausids
     * @return \StructType\Pauschale
     */
    public function setHausids($hausids = null)
    {
        // validation for constraint: int
        if (!is_null($hausids) && !(is_int($hausids) || ctype_digit($hausids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausids, true), gettype($hausids)), __LINE__);
        }
        $this->hausids = $hausids;
        return $this;
    }
    /**
     * Get katids value
     * @return int|null
     */
    public function getKatids()
    {
        return $this->katids;
    }
    /**
     * Set katids value
     * @param int $katids
     * @return \StructType\Pauschale
     */
    public function setKatids($katids = null)
    {
        // validation for constraint: int
        if (!is_null($katids) && !(is_int($katids) || ctype_digit($katids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katids, true), gettype($katids)), __LINE__);
        }
        $this->katids = $katids;
        return $this;
    }
    /**
     * Get pauschalenpreis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pauschalenpreis[]|null
     */
    public function getPauschalenpreis()
    {
        return isset($this->pauschalenpreis) ? $this->pauschalenpreis : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPauschalenpreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPauschalenpreis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePauschalenpreisForArrayConstraintsFromSetPauschalenpreis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschalePauschalenpreisItem) {
            // validation for constraint: itemType
            if (!$pauschalePauschalenpreisItem instanceof \StructType\Pauschalenpreis) {
                $invalidValues[] = is_object($pauschalePauschalenpreisItem) ? get_class($pauschalePauschalenpreisItem) : sprintf('%s(%s)', gettype($pauschalePauschalenpreisItem), var_export($pauschalePauschalenpreisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pauschalenpreis property can only contain items of type \StructType\Pauschalenpreis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pauschalenpreis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenpreis[] $pauschalenpreis
     * @return \StructType\Pauschale
     */
    public function setPauschalenpreis(array $pauschalenpreis = array())
    {
        // validation for constraint: array
        if ('' !== ($pauschalenpreisArrayErrorMessage = self::validatePauschalenpreisForArrayConstraintsFromSetPauschalenpreis($pauschalenpreis))) {
            throw new \InvalidArgumentException($pauschalenpreisArrayErrorMessage, __LINE__);
        }
        if (is_null($pauschalenpreis) || (is_array($pauschalenpreis) && empty($pauschalenpreis))) {
            unset($this->pauschalenpreis);
        } else {
            $this->pauschalenpreis = $pauschalenpreis;
        }
        return $this;
    }
    /**
     * Add item to pauschalenpreis value
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenpreis $item
     * @return \StructType\Pauschale
     */
    public function addToPauschalenpreis(\StructType\Pauschalenpreis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pauschalenpreis) {
            throw new \InvalidArgumentException(sprintf('The pauschalenpreis property can only contain items of type \StructType\Pauschalenpreis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pauschalenpreis[] = $item;
        return $this;
    }
    /**
     * Get pauschalenabzuschlaege value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pauschalenabzuschlaege[]|null
     */
    public function getPauschalenabzuschlaege()
    {
        return isset($this->pauschalenabzuschlaege) ? $this->pauschalenabzuschlaege : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPauschalenabzuschlaege method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPauschalenabzuschlaege method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePauschalenabzuschlaegeForArrayConstraintsFromSetPauschalenabzuschlaege(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschalePauschalenabzuschlaegeItem) {
            // validation for constraint: itemType
            if (!$pauschalePauschalenabzuschlaegeItem instanceof \StructType\Pauschalenabzuschlaege) {
                $invalidValues[] = is_object($pauschalePauschalenabzuschlaegeItem) ? get_class($pauschalePauschalenabzuschlaegeItem) : sprintf('%s(%s)', gettype($pauschalePauschalenabzuschlaegeItem), var_export($pauschalePauschalenabzuschlaegeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pauschalenabzuschlaege property can only contain items of type \StructType\Pauschalenabzuschlaege, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pauschalenabzuschlaege value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenabzuschlaege[] $pauschalenabzuschlaege
     * @return \StructType\Pauschale
     */
    public function setPauschalenabzuschlaege(array $pauschalenabzuschlaege = array())
    {
        // validation for constraint: array
        if ('' !== ($pauschalenabzuschlaegeArrayErrorMessage = self::validatePauschalenabzuschlaegeForArrayConstraintsFromSetPauschalenabzuschlaege($pauschalenabzuschlaege))) {
            throw new \InvalidArgumentException($pauschalenabzuschlaegeArrayErrorMessage, __LINE__);
        }
        if (is_null($pauschalenabzuschlaege) || (is_array($pauschalenabzuschlaege) && empty($pauschalenabzuschlaege))) {
            unset($this->pauschalenabzuschlaege);
        } else {
            $this->pauschalenabzuschlaege = $pauschalenabzuschlaege;
        }
        return $this;
    }
    /**
     * Add item to pauschalenabzuschlaege value
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenabzuschlaege $item
     * @return \StructType\Pauschale
     */
    public function addToPauschalenabzuschlaege(\StructType\Pauschalenabzuschlaege $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pauschalenabzuschlaege) {
            throw new \InvalidArgumentException(sprintf('The pauschalenabzuschlaege property can only contain items of type \StructType\Pauschalenabzuschlaege, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pauschalenabzuschlaege[] = $item;
        return $this;
    }
    /**
     * Get pauschalentext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pauschalentext[]|null
     */
    public function getPauschalentext()
    {
        return isset($this->pauschalentext) ? $this->pauschalentext : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPauschalentext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPauschalentext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePauschalentextForArrayConstraintsFromSetPauschalentext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschalePauschalentextItem) {
            // validation for constraint: itemType
            if (!$pauschalePauschalentextItem instanceof \StructType\Pauschalentext) {
                $invalidValues[] = is_object($pauschalePauschalentextItem) ? get_class($pauschalePauschalentextItem) : sprintf('%s(%s)', gettype($pauschalePauschalentextItem), var_export($pauschalePauschalentextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pauschalentext property can only contain items of type \StructType\Pauschalentext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pauschalentext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalentext[] $pauschalentext
     * @return \StructType\Pauschale
     */
    public function setPauschalentext(array $pauschalentext = array())
    {
        // validation for constraint: array
        if ('' !== ($pauschalentextArrayErrorMessage = self::validatePauschalentextForArrayConstraintsFromSetPauschalentext($pauschalentext))) {
            throw new \InvalidArgumentException($pauschalentextArrayErrorMessage, __LINE__);
        }
        if (is_null($pauschalentext) || (is_array($pauschalentext) && empty($pauschalentext))) {
            unset($this->pauschalentext);
        } else {
            $this->pauschalentext = $pauschalentext;
        }
        return $this;
    }
    /**
     * Add item to pauschalentext value
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalentext $item
     * @return \StructType\Pauschale
     */
    public function addToPauschalentext(\StructType\Pauschalentext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pauschalentext) {
            throw new \InvalidArgumentException(sprintf('The pauschalentext property can only contain items of type \StructType\Pauschalentext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pauschalentext[] = $item;
        return $this;
    }
    /**
     * Get tipauschale value
     * @return int|null
     */
    public function getTipauschale()
    {
        return $this->tipauschale;
    }
    /**
     * Set tipauschale value
     * @param int $tipauschale
     * @return \StructType\Pauschale
     */
    public function setTipauschale($tipauschale = null)
    {
        // validation for constraint: int
        if (!is_null($tipauschale) && !(is_int($tipauschale) || ctype_digit($tipauschale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipauschale, true), gettype($tipauschale)), __LINE__);
        }
        $this->tipauschale = $tipauschale;
        return $this;
    }
    /**
     * Get haeuser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Haus[]|null
     */
    public function getHaeuser()
    {
        return isset($this->haeuser) ? $this->haeuser : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHaeuser method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHaeuser method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHaeuserForArrayConstraintsFromSetHaeuser(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschaleHaeuserItem) {
            // validation for constraint: itemType
            if (!$pauschaleHaeuserItem instanceof \StructType\Haus) {
                $invalidValues[] = is_object($pauschaleHaeuserItem) ? get_class($pauschaleHaeuserItem) : sprintf('%s(%s)', gettype($pauschaleHaeuserItem), var_export($pauschaleHaeuserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The haeuser property can only contain items of type \StructType\Haus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set haeuser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Haus[] $haeuser
     * @return \StructType\Pauschale
     */
    public function setHaeuser(array $haeuser = array())
    {
        // validation for constraint: array
        if ('' !== ($haeuserArrayErrorMessage = self::validateHaeuserForArrayConstraintsFromSetHaeuser($haeuser))) {
            throw new \InvalidArgumentException($haeuserArrayErrorMessage, __LINE__);
        }
        if (is_null($haeuser) || (is_array($haeuser) && empty($haeuser))) {
            unset($this->haeuser);
        } else {
            $this->haeuser = $haeuser;
        }
        return $this;
    }
    /**
     * Add item to haeuser value
     * @throws \InvalidArgumentException
     * @param \StructType\Haus $item
     * @return \StructType\Pauschale
     */
    public function addToHaeuser(\StructType\Haus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Haus) {
            throw new \InvalidArgumentException(sprintf('The haeuser property can only contain items of type \StructType\Haus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->haeuser[] = $item;
        return $this;
    }
    /**
     * Get pauschalenzeitraeume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pauschalenzeitraum[]|null
     */
    public function getPauschalenzeitraeume()
    {
        return isset($this->pauschalenzeitraeume) ? $this->pauschalenzeitraeume : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPauschalenzeitraeume method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPauschalenzeitraeume method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePauschalenzeitraeumeForArrayConstraintsFromSetPauschalenzeitraeume(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pauschalePauschalenzeitraeumeItem) {
            // validation for constraint: itemType
            if (!$pauschalePauschalenzeitraeumeItem instanceof \StructType\Pauschalenzeitraum) {
                $invalidValues[] = is_object($pauschalePauschalenzeitraeumeItem) ? get_class($pauschalePauschalenzeitraeumeItem) : sprintf('%s(%s)', gettype($pauschalePauschalenzeitraeumeItem), var_export($pauschalePauschalenzeitraeumeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pauschalenzeitraeume property can only contain items of type \StructType\Pauschalenzeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pauschalenzeitraeume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenzeitraum[] $pauschalenzeitraeume
     * @return \StructType\Pauschale
     */
    public function setPauschalenzeitraeume(array $pauschalenzeitraeume = array())
    {
        // validation for constraint: array
        if ('' !== ($pauschalenzeitraeumeArrayErrorMessage = self::validatePauschalenzeitraeumeForArrayConstraintsFromSetPauschalenzeitraeume($pauschalenzeitraeume))) {
            throw new \InvalidArgumentException($pauschalenzeitraeumeArrayErrorMessage, __LINE__);
        }
        if (is_null($pauschalenzeitraeume) || (is_array($pauschalenzeitraeume) && empty($pauschalenzeitraeume))) {
            unset($this->pauschalenzeitraeume);
        } else {
            $this->pauschalenzeitraeume = $pauschalenzeitraeume;
        }
        return $this;
    }
    /**
     * Add item to pauschalenzeitraeume value
     * @throws \InvalidArgumentException
     * @param \StructType\Pauschalenzeitraum $item
     * @return \StructType\Pauschale
     */
    public function addToPauschalenzeitraeume(\StructType\Pauschalenzeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pauschalenzeitraum) {
            throw new \InvalidArgumentException(sprintf('The pauschalenzeitraeume property can only contain items of type \StructType\Pauschalenzeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pauschalenzeitraeume[] = $item;
        return $this;
    }
    /**
     * Get tipauschaledefiniton value
     * @return \StructType\Tipauschaledefiniton|null
     */
    public function getTipauschaledefiniton()
    {
        return $this->tipauschaledefiniton;
    }
    /**
     * Set tipauschaledefiniton value
     * @param \StructType\Tipauschaledefiniton $tipauschaledefiniton
     * @return \StructType\Pauschale
     */
    public function setTipauschaledefiniton(\StructType\Tipauschaledefiniton $tipauschaledefiniton = null)
    {
        $this->tipauschaledefiniton = $tipauschaledefiniton;
        return $this;
    }
    /**
     * Get rubrik value
     * @return string|null
     */
    public function getRubrik()
    {
        return $this->rubrik;
    }
    /**
     * Set rubrik value
     * @param string $rubrik
     * @return \StructType\Pauschale
     */
    public function setRubrik($rubrik = null)
    {
        // validation for constraint: string
        if (!is_null($rubrik) && !is_string($rubrik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rubrik, true), gettype($rubrik)), __LINE__);
        }
        $this->rubrik = $rubrik;
        return $this;
    }
}
