<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ort StructType
 * @subpackage Structs
 */
class Ort extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The ortkuerzel
     * @var string
     */
    public $ortkuerzel;
    /**
     * The ortsname
     * @var string
     */
    public $ortsname;
    /**
     * Constructor method for ort
     * @uses Ort::setOrtid()
     * @uses Ort::setOrtkuerzel()
     * @uses Ort::setOrtsname()
     * @param int $ortid
     * @param string $ortkuerzel
     * @param string $ortsname
     */
    public function __construct($ortid = null, $ortkuerzel = null, $ortsname = null)
    {
        $this
            ->setOrtid($ortid)
            ->setOrtkuerzel($ortkuerzel)
            ->setOrtsname($ortsname);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Ort
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get ortkuerzel value
     * @return string|null
     */
    public function getOrtkuerzel()
    {
        return $this->ortkuerzel;
    }
    /**
     * Set ortkuerzel value
     * @param string $ortkuerzel
     * @return \StructType\Ort
     */
    public function setOrtkuerzel($ortkuerzel = null)
    {
        // validation for constraint: string
        if (!is_null($ortkuerzel) && !is_string($ortkuerzel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ortkuerzel, true), gettype($ortkuerzel)), __LINE__);
        }
        $this->ortkuerzel = $ortkuerzel;
        return $this;
    }
    /**
     * Get ortsname value
     * @return string|null
     */
    public function getOrtsname()
    {
        return $this->ortsname;
    }
    /**
     * Set ortsname value
     * @param string $ortsname
     * @return \StructType\Ort
     */
    public function setOrtsname($ortsname = null)
    {
        // validation for constraint: string
        if (!is_null($ortsname) && !is_string($ortsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ortsname, true), gettype($ortsname)), __LINE__);
        }
        $this->ortsname = $ortsname;
        return $this;
    }
}
