<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for laender StructType
 * @subpackage Structs
 */
class Laender extends AbstractStructBase
{
    /**
     * The land
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Land[]
     */
    public $land;
    /**
     * Constructor method for laender
     * @uses Laender::setLand()
     * @param \StructType\Land[] $land
     */
    public function __construct(array $land = array())
    {
        $this
            ->setLand($land);
    }
    /**
     * Get land value
     * @return \StructType\Land[]|null
     */
    public function getLand()
    {
        return $this->land;
    }
    /**
     * This method is responsible for validating the values passed to the setLand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandForArrayConstraintsFromSetLand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $laenderLandItem) {
            // validation for constraint: itemType
            if (!$laenderLandItem instanceof \StructType\Land) {
                $invalidValues[] = is_object($laenderLandItem) ? get_class($laenderLandItem) : sprintf('%s(%s)', gettype($laenderLandItem), var_export($laenderLandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The land property can only contain items of type \StructType\Land, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set land value
     * @throws \InvalidArgumentException
     * @param \StructType\Land[] $land
     * @return \StructType\Laender
     */
    public function setLand(array $land = array())
    {
        // validation for constraint: array
        if ('' !== ($landArrayErrorMessage = self::validateLandForArrayConstraintsFromSetLand($land))) {
            throw new \InvalidArgumentException($landArrayErrorMessage, __LINE__);
        }
        $this->land = $land;
        return $this;
    }
    /**
     * Add item to land value
     * @throws \InvalidArgumentException
     * @param \StructType\Land $item
     * @return \StructType\Laender
     */
    public function addToLand(\StructType\Land $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Land) {
            throw new \InvalidArgumentException(sprintf('The land property can only contain items of type \StructType\Land, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->land[] = $item;
        return $this;
    }
}
