<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kurzonen StructType
 * @subpackage Structs
 */
class Kurzonen extends AbstractStructBase
{
    /**
     * The kurzone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Kurzone[]
     */
    public $kurzone;
    /**
     * Constructor method for kurzonen
     * @uses Kurzonen::setKurzone()
     * @param \StructType\Kurzone[] $kurzone
     */
    public function __construct(array $kurzone = array())
    {
        $this
            ->setKurzone($kurzone);
    }
    /**
     * Get kurzone value
     * @return \StructType\Kurzone[]|null
     */
    public function getKurzone()
    {
        return $this->kurzone;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzoneForArrayConstraintsFromSetKurzone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kurzonenKurzoneItem) {
            // validation for constraint: itemType
            if (!$kurzonenKurzoneItem instanceof \StructType\Kurzone) {
                $invalidValues[] = is_object($kurzonenKurzoneItem) ? get_class($kurzonenKurzoneItem) : sprintf('%s(%s)', gettype($kurzonenKurzoneItem), var_export($kurzonenKurzoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzone property can only contain items of type \StructType\Kurzone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzone value
     * @throws \InvalidArgumentException
     * @param \StructType\Kurzone[] $kurzone
     * @return \StructType\Kurzonen
     */
    public function setKurzone(array $kurzone = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzoneArrayErrorMessage = self::validateKurzoneForArrayConstraintsFromSetKurzone($kurzone))) {
            throw new \InvalidArgumentException($kurzoneArrayErrorMessage, __LINE__);
        }
        $this->kurzone = $kurzone;
        return $this;
    }
    /**
     * Add item to kurzone value
     * @throws \InvalidArgumentException
     * @param \StructType\Kurzone $item
     * @return \StructType\Kurzonen
     */
    public function addToKurzone(\StructType\Kurzone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kurzone) {
            throw new \InvalidArgumentException(sprintf('The kurzone property can only contain items of type \StructType\Kurzone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzone[] = $item;
        return $this;
    }
}
