<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kategorienjehaus StructType
 * @subpackage Structs
 */
class Kategorienjehaus extends AbstractStructBase
{
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The kategorieeinhaus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Kategorieeinhaus[]
     */
    public $kategorieeinhaus;
    /**
     * Constructor method for kategorienjehaus
     * @uses Kategorienjehaus::setHausid()
     * @uses Kategorienjehaus::setKategorieeinhaus()
     * @param int $hausid
     * @param \StructType\Kategorieeinhaus[] $kategorieeinhaus
     */
    public function __construct($hausid = null, array $kategorieeinhaus = array())
    {
        $this
            ->setHausid($hausid)
            ->setKategorieeinhaus($kategorieeinhaus);
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Kategorienjehaus
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get kategorieeinhaus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Kategorieeinhaus[]|null
     */
    public function getKategorieeinhaus()
    {
        return isset($this->kategorieeinhaus) ? $this->kategorieeinhaus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorieeinhaus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorieeinhaus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieeinhausForArrayConstraintsFromSetKategorieeinhaus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategorienjehausKategorieeinhausItem) {
            // validation for constraint: itemType
            if (!$kategorienjehausKategorieeinhausItem instanceof \StructType\Kategorieeinhaus) {
                $invalidValues[] = is_object($kategorienjehausKategorieeinhausItem) ? get_class($kategorienjehausKategorieeinhausItem) : sprintf('%s(%s)', gettype($kategorienjehausKategorieeinhausItem), var_export($kategorienjehausKategorieeinhausItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorieeinhaus property can only contain items of type \StructType\Kategorieeinhaus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorieeinhaus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Kategorieeinhaus[] $kategorieeinhaus
     * @return \StructType\Kategorienjehaus
     */
    public function setKategorieeinhaus(array $kategorieeinhaus = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieeinhausArrayErrorMessage = self::validateKategorieeinhausForArrayConstraintsFromSetKategorieeinhaus($kategorieeinhaus))) {
            throw new \InvalidArgumentException($kategorieeinhausArrayErrorMessage, __LINE__);
        }
        if (is_null($kategorieeinhaus) || (is_array($kategorieeinhaus) && empty($kategorieeinhaus))) {
            unset($this->kategorieeinhaus);
        } else {
            $this->kategorieeinhaus = $kategorieeinhaus;
        }
        return $this;
    }
    /**
     * Add item to kategorieeinhaus value
     * @throws \InvalidArgumentException
     * @param \StructType\Kategorieeinhaus $item
     * @return \StructType\Kategorienjehaus
     */
    public function addToKategorieeinhaus(\StructType\Kategorieeinhaus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kategorieeinhaus) {
            throw new \InvalidArgumentException(sprintf('The kategorieeinhaus property can only contain items of type \StructType\Kategorieeinhaus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorieeinhaus[] = $item;
        return $this;
    }
}
