<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hausbilder StructType
 * @subpackage Structs
 */
class Hausbilder extends AbstractStructBase
{
    /**
     * The hausbild
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hausbild[]
     */
    public $hausbild;
    /**
     * Constructor method for hausbilder
     * @uses Hausbilder::setHausbild()
     * @param \StructType\Hausbild[] $hausbild
     */
    public function __construct(array $hausbild = array())
    {
        $this
            ->setHausbild($hausbild);
    }
    /**
     * Get hausbild value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hausbild[]|null
     */
    public function getHausbild()
    {
        return isset($this->hausbild) ? $this->hausbild : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHausbild method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHausbild method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHausbildForArrayConstraintsFromSetHausbild(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausbilderHausbildItem) {
            // validation for constraint: itemType
            if (!$hausbilderHausbildItem instanceof \StructType\Hausbild) {
                $invalidValues[] = is_object($hausbilderHausbildItem) ? get_class($hausbilderHausbildItem) : sprintf('%s(%s)', gettype($hausbilderHausbildItem), var_export($hausbilderHausbildItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hausbild property can only contain items of type \StructType\Hausbild, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hausbild value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hausbild[] $hausbild
     * @return \StructType\Hausbilder
     */
    public function setHausbild(array $hausbild = array())
    {
        // validation for constraint: array
        if ('' !== ($hausbildArrayErrorMessage = self::validateHausbildForArrayConstraintsFromSetHausbild($hausbild))) {
            throw new \InvalidArgumentException($hausbildArrayErrorMessage, __LINE__);
        }
        if (is_null($hausbild) || (is_array($hausbild) && empty($hausbild))) {
            unset($this->hausbild);
        } else {
            $this->hausbild = $hausbild;
        }
        return $this;
    }
    /**
     * Add item to hausbild value
     * @throws \InvalidArgumentException
     * @param \StructType\Hausbild $item
     * @return \StructType\Hausbilder
     */
    public function addToHausbild(\StructType\Hausbild $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hausbild) {
            throw new \InvalidArgumentException(sprintf('The hausbild property can only contain items of type \StructType\Hausbild, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hausbild[] = $item;
        return $this;
    }
}
