<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hausbild StructType
 * @subpackage Structs
 */
class Hausbild extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The groesse
     * @var int
     */
    public $groesse;
    /**
     * The x
     * @var int
     */
    public $x;
    /**
     * The y
     * @var int
     */
    public $y;
    /**
     * The klasse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $klasse;
    /**
     * The prioritaet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $prioritaet;
    /**
     * The kurzbezeichnungen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Sprachbezeichnung[]
     */
    public $kurzbezeichnungen;
    /**
     * The art
     * @var string
     */
    public $art;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * Constructor method for hausbild
     * @uses Hausbild::setId()
     * @uses Hausbild::setGroesse()
     * @uses Hausbild::setX()
     * @uses Hausbild::setY()
     * @uses Hausbild::setKlasse()
     * @uses Hausbild::setPrioritaet()
     * @uses Hausbild::setKurzbezeichnungen()
     * @uses Hausbild::setArt()
     * @uses Hausbild::setStatus()
     * @param int $id
     * @param int $groesse
     * @param int $x
     * @param int $y
     * @param int[] $klasse
     * @param int[] $prioritaet
     * @param \StructType\Sprachbezeichnung[] $kurzbezeichnungen
     * @param string $art
     * @param int $status
     */
    public function __construct($id = null, $groesse = null, $x = null, $y = null, array $klasse = array(), array $prioritaet = array(), array $kurzbezeichnungen = array(), $art = null, $status = null)
    {
        $this
            ->setId($id)
            ->setGroesse($groesse)
            ->setX($x)
            ->setY($y)
            ->setKlasse($klasse)
            ->setPrioritaet($prioritaet)
            ->setKurzbezeichnungen($kurzbezeichnungen)
            ->setArt($art)
            ->setStatus($status);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Hausbild
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get groesse value
     * @return int|null
     */
    public function getGroesse()
    {
        return $this->groesse;
    }
    /**
     * Set groesse value
     * @param int $groesse
     * @return \StructType\Hausbild
     */
    public function setGroesse($groesse = null)
    {
        // validation for constraint: int
        if (!is_null($groesse) && !(is_int($groesse) || ctype_digit($groesse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groesse, true), gettype($groesse)), __LINE__);
        }
        $this->groesse = $groesse;
        return $this;
    }
    /**
     * Get x value
     * @return int|null
     */
    public function getX()
    {
        return $this->x;
    }
    /**
     * Set x value
     * @param int $x
     * @return \StructType\Hausbild
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !(is_int($x) || ctype_digit($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->x = $x;
        return $this;
    }
    /**
     * Get y value
     * @return int|null
     */
    public function getY()
    {
        return $this->y;
    }
    /**
     * Set y value
     * @param int $y
     * @return \StructType\Hausbild
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !(is_int($y) || ctype_digit($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->y = $y;
        return $this;
    }
    /**
     * Get klasse value
     * @return int[]|null
     */
    public function getKlasse()
    {
        return $this->klasse;
    }
    /**
     * This method is responsible for validating the values passed to the setKlasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlasseForArrayConstraintsFromSetKlasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausbildKlasseItem) {
            // validation for constraint: itemType
            if (!(is_int($hausbildKlasseItem) || ctype_digit($hausbildKlasseItem))) {
                $invalidValues[] = is_object($hausbildKlasseItem) ? get_class($hausbildKlasseItem) : sprintf('%s(%s)', gettype($hausbildKlasseItem), var_export($hausbildKlasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The klasse property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set klasse value
     * @throws \InvalidArgumentException
     * @param int[] $klasse
     * @return \StructType\Hausbild
     */
    public function setKlasse(array $klasse = array())
    {
        // validation for constraint: array
        if ('' !== ($klasseArrayErrorMessage = self::validateKlasseForArrayConstraintsFromSetKlasse($klasse))) {
            throw new \InvalidArgumentException($klasseArrayErrorMessage, __LINE__);
        }
        $this->klasse = $klasse;
        return $this;
    }
    /**
     * Add item to klasse value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Hausbild
     */
    public function addToKlasse($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The klasse property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->klasse[] = $item;
        return $this;
    }
    /**
     * Get prioritaet value
     * @return int[]|null
     */
    public function getPrioritaet()
    {
        return $this->prioritaet;
    }
    /**
     * This method is responsible for validating the values passed to the setPrioritaet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrioritaet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrioritaetForArrayConstraintsFromSetPrioritaet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausbildPrioritaetItem) {
            // validation for constraint: itemType
            if (!(is_int($hausbildPrioritaetItem) || ctype_digit($hausbildPrioritaetItem))) {
                $invalidValues[] = is_object($hausbildPrioritaetItem) ? get_class($hausbildPrioritaetItem) : sprintf('%s(%s)', gettype($hausbildPrioritaetItem), var_export($hausbildPrioritaetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The prioritaet property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set prioritaet value
     * @throws \InvalidArgumentException
     * @param int[] $prioritaet
     * @return \StructType\Hausbild
     */
    public function setPrioritaet(array $prioritaet = array())
    {
        // validation for constraint: array
        if ('' !== ($prioritaetArrayErrorMessage = self::validatePrioritaetForArrayConstraintsFromSetPrioritaet($prioritaet))) {
            throw new \InvalidArgumentException($prioritaetArrayErrorMessage, __LINE__);
        }
        $this->prioritaet = $prioritaet;
        return $this;
    }
    /**
     * Add item to prioritaet value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Hausbild
     */
    public function addToPrioritaet($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The prioritaet property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->prioritaet[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnungen value
     * @return \StructType\Sprachbezeichnung[]|null
     */
    public function getKurzbezeichnungen()
    {
        return $this->kurzbezeichnungen;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungenForArrayConstraintsFromSetKurzbezeichnungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausbildKurzbezeichnungenItem) {
            // validation for constraint: itemType
            if (!$hausbildKurzbezeichnungenItem instanceof \StructType\Sprachbezeichnung) {
                $invalidValues[] = is_object($hausbildKurzbezeichnungenItem) ? get_class($hausbildKurzbezeichnungenItem) : sprintf('%s(%s)', gettype($hausbildKurzbezeichnungenItem), var_export($hausbildKurzbezeichnungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnungen property can only contain items of type \StructType\Sprachbezeichnung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnungen value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachbezeichnung[] $kurzbezeichnungen
     * @return \StructType\Hausbild
     */
    public function setKurzbezeichnungen(array $kurzbezeichnungen = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungenArrayErrorMessage = self::validateKurzbezeichnungenForArrayConstraintsFromSetKurzbezeichnungen($kurzbezeichnungen))) {
            throw new \InvalidArgumentException($kurzbezeichnungenArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnungen = $kurzbezeichnungen;
        return $this;
    }
    /**
     * Add item to kurzbezeichnungen value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachbezeichnung $item
     * @return \StructType\Hausbild
     */
    public function addToKurzbezeichnungen(\StructType\Sprachbezeichnung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprachbezeichnung) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnungen property can only contain items of type \StructType\Sprachbezeichnung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnungen[] = $item;
        return $this;
    }
    /**
     * Get art value
     * @return string|null
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param string $art
     * @return \StructType\Hausbild
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Hausbild
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
