<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for haus StructType
 * @subpackage Structs
 */
class Haus extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The gueltigab
     * @var int
     */
    public $gueltigab;
    /**
     * The gueltigbis
     * @var int
     */
    public $gueltigbis;
    /**
     * The lastchange
     * @var string
     */
    public $lastchange;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The hausnr
     * @var string
     */
    public $hausnr;
    /**
     * The hausname
     * @var string
     */
    public $hausname;
    /**
     * The firma1
     * @var string
     */
    public $firma1;
    /**
     * The firma2
     * @var string
     */
    public $firma2;
    /**
     * The anredeid
     * @var int
     */
    public $anredeid;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The strasse
     * @var string
     */
    public $strasse;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The ortsteilid
     * @var int
     */
    public $ortsteilid;
    /**
     * The bezirkid
     * @var int
     */
    public $bezirkid;
    /**
     * The landid
     * @var int
     */
    public $landid;
    /**
     * The telefon
     * @var string
     */
    public $telefon;
    /**
     * The telefonp
     * @var string
     */
    public $telefonp;
    /**
     * The telefona
     * @var string
     */
    public $telefona;
    /**
     * The mobil
     * @var string
     */
    public $mobil;
    /**
     * The telefax
     * @var string
     */
    public $telefax;
    /**
     * The telefax2
     * @var string
     */
    public $telefax2;
    /**
     * The kategorieid
     * @var int
     */
    public $kategorieid;
    /**
     * The kategorieid2
     * @var int
     */
    public $kategorieid2;
    /**
     * The kategorieid3
     * @var int
     */
    public $kategorieid3;
    /**
     * The kategorieid4
     * @var int
     */
    public $kategorieid4;
    /**
     * The kategorieid5
     * @var int
     */
    public $kategorieid5;
    /**
     * The kurzoneid
     * @var int
     */
    public $kurzoneid;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The www
     * @var string
     */
    public $www;
    /**
     * The dehoga
     * @var int
     */
    public $dehoga;
    /**
     * The superior
     * @var int
     */
    public $superior;
    /**
     * The gklass
     * @var int
     */
    public $gklass;
    /**
     * The dtvp
     * @var int
     */
    public $dtvp;
    /**
     * The statlanr
     * @var string
     */
    public $statlanr;
    /**
     * The perskto
     * @var string
     */
    public $perskto;
    /**
     * The objektnr
     * @var string
     */
    public $objektnr;
    /**
     * The blz
     * @var string
     */
    public $blz;
    /**
     * The ktonr
     * @var string
     */
    public $ktonr;
    /**
     * The bankname
     * @var string
     */
    public $bankname;
    /**
     * The iban
     * @var string
     */
    public $iban;
    /**
     * The bic
     * @var string
     */
    public $bic;
    /**
     * The steuernr
     * @var string
     */
    public $steuernr;
    /**
     * The ustid
     * @var string
     */
    public $ustid;
    /**
     * The hauseigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Hauseigenschaften[]
     */
    public $hauseigenschaften;
    /**
     * The bildid
     * @var int
     */
    public $bildid;
    /**
     * The altersaufteilung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $altersaufteilung;
    /**
     * The sperre
     * @var int
     */
    public $sperre;
    /**
     * The geodata
     * @var string
     */
    public $geodata;
    /**
     * The needcc
     * @var bool
     */
    public $needcc;
    /**
     * The uebprov
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $uebprov;
    /**
     * The lstprov
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lstprov;
    /**
     * The tileisterlaubt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tileisterlaubt;
    /**
     * The baerchen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $baerchen;
    /**
     * The edelweis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $edelweis;
    /**
     * The edelweisSuperior
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $edelweisSuperior;
    /**
     * The margeriten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $margeriten;
    /**
     * The preisinfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $preisinfo;
    /**
     * The buchbar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var bool[]
     */
    public $buchbar;
    /**
     * The dtvfwmin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $dtvfwmin;
    /**
     * The dtvfwmax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $dtvfwmax;
    /**
     * The sortierbegriff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $sortierbegriff;
    /**
     * The plankoord
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $plankoord;
    /**
     * The hauspanorama
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Panorama[]
     */
    public $hauspanorama;
    /**
     * Constructor method for haus
     * @uses Haus::setOrtid()
     * @uses Haus::setHausid()
     * @uses Haus::setGueltigab()
     * @uses Haus::setGueltigbis()
     * @uses Haus::setLastchange()
     * @uses Haus::setStatus()
     * @uses Haus::setHausnr()
     * @uses Haus::setHausname()
     * @uses Haus::setFirma1()
     * @uses Haus::setFirma2()
     * @uses Haus::setAnredeid()
     * @uses Haus::setVorname()
     * @uses Haus::setNachname()
     * @uses Haus::setStrasse()
     * @uses Haus::setPlz()
     * @uses Haus::setOrt()
     * @uses Haus::setOrtsteilid()
     * @uses Haus::setBezirkid()
     * @uses Haus::setLandid()
     * @uses Haus::setTelefon()
     * @uses Haus::setTelefonp()
     * @uses Haus::setTelefona()
     * @uses Haus::setMobil()
     * @uses Haus::setTelefax()
     * @uses Haus::setTelefax2()
     * @uses Haus::setKategorieid()
     * @uses Haus::setKategorieid2()
     * @uses Haus::setKategorieid3()
     * @uses Haus::setKategorieid4()
     * @uses Haus::setKategorieid5()
     * @uses Haus::setKurzoneid()
     * @uses Haus::setEmail()
     * @uses Haus::setWww()
     * @uses Haus::setDehoga()
     * @uses Haus::setSuperior()
     * @uses Haus::setGklass()
     * @uses Haus::setDtvp()
     * @uses Haus::setStatlanr()
     * @uses Haus::setPerskto()
     * @uses Haus::setObjektnr()
     * @uses Haus::setBlz()
     * @uses Haus::setKtonr()
     * @uses Haus::setBankname()
     * @uses Haus::setIban()
     * @uses Haus::setBic()
     * @uses Haus::setSteuernr()
     * @uses Haus::setUstid()
     * @uses Haus::setHauseigenschaften()
     * @uses Haus::setBildid()
     * @uses Haus::setAltersaufteilung()
     * @uses Haus::setSperre()
     * @uses Haus::setGeodata()
     * @uses Haus::setNeedcc()
     * @uses Haus::setUebprov()
     * @uses Haus::setLstprov()
     * @uses Haus::setTileisterlaubt()
     * @uses Haus::setBaerchen()
     * @uses Haus::setEdelweis()
     * @uses Haus::setEdelweisSuperior()
     * @uses Haus::setMargeriten()
     * @uses Haus::setPreisinfo()
     * @uses Haus::setBuchbar()
     * @uses Haus::setDtvfwmin()
     * @uses Haus::setDtvfwmax()
     * @uses Haus::setSortierbegriff()
     * @uses Haus::setPlankoord()
     * @uses Haus::setHauspanorama()
     * @param int $ortid
     * @param int $hausid
     * @param int $gueltigab
     * @param int $gueltigbis
     * @param string $lastchange
     * @param int $status
     * @param string $hausnr
     * @param string $hausname
     * @param string $firma1
     * @param string $firma2
     * @param int $anredeid
     * @param string $vorname
     * @param string $nachname
     * @param string $strasse
     * @param string $plz
     * @param string $ort
     * @param int $ortsteilid
     * @param int $bezirkid
     * @param int $landid
     * @param string $telefon
     * @param string $telefonp
     * @param string $telefona
     * @param string $mobil
     * @param string $telefax
     * @param string $telefax2
     * @param int $kategorieid
     * @param int $kategorieid2
     * @param int $kategorieid3
     * @param int $kategorieid4
     * @param int $kategorieid5
     * @param int $kurzoneid
     * @param string $email
     * @param string $www
     * @param int $dehoga
     * @param int $superior
     * @param int $gklass
     * @param int $dtvp
     * @param string $statlanr
     * @param string $perskto
     * @param string $objektnr
     * @param string $blz
     * @param string $ktonr
     * @param string $bankname
     * @param string $iban
     * @param string $bic
     * @param string $steuernr
     * @param string $ustid
     * @param \StructType\Hauseigenschaften[] $hauseigenschaften
     * @param int $bildid
     * @param int[] $altersaufteilung
     * @param int $sperre
     * @param string $geodata
     * @param bool $needcc
     * @param int $uebprov
     * @param int $lstprov
     * @param int $tileisterlaubt
     * @param int[] $baerchen
     * @param int[] $edelweis
     * @param int[] $edelweisSuperior
     * @param int[] $margeriten
     * @param string[] $preisinfo
     * @param bool[] $buchbar
     * @param int[] $dtvfwmin
     * @param int[] $dtvfwmax
     * @param string[] $sortierbegriff
     * @param string[] $plankoord
     * @param \StructType\Panorama[] $hauspanorama
     */
    public function __construct($ortid = null, $hausid = null, $gueltigab = null, $gueltigbis = null, $lastchange = null, $status = null, $hausnr = null, $hausname = null, $firma1 = null, $firma2 = null, $anredeid = null, $vorname = null, $nachname = null, $strasse = null, $plz = null, $ort = null, $ortsteilid = null, $bezirkid = null, $landid = null, $telefon = null, $telefonp = null, $telefona = null, $mobil = null, $telefax = null, $telefax2 = null, $kategorieid = null, $kategorieid2 = null, $kategorieid3 = null, $kategorieid4 = null, $kategorieid5 = null, $kurzoneid = null, $email = null, $www = null, $dehoga = null, $superior = null, $gklass = null, $dtvp = null, $statlanr = null, $perskto = null, $objektnr = null, $blz = null, $ktonr = null, $bankname = null, $iban = null, $bic = null, $steuernr = null, $ustid = null, array $hauseigenschaften = array(), $bildid = null, array $altersaufteilung = array(), $sperre = null, $geodata = null, $needcc = null, $uebprov = null, $lstprov = null, $tileisterlaubt = null, array $baerchen = array(), array $edelweis = array(), array $edelweisSuperior = array(), array $margeriten = array(), array $preisinfo = array(), array $buchbar = array(), array $dtvfwmin = array(), array $dtvfwmax = array(), array $sortierbegriff = array(), array $plankoord = array(), array $hauspanorama = array())
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setGueltigab($gueltigab)
            ->setGueltigbis($gueltigbis)
            ->setLastchange($lastchange)
            ->setStatus($status)
            ->setHausnr($hausnr)
            ->setHausname($hausname)
            ->setFirma1($firma1)
            ->setFirma2($firma2)
            ->setAnredeid($anredeid)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setStrasse($strasse)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setOrtsteilid($ortsteilid)
            ->setBezirkid($bezirkid)
            ->setLandid($landid)
            ->setTelefon($telefon)
            ->setTelefonp($telefonp)
            ->setTelefona($telefona)
            ->setMobil($mobil)
            ->setTelefax($telefax)
            ->setTelefax2($telefax2)
            ->setKategorieid($kategorieid)
            ->setKategorieid2($kategorieid2)
            ->setKategorieid3($kategorieid3)
            ->setKategorieid4($kategorieid4)
            ->setKategorieid5($kategorieid5)
            ->setKurzoneid($kurzoneid)
            ->setEmail($email)
            ->setWww($www)
            ->setDehoga($dehoga)
            ->setSuperior($superior)
            ->setGklass($gklass)
            ->setDtvp($dtvp)
            ->setStatlanr($statlanr)
            ->setPerskto($perskto)
            ->setObjektnr($objektnr)
            ->setBlz($blz)
            ->setKtonr($ktonr)
            ->setBankname($bankname)
            ->setIban($iban)
            ->setBic($bic)
            ->setSteuernr($steuernr)
            ->setUstid($ustid)
            ->setHauseigenschaften($hauseigenschaften)
            ->setBildid($bildid)
            ->setAltersaufteilung($altersaufteilung)
            ->setSperre($sperre)
            ->setGeodata($geodata)
            ->setNeedcc($needcc)
            ->setUebprov($uebprov)
            ->setLstprov($lstprov)
            ->setTileisterlaubt($tileisterlaubt)
            ->setBaerchen($baerchen)
            ->setEdelweis($edelweis)
            ->setEdelweisSuperior($edelweisSuperior)
            ->setMargeriten($margeriten)
            ->setPreisinfo($preisinfo)
            ->setBuchbar($buchbar)
            ->setDtvfwmin($dtvfwmin)
            ->setDtvfwmax($dtvfwmax)
            ->setSortierbegriff($sortierbegriff)
            ->setPlankoord($plankoord)
            ->setHauspanorama($hauspanorama);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Haus
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Haus
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get gueltigab value
     * @return int|null
     */
    public function getGueltigab()
    {
        return $this->gueltigab;
    }
    /**
     * Set gueltigab value
     * @param int $gueltigab
     * @return \StructType\Haus
     */
    public function setGueltigab($gueltigab = null)
    {
        // validation for constraint: int
        if (!is_null($gueltigab) && !(is_int($gueltigab) || ctype_digit($gueltigab))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gueltigab, true), gettype($gueltigab)), __LINE__);
        }
        $this->gueltigab = $gueltigab;
        return $this;
    }
    /**
     * Get gueltigbis value
     * @return int|null
     */
    public function getGueltigbis()
    {
        return $this->gueltigbis;
    }
    /**
     * Set gueltigbis value
     * @param int $gueltigbis
     * @return \StructType\Haus
     */
    public function setGueltigbis($gueltigbis = null)
    {
        // validation for constraint: int
        if (!is_null($gueltigbis) && !(is_int($gueltigbis) || ctype_digit($gueltigbis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gueltigbis, true), gettype($gueltigbis)), __LINE__);
        }
        $this->gueltigbis = $gueltigbis;
        return $this;
    }
    /**
     * Get lastchange value
     * @return string|null
     */
    public function getLastchange()
    {
        return $this->lastchange;
    }
    /**
     * Set lastchange value
     * @param string $lastchange
     * @return \StructType\Haus
     */
    public function setLastchange($lastchange = null)
    {
        // validation for constraint: string
        if (!is_null($lastchange) && !is_string($lastchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastchange, true), gettype($lastchange)), __LINE__);
        }
        $this->lastchange = $lastchange;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Haus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get hausnr value
     * @return string|null
     */
    public function getHausnr()
    {
        return $this->hausnr;
    }
    /**
     * Set hausnr value
     * @param string $hausnr
     * @return \StructType\Haus
     */
    public function setHausnr($hausnr = null)
    {
        // validation for constraint: string
        if (!is_null($hausnr) && !is_string($hausnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnr, true), gettype($hausnr)), __LINE__);
        }
        $this->hausnr = $hausnr;
        return $this;
    }
    /**
     * Get hausname value
     * @return string|null
     */
    public function getHausname()
    {
        return $this->hausname;
    }
    /**
     * Set hausname value
     * @param string $hausname
     * @return \StructType\Haus
     */
    public function setHausname($hausname = null)
    {
        // validation for constraint: string
        if (!is_null($hausname) && !is_string($hausname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausname, true), gettype($hausname)), __LINE__);
        }
        $this->hausname = $hausname;
        return $this;
    }
    /**
     * Get firma1 value
     * @return string|null
     */
    public function getFirma1()
    {
        return $this->firma1;
    }
    /**
     * Set firma1 value
     * @param string $firma1
     * @return \StructType\Haus
     */
    public function setFirma1($firma1 = null)
    {
        // validation for constraint: string
        if (!is_null($firma1) && !is_string($firma1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma1, true), gettype($firma1)), __LINE__);
        }
        $this->firma1 = $firma1;
        return $this;
    }
    /**
     * Get firma2 value
     * @return string|null
     */
    public function getFirma2()
    {
        return $this->firma2;
    }
    /**
     * Set firma2 value
     * @param string $firma2
     * @return \StructType\Haus
     */
    public function setFirma2($firma2 = null)
    {
        // validation for constraint: string
        if (!is_null($firma2) && !is_string($firma2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma2, true), gettype($firma2)), __LINE__);
        }
        $this->firma2 = $firma2;
        return $this;
    }
    /**
     * Get anredeid value
     * @return int|null
     */
    public function getAnredeid()
    {
        return $this->anredeid;
    }
    /**
     * Set anredeid value
     * @param int $anredeid
     * @return \StructType\Haus
     */
    public function setAnredeid($anredeid = null)
    {
        // validation for constraint: int
        if (!is_null($anredeid) && !(is_int($anredeid) || ctype_digit($anredeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anredeid, true), gettype($anredeid)), __LINE__);
        }
        $this->anredeid = $anredeid;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Haus
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\Haus
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Haus
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Haus
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Haus
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get ortsteilid value
     * @return int|null
     */
    public function getOrtsteilid()
    {
        return $this->ortsteilid;
    }
    /**
     * Set ortsteilid value
     * @param int $ortsteilid
     * @return \StructType\Haus
     */
    public function setOrtsteilid($ortsteilid = null)
    {
        // validation for constraint: int
        if (!is_null($ortsteilid) && !(is_int($ortsteilid) || ctype_digit($ortsteilid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortsteilid, true), gettype($ortsteilid)), __LINE__);
        }
        $this->ortsteilid = $ortsteilid;
        return $this;
    }
    /**
     * Get bezirkid value
     * @return int|null
     */
    public function getBezirkid()
    {
        return $this->bezirkid;
    }
    /**
     * Set bezirkid value
     * @param int $bezirkid
     * @return \StructType\Haus
     */
    public function setBezirkid($bezirkid = null)
    {
        // validation for constraint: int
        if (!is_null($bezirkid) && !(is_int($bezirkid) || ctype_digit($bezirkid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bezirkid, true), gettype($bezirkid)), __LINE__);
        }
        $this->bezirkid = $bezirkid;
        return $this;
    }
    /**
     * Get landid value
     * @return int|null
     */
    public function getLandid()
    {
        return $this->landid;
    }
    /**
     * Set landid value
     * @param int $landid
     * @return \StructType\Haus
     */
    public function setLandid($landid = null)
    {
        // validation for constraint: int
        if (!is_null($landid) && !(is_int($landid) || ctype_digit($landid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landid, true), gettype($landid)), __LINE__);
        }
        $this->landid = $landid;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Haus
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get telefonp value
     * @return string|null
     */
    public function getTelefonp()
    {
        return $this->telefonp;
    }
    /**
     * Set telefonp value
     * @param string $telefonp
     * @return \StructType\Haus
     */
    public function setTelefonp($telefonp = null)
    {
        // validation for constraint: string
        if (!is_null($telefonp) && !is_string($telefonp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonp, true), gettype($telefonp)), __LINE__);
        }
        $this->telefonp = $telefonp;
        return $this;
    }
    /**
     * Get telefona value
     * @return string|null
     */
    public function getTelefona()
    {
        return $this->telefona;
    }
    /**
     * Set telefona value
     * @param string $telefona
     * @return \StructType\Haus
     */
    public function setTelefona($telefona = null)
    {
        // validation for constraint: string
        if (!is_null($telefona) && !is_string($telefona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefona, true), gettype($telefona)), __LINE__);
        }
        $this->telefona = $telefona;
        return $this;
    }
    /**
     * Get mobil value
     * @return string|null
     */
    public function getMobil()
    {
        return $this->mobil;
    }
    /**
     * Set mobil value
     * @param string $mobil
     * @return \StructType\Haus
     */
    public function setMobil($mobil = null)
    {
        // validation for constraint: string
        if (!is_null($mobil) && !is_string($mobil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobil, true), gettype($mobil)), __LINE__);
        }
        $this->mobil = $mobil;
        return $this;
    }
    /**
     * Get telefax value
     * @return string|null
     */
    public function getTelefax()
    {
        return $this->telefax;
    }
    /**
     * Set telefax value
     * @param string $telefax
     * @return \StructType\Haus
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax, true), gettype($telefax)), __LINE__);
        }
        $this->telefax = $telefax;
        return $this;
    }
    /**
     * Get telefax2 value
     * @return string|null
     */
    public function getTelefax2()
    {
        return $this->telefax2;
    }
    /**
     * Set telefax2 value
     * @param string $telefax2
     * @return \StructType\Haus
     */
    public function setTelefax2($telefax2 = null)
    {
        // validation for constraint: string
        if (!is_null($telefax2) && !is_string($telefax2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax2, true), gettype($telefax2)), __LINE__);
        }
        $this->telefax2 = $telefax2;
        return $this;
    }
    /**
     * Get kategorieid value
     * @return int|null
     */
    public function getKategorieid()
    {
        return $this->kategorieid;
    }
    /**
     * Set kategorieid value
     * @param int $kategorieid
     * @return \StructType\Haus
     */
    public function setKategorieid($kategorieid = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid) && !(is_int($kategorieid) || ctype_digit($kategorieid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid, true), gettype($kategorieid)), __LINE__);
        }
        $this->kategorieid = $kategorieid;
        return $this;
    }
    /**
     * Get kategorieid2 value
     * @return int|null
     */
    public function getKategorieid2()
    {
        return $this->kategorieid2;
    }
    /**
     * Set kategorieid2 value
     * @param int $kategorieid2
     * @return \StructType\Haus
     */
    public function setKategorieid2($kategorieid2 = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid2) && !(is_int($kategorieid2) || ctype_digit($kategorieid2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid2, true), gettype($kategorieid2)), __LINE__);
        }
        $this->kategorieid2 = $kategorieid2;
        return $this;
    }
    /**
     * Get kategorieid3 value
     * @return int|null
     */
    public function getKategorieid3()
    {
        return $this->kategorieid3;
    }
    /**
     * Set kategorieid3 value
     * @param int $kategorieid3
     * @return \StructType\Haus
     */
    public function setKategorieid3($kategorieid3 = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid3) && !(is_int($kategorieid3) || ctype_digit($kategorieid3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid3, true), gettype($kategorieid3)), __LINE__);
        }
        $this->kategorieid3 = $kategorieid3;
        return $this;
    }
    /**
     * Get kategorieid4 value
     * @return int|null
     */
    public function getKategorieid4()
    {
        return $this->kategorieid4;
    }
    /**
     * Set kategorieid4 value
     * @param int $kategorieid4
     * @return \StructType\Haus
     */
    public function setKategorieid4($kategorieid4 = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid4) && !(is_int($kategorieid4) || ctype_digit($kategorieid4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid4, true), gettype($kategorieid4)), __LINE__);
        }
        $this->kategorieid4 = $kategorieid4;
        return $this;
    }
    /**
     * Get kategorieid5 value
     * @return int|null
     */
    public function getKategorieid5()
    {
        return $this->kategorieid5;
    }
    /**
     * Set kategorieid5 value
     * @param int $kategorieid5
     * @return \StructType\Haus
     */
    public function setKategorieid5($kategorieid5 = null)
    {
        // validation for constraint: int
        if (!is_null($kategorieid5) && !(is_int($kategorieid5) || ctype_digit($kategorieid5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorieid5, true), gettype($kategorieid5)), __LINE__);
        }
        $this->kategorieid5 = $kategorieid5;
        return $this;
    }
    /**
     * Get kurzoneid value
     * @return int|null
     */
    public function getKurzoneid()
    {
        return $this->kurzoneid;
    }
    /**
     * Set kurzoneid value
     * @param int $kurzoneid
     * @return \StructType\Haus
     */
    public function setKurzoneid($kurzoneid = null)
    {
        // validation for constraint: int
        if (!is_null($kurzoneid) && !(is_int($kurzoneid) || ctype_digit($kurzoneid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kurzoneid, true), gettype($kurzoneid)), __LINE__);
        }
        $this->kurzoneid = $kurzoneid;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Haus
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get www value
     * @return string|null
     */
    public function getWww()
    {
        return $this->www;
    }
    /**
     * Set www value
     * @param string $www
     * @return \StructType\Haus
     */
    public function setWww($www = null)
    {
        // validation for constraint: string
        if (!is_null($www) && !is_string($www)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($www, true), gettype($www)), __LINE__);
        }
        $this->www = $www;
        return $this;
    }
    /**
     * Get dehoga value
     * @return int|null
     */
    public function getDehoga()
    {
        return $this->dehoga;
    }
    /**
     * Set dehoga value
     * @param int $dehoga
     * @return \StructType\Haus
     */
    public function setDehoga($dehoga = null)
    {
        // validation for constraint: int
        if (!is_null($dehoga) && !(is_int($dehoga) || ctype_digit($dehoga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dehoga, true), gettype($dehoga)), __LINE__);
        }
        $this->dehoga = $dehoga;
        return $this;
    }
    /**
     * Get superior value
     * @return int|null
     */
    public function getSuperior()
    {
        return $this->superior;
    }
    /**
     * Set superior value
     * @param int $superior
     * @return \StructType\Haus
     */
    public function setSuperior($superior = null)
    {
        // validation for constraint: int
        if (!is_null($superior) && !(is_int($superior) || ctype_digit($superior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($superior, true), gettype($superior)), __LINE__);
        }
        $this->superior = $superior;
        return $this;
    }
    /**
     * Get gklass value
     * @return int|null
     */
    public function getGklass()
    {
        return $this->gklass;
    }
    /**
     * Set gklass value
     * @param int $gklass
     * @return \StructType\Haus
     */
    public function setGklass($gklass = null)
    {
        // validation for constraint: int
        if (!is_null($gklass) && !(is_int($gklass) || ctype_digit($gklass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gklass, true), gettype($gklass)), __LINE__);
        }
        $this->gklass = $gklass;
        return $this;
    }
    /**
     * Get dtvp value
     * @return int|null
     */
    public function getDtvp()
    {
        return $this->dtvp;
    }
    /**
     * Set dtvp value
     * @param int $dtvp
     * @return \StructType\Haus
     */
    public function setDtvp($dtvp = null)
    {
        // validation for constraint: int
        if (!is_null($dtvp) && !(is_int($dtvp) || ctype_digit($dtvp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dtvp, true), gettype($dtvp)), __LINE__);
        }
        $this->dtvp = $dtvp;
        return $this;
    }
    /**
     * Get statlanr value
     * @return string|null
     */
    public function getStatlanr()
    {
        return $this->statlanr;
    }
    /**
     * Set statlanr value
     * @param string $statlanr
     * @return \StructType\Haus
     */
    public function setStatlanr($statlanr = null)
    {
        // validation for constraint: string
        if (!is_null($statlanr) && !is_string($statlanr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statlanr, true), gettype($statlanr)), __LINE__);
        }
        $this->statlanr = $statlanr;
        return $this;
    }
    /**
     * Get perskto value
     * @return string|null
     */
    public function getPerskto()
    {
        return $this->perskto;
    }
    /**
     * Set perskto value
     * @param string $perskto
     * @return \StructType\Haus
     */
    public function setPerskto($perskto = null)
    {
        // validation for constraint: string
        if (!is_null($perskto) && !is_string($perskto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perskto, true), gettype($perskto)), __LINE__);
        }
        $this->perskto = $perskto;
        return $this;
    }
    /**
     * Get objektnr value
     * @return string|null
     */
    public function getObjektnr()
    {
        return $this->objektnr;
    }
    /**
     * Set objektnr value
     * @param string $objektnr
     * @return \StructType\Haus
     */
    public function setObjektnr($objektnr = null)
    {
        // validation for constraint: string
        if (!is_null($objektnr) && !is_string($objektnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objektnr, true), gettype($objektnr)), __LINE__);
        }
        $this->objektnr = $objektnr;
        return $this;
    }
    /**
     * Get blz value
     * @return string|null
     */
    public function getBlz()
    {
        return $this->blz;
    }
    /**
     * Set blz value
     * @param string $blz
     * @return \StructType\Haus
     */
    public function setBlz($blz = null)
    {
        // validation for constraint: string
        if (!is_null($blz) && !is_string($blz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blz, true), gettype($blz)), __LINE__);
        }
        $this->blz = $blz;
        return $this;
    }
    /**
     * Get ktonr value
     * @return string|null
     */
    public function getKtonr()
    {
        return $this->ktonr;
    }
    /**
     * Set ktonr value
     * @param string $ktonr
     * @return \StructType\Haus
     */
    public function setKtonr($ktonr = null)
    {
        // validation for constraint: string
        if (!is_null($ktonr) && !is_string($ktonr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ktonr, true), gettype($ktonr)), __LINE__);
        }
        $this->ktonr = $ktonr;
        return $this;
    }
    /**
     * Get bankname value
     * @return string|null
     */
    public function getBankname()
    {
        return $this->bankname;
    }
    /**
     * Set bankname value
     * @param string $bankname
     * @return \StructType\Haus
     */
    public function setBankname($bankname = null)
    {
        // validation for constraint: string
        if (!is_null($bankname) && !is_string($bankname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankname, true), gettype($bankname)), __LINE__);
        }
        $this->bankname = $bankname;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\Haus
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \StructType\Haus
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get steuernr value
     * @return string|null
     */
    public function getSteuernr()
    {
        return $this->steuernr;
    }
    /**
     * Set steuernr value
     * @param string $steuernr
     * @return \StructType\Haus
     */
    public function setSteuernr($steuernr = null)
    {
        // validation for constraint: string
        if (!is_null($steuernr) && !is_string($steuernr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($steuernr, true), gettype($steuernr)), __LINE__);
        }
        $this->steuernr = $steuernr;
        return $this;
    }
    /**
     * Get ustid value
     * @return string|null
     */
    public function getUstid()
    {
        return $this->ustid;
    }
    /**
     * Set ustid value
     * @param string $ustid
     * @return \StructType\Haus
     */
    public function setUstid($ustid = null)
    {
        // validation for constraint: string
        if (!is_null($ustid) && !is_string($ustid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ustid, true), gettype($ustid)), __LINE__);
        }
        $this->ustid = $ustid;
        return $this;
    }
    /**
     * Get hauseigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Hauseigenschaften[]|null
     */
    public function getHauseigenschaften()
    {
        return isset($this->hauseigenschaften) ? $this->hauseigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHauseigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauseigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausHauseigenschaftenItem) {
            // validation for constraint: itemType
            if (!$hausHauseigenschaftenItem instanceof \StructType\Hauseigenschaften) {
                $invalidValues[] = is_object($hausHauseigenschaftenItem) ? get_class($hausHauseigenschaftenItem) : sprintf('%s(%s)', gettype($hausHauseigenschaftenItem), var_export($hausHauseigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauseigenschaften property can only contain items of type \StructType\Hauseigenschaften, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauseigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hauseigenschaften[] $hauseigenschaften
     * @return \StructType\Haus
     */
    public function setHauseigenschaften(array $hauseigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($hauseigenschaftenArrayErrorMessage = self::validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften($hauseigenschaften))) {
            throw new \InvalidArgumentException($hauseigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($hauseigenschaften) || (is_array($hauseigenschaften) && empty($hauseigenschaften))) {
            unset($this->hauseigenschaften);
        } else {
            $this->hauseigenschaften = $hauseigenschaften;
        }
        return $this;
    }
    /**
     * Add item to hauseigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Hauseigenschaften $item
     * @return \StructType\Haus
     */
    public function addToHauseigenschaften(\StructType\Hauseigenschaften $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hauseigenschaften) {
            throw new \InvalidArgumentException(sprintf('The hauseigenschaften property can only contain items of type \StructType\Hauseigenschaften, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauseigenschaften[] = $item;
        return $this;
    }
    /**
     * Get bildid value
     * @return int|null
     */
    public function getBildid()
    {
        return $this->bildid;
    }
    /**
     * Set bildid value
     * @param int $bildid
     * @return \StructType\Haus
     */
    public function setBildid($bildid = null)
    {
        // validation for constraint: int
        if (!is_null($bildid) && !(is_int($bildid) || ctype_digit($bildid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bildid, true), gettype($bildid)), __LINE__);
        }
        $this->bildid = $bildid;
        return $this;
    }
    /**
     * Get altersaufteilung value
     * @return int[]|null
     */
    public function getAltersaufteilung()
    {
        return $this->altersaufteilung;
    }
    /**
     * This method is responsible for validating the values passed to the setAltersaufteilung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAltersaufteilung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAltersaufteilungForArrayConstraintsFromSetAltersaufteilung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausAltersaufteilungItem) {
            // validation for constraint: itemType
            if (!(is_int($hausAltersaufteilungItem) || ctype_digit($hausAltersaufteilungItem))) {
                $invalidValues[] = is_object($hausAltersaufteilungItem) ? get_class($hausAltersaufteilungItem) : sprintf('%s(%s)', gettype($hausAltersaufteilungItem), var_export($hausAltersaufteilungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The altersaufteilung property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set altersaufteilung value
     * @throws \InvalidArgumentException
     * @param int[] $altersaufteilung
     * @return \StructType\Haus
     */
    public function setAltersaufteilung(array $altersaufteilung = array())
    {
        // validation for constraint: array
        if ('' !== ($altersaufteilungArrayErrorMessage = self::validateAltersaufteilungForArrayConstraintsFromSetAltersaufteilung($altersaufteilung))) {
            throw new \InvalidArgumentException($altersaufteilungArrayErrorMessage, __LINE__);
        }
        $this->altersaufteilung = $altersaufteilung;
        return $this;
    }
    /**
     * Add item to altersaufteilung value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToAltersaufteilung($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The altersaufteilung property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->altersaufteilung[] = $item;
        return $this;
    }
    /**
     * Get sperre value
     * @return int|null
     */
    public function getSperre()
    {
        return $this->sperre;
    }
    /**
     * Set sperre value
     * @param int $sperre
     * @return \StructType\Haus
     */
    public function setSperre($sperre = null)
    {
        // validation for constraint: int
        if (!is_null($sperre) && !(is_int($sperre) || ctype_digit($sperre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sperre, true), gettype($sperre)), __LINE__);
        }
        $this->sperre = $sperre;
        return $this;
    }
    /**
     * Get geodata value
     * @return string|null
     */
    public function getGeodata()
    {
        return $this->geodata;
    }
    /**
     * Set geodata value
     * @param string $geodata
     * @return \StructType\Haus
     */
    public function setGeodata($geodata = null)
    {
        // validation for constraint: string
        if (!is_null($geodata) && !is_string($geodata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geodata, true), gettype($geodata)), __LINE__);
        }
        $this->geodata = $geodata;
        return $this;
    }
    /**
     * Get needcc value
     * @return bool|null
     */
    public function getNeedcc()
    {
        return $this->needcc;
    }
    /**
     * Set needcc value
     * @param bool $needcc
     * @return \StructType\Haus
     */
    public function setNeedcc($needcc = null)
    {
        // validation for constraint: boolean
        if (!is_null($needcc) && !is_bool($needcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needcc, true), gettype($needcc)), __LINE__);
        }
        $this->needcc = $needcc;
        return $this;
    }
    /**
     * Get uebprov value
     * @return int|null
     */
    public function getUebprov()
    {
        return $this->uebprov;
    }
    /**
     * Set uebprov value
     * @param int $uebprov
     * @return \StructType\Haus
     */
    public function setUebprov($uebprov = null)
    {
        // validation for constraint: int
        if (!is_null($uebprov) && !(is_int($uebprov) || ctype_digit($uebprov))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uebprov, true), gettype($uebprov)), __LINE__);
        }
        $this->uebprov = $uebprov;
        return $this;
    }
    /**
     * Get lstprov value
     * @return int|null
     */
    public function getLstprov()
    {
        return $this->lstprov;
    }
    /**
     * Set lstprov value
     * @param int $lstprov
     * @return \StructType\Haus
     */
    public function setLstprov($lstprov = null)
    {
        // validation for constraint: int
        if (!is_null($lstprov) && !(is_int($lstprov) || ctype_digit($lstprov))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lstprov, true), gettype($lstprov)), __LINE__);
        }
        $this->lstprov = $lstprov;
        return $this;
    }
    /**
     * Get tileisterlaubt value
     * @return int|null
     */
    public function getTileisterlaubt()
    {
        return $this->tileisterlaubt;
    }
    /**
     * Set tileisterlaubt value
     * @param int $tileisterlaubt
     * @return \StructType\Haus
     */
    public function setTileisterlaubt($tileisterlaubt = null)
    {
        // validation for constraint: int
        if (!is_null($tileisterlaubt) && !(is_int($tileisterlaubt) || ctype_digit($tileisterlaubt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tileisterlaubt, true), gettype($tileisterlaubt)), __LINE__);
        }
        $this->tileisterlaubt = $tileisterlaubt;
        return $this;
    }
    /**
     * Get baerchen value
     * @return int[]|null
     */
    public function getBaerchen()
    {
        return $this->baerchen;
    }
    /**
     * This method is responsible for validating the values passed to the setBaerchen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaerchen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaerchenForArrayConstraintsFromSetBaerchen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausBaerchenItem) {
            // validation for constraint: itemType
            if (!(is_int($hausBaerchenItem) || ctype_digit($hausBaerchenItem))) {
                $invalidValues[] = is_object($hausBaerchenItem) ? get_class($hausBaerchenItem) : sprintf('%s(%s)', gettype($hausBaerchenItem), var_export($hausBaerchenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baerchen property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baerchen value
     * @throws \InvalidArgumentException
     * @param int[] $baerchen
     * @return \StructType\Haus
     */
    public function setBaerchen(array $baerchen = array())
    {
        // validation for constraint: array
        if ('' !== ($baerchenArrayErrorMessage = self::validateBaerchenForArrayConstraintsFromSetBaerchen($baerchen))) {
            throw new \InvalidArgumentException($baerchenArrayErrorMessage, __LINE__);
        }
        $this->baerchen = $baerchen;
        return $this;
    }
    /**
     * Add item to baerchen value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToBaerchen($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The baerchen property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baerchen[] = $item;
        return $this;
    }
    /**
     * Get edelweis value
     * @return int[]|null
     */
    public function getEdelweis()
    {
        return $this->edelweis;
    }
    /**
     * This method is responsible for validating the values passed to the setEdelweis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEdelweis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEdelweisForArrayConstraintsFromSetEdelweis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausEdelweisItem) {
            // validation for constraint: itemType
            if (!(is_int($hausEdelweisItem) || ctype_digit($hausEdelweisItem))) {
                $invalidValues[] = is_object($hausEdelweisItem) ? get_class($hausEdelweisItem) : sprintf('%s(%s)', gettype($hausEdelweisItem), var_export($hausEdelweisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The edelweis property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set edelweis value
     * @throws \InvalidArgumentException
     * @param int[] $edelweis
     * @return \StructType\Haus
     */
    public function setEdelweis(array $edelweis = array())
    {
        // validation for constraint: array
        if ('' !== ($edelweisArrayErrorMessage = self::validateEdelweisForArrayConstraintsFromSetEdelweis($edelweis))) {
            throw new \InvalidArgumentException($edelweisArrayErrorMessage, __LINE__);
        }
        $this->edelweis = $edelweis;
        return $this;
    }
    /**
     * Add item to edelweis value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToEdelweis($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The edelweis property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->edelweis[] = $item;
        return $this;
    }
    /**
     * Get edelweisSuperior value
     * @return int[]|null
     */
    public function getEdelweisSuperior()
    {
        return $this->edelweisSuperior;
    }
    /**
     * This method is responsible for validating the values passed to the setEdelweisSuperior method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEdelweisSuperior method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEdelweisSuperiorForArrayConstraintsFromSetEdelweisSuperior(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausEdelweisSuperiorItem) {
            // validation for constraint: itemType
            if (!(is_int($hausEdelweisSuperiorItem) || ctype_digit($hausEdelweisSuperiorItem))) {
                $invalidValues[] = is_object($hausEdelweisSuperiorItem) ? get_class($hausEdelweisSuperiorItem) : sprintf('%s(%s)', gettype($hausEdelweisSuperiorItem), var_export($hausEdelweisSuperiorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The edelweisSuperior property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set edelweisSuperior value
     * @throws \InvalidArgumentException
     * @param int[] $edelweisSuperior
     * @return \StructType\Haus
     */
    public function setEdelweisSuperior(array $edelweisSuperior = array())
    {
        // validation for constraint: array
        if ('' !== ($edelweisSuperiorArrayErrorMessage = self::validateEdelweisSuperiorForArrayConstraintsFromSetEdelweisSuperior($edelweisSuperior))) {
            throw new \InvalidArgumentException($edelweisSuperiorArrayErrorMessage, __LINE__);
        }
        $this->edelweisSuperior = $edelweisSuperior;
        return $this;
    }
    /**
     * Add item to edelweisSuperior value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToEdelweisSuperior($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The edelweisSuperior property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->edelweisSuperior[] = $item;
        return $this;
    }
    /**
     * Get margeriten value
     * @return int[]|null
     */
    public function getMargeriten()
    {
        return $this->margeriten;
    }
    /**
     * This method is responsible for validating the values passed to the setMargeriten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMargeriten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMargeritenForArrayConstraintsFromSetMargeriten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausMargeritenItem) {
            // validation for constraint: itemType
            if (!(is_int($hausMargeritenItem) || ctype_digit($hausMargeritenItem))) {
                $invalidValues[] = is_object($hausMargeritenItem) ? get_class($hausMargeritenItem) : sprintf('%s(%s)', gettype($hausMargeritenItem), var_export($hausMargeritenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The margeriten property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set margeriten value
     * @throws \InvalidArgumentException
     * @param int[] $margeriten
     * @return \StructType\Haus
     */
    public function setMargeriten(array $margeriten = array())
    {
        // validation for constraint: array
        if ('' !== ($margeritenArrayErrorMessage = self::validateMargeritenForArrayConstraintsFromSetMargeriten($margeriten))) {
            throw new \InvalidArgumentException($margeritenArrayErrorMessage, __LINE__);
        }
        $this->margeriten = $margeriten;
        return $this;
    }
    /**
     * Add item to margeriten value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToMargeriten($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The margeriten property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->margeriten[] = $item;
        return $this;
    }
    /**
     * Get preisinfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPreisinfo()
    {
        return isset($this->preisinfo) ? $this->preisinfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPreisinfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreisinfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreisinfoForArrayConstraintsFromSetPreisinfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausPreisinfoItem) {
            // validation for constraint: itemType
            if (!is_string($hausPreisinfoItem)) {
                $invalidValues[] = is_object($hausPreisinfoItem) ? get_class($hausPreisinfoItem) : sprintf('%s(%s)', gettype($hausPreisinfoItem), var_export($hausPreisinfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The preisinfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set preisinfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $preisinfo
     * @return \StructType\Haus
     */
    public function setPreisinfo(array $preisinfo = array())
    {
        // validation for constraint: array
        if ('' !== ($preisinfoArrayErrorMessage = self::validatePreisinfoForArrayConstraintsFromSetPreisinfo($preisinfo))) {
            throw new \InvalidArgumentException($preisinfoArrayErrorMessage, __LINE__);
        }
        if (is_null($preisinfo) || (is_array($preisinfo) && empty($preisinfo))) {
            unset($this->preisinfo);
        } else {
            $this->preisinfo = $preisinfo;
        }
        return $this;
    }
    /**
     * Add item to preisinfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Haus
     */
    public function addToPreisinfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The preisinfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->preisinfo[] = $item;
        return $this;
    }
    /**
     * Get buchbar value
     * @return bool[]|null
     */
    public function getBuchbar()
    {
        return $this->buchbar;
    }
    /**
     * This method is responsible for validating the values passed to the setBuchbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBuchbar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBuchbarForArrayConstraintsFromSetBuchbar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausBuchbarItem) {
            // validation for constraint: itemType
            if (!is_bool($hausBuchbarItem)) {
                $invalidValues[] = is_object($hausBuchbarItem) ? get_class($hausBuchbarItem) : sprintf('%s(%s)', gettype($hausBuchbarItem), var_export($hausBuchbarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The buchbar property can only contain items of type boolean, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set buchbar value
     * @throws \InvalidArgumentException
     * @param bool[] $buchbar
     * @return \StructType\Haus
     */
    public function setBuchbar(array $buchbar = array())
    {
        // validation for constraint: array
        if ('' !== ($buchbarArrayErrorMessage = self::validateBuchbarForArrayConstraintsFromSetBuchbar($buchbar))) {
            throw new \InvalidArgumentException($buchbarArrayErrorMessage, __LINE__);
        }
        $this->buchbar = $buchbar;
        return $this;
    }
    /**
     * Add item to buchbar value
     * @throws \InvalidArgumentException
     * @param bool $item
     * @return \StructType\Haus
     */
    public function addToBuchbar($item)
    {
        // validation for constraint: itemType
        if (!is_bool($item)) {
            throw new \InvalidArgumentException(sprintf('The buchbar property can only contain items of type boolean, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->buchbar[] = $item;
        return $this;
    }
    /**
     * Get dtvfwmin value
     * @return int[]|null
     */
    public function getDtvfwmin()
    {
        return $this->dtvfwmin;
    }
    /**
     * This method is responsible for validating the values passed to the setDtvfwmin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtvfwmin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtvfwminForArrayConstraintsFromSetDtvfwmin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausDtvfwminItem) {
            // validation for constraint: itemType
            if (!(is_int($hausDtvfwminItem) || ctype_digit($hausDtvfwminItem))) {
                $invalidValues[] = is_object($hausDtvfwminItem) ? get_class($hausDtvfwminItem) : sprintf('%s(%s)', gettype($hausDtvfwminItem), var_export($hausDtvfwminItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtvfwmin property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtvfwmin value
     * @throws \InvalidArgumentException
     * @param int[] $dtvfwmin
     * @return \StructType\Haus
     */
    public function setDtvfwmin(array $dtvfwmin = array())
    {
        // validation for constraint: array
        if ('' !== ($dtvfwminArrayErrorMessage = self::validateDtvfwminForArrayConstraintsFromSetDtvfwmin($dtvfwmin))) {
            throw new \InvalidArgumentException($dtvfwminArrayErrorMessage, __LINE__);
        }
        $this->dtvfwmin = $dtvfwmin;
        return $this;
    }
    /**
     * Add item to dtvfwmin value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToDtvfwmin($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The dtvfwmin property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtvfwmin[] = $item;
        return $this;
    }
    /**
     * Get dtvfwmax value
     * @return int[]|null
     */
    public function getDtvfwmax()
    {
        return $this->dtvfwmax;
    }
    /**
     * This method is responsible for validating the values passed to the setDtvfwmax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtvfwmax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtvfwmaxForArrayConstraintsFromSetDtvfwmax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausDtvfwmaxItem) {
            // validation for constraint: itemType
            if (!(is_int($hausDtvfwmaxItem) || ctype_digit($hausDtvfwmaxItem))) {
                $invalidValues[] = is_object($hausDtvfwmaxItem) ? get_class($hausDtvfwmaxItem) : sprintf('%s(%s)', gettype($hausDtvfwmaxItem), var_export($hausDtvfwmaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtvfwmax property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtvfwmax value
     * @throws \InvalidArgumentException
     * @param int[] $dtvfwmax
     * @return \StructType\Haus
     */
    public function setDtvfwmax(array $dtvfwmax = array())
    {
        // validation for constraint: array
        if ('' !== ($dtvfwmaxArrayErrorMessage = self::validateDtvfwmaxForArrayConstraintsFromSetDtvfwmax($dtvfwmax))) {
            throw new \InvalidArgumentException($dtvfwmaxArrayErrorMessage, __LINE__);
        }
        $this->dtvfwmax = $dtvfwmax;
        return $this;
    }
    /**
     * Add item to dtvfwmax value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Haus
     */
    public function addToDtvfwmax($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The dtvfwmax property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtvfwmax[] = $item;
        return $this;
    }
    /**
     * Get sortierbegriff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSortierbegriff()
    {
        return isset($this->sortierbegriff) ? $this->sortierbegriff : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSortierbegriff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSortierbegriff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSortierbegriffForArrayConstraintsFromSetSortierbegriff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausSortierbegriffItem) {
            // validation for constraint: itemType
            if (!is_string($hausSortierbegriffItem)) {
                $invalidValues[] = is_object($hausSortierbegriffItem) ? get_class($hausSortierbegriffItem) : sprintf('%s(%s)', gettype($hausSortierbegriffItem), var_export($hausSortierbegriffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sortierbegriff property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sortierbegriff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $sortierbegriff
     * @return \StructType\Haus
     */
    public function setSortierbegriff(array $sortierbegriff = array())
    {
        // validation for constraint: array
        if ('' !== ($sortierbegriffArrayErrorMessage = self::validateSortierbegriffForArrayConstraintsFromSetSortierbegriff($sortierbegriff))) {
            throw new \InvalidArgumentException($sortierbegriffArrayErrorMessage, __LINE__);
        }
        if (is_null($sortierbegriff) || (is_array($sortierbegriff) && empty($sortierbegriff))) {
            unset($this->sortierbegriff);
        } else {
            $this->sortierbegriff = $sortierbegriff;
        }
        return $this;
    }
    /**
     * Add item to sortierbegriff value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Haus
     */
    public function addToSortierbegriff($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sortierbegriff property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sortierbegriff[] = $item;
        return $this;
    }
    /**
     * Get plankoord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPlankoord()
    {
        return isset($this->plankoord) ? $this->plankoord : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlankoord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlankoord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlankoordForArrayConstraintsFromSetPlankoord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausPlankoordItem) {
            // validation for constraint: itemType
            if (!is_string($hausPlankoordItem)) {
                $invalidValues[] = is_object($hausPlankoordItem) ? get_class($hausPlankoordItem) : sprintf('%s(%s)', gettype($hausPlankoordItem), var_export($hausPlankoordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plankoord property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plankoord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $plankoord
     * @return \StructType\Haus
     */
    public function setPlankoord(array $plankoord = array())
    {
        // validation for constraint: array
        if ('' !== ($plankoordArrayErrorMessage = self::validatePlankoordForArrayConstraintsFromSetPlankoord($plankoord))) {
            throw new \InvalidArgumentException($plankoordArrayErrorMessage, __LINE__);
        }
        if (is_null($plankoord) || (is_array($plankoord) && empty($plankoord))) {
            unset($this->plankoord);
        } else {
            $this->plankoord = $plankoord;
        }
        return $this;
    }
    /**
     * Add item to plankoord value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Haus
     */
    public function addToPlankoord($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The plankoord property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plankoord[] = $item;
        return $this;
    }
    /**
     * Get hauspanorama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Panorama[]|null
     */
    public function getHauspanorama()
    {
        return isset($this->hauspanorama) ? $this->hauspanorama : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHauspanorama method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauspanorama method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauspanoramaForArrayConstraintsFromSetHauspanorama(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hausHauspanoramaItem) {
            // validation for constraint: itemType
            if (!$hausHauspanoramaItem instanceof \StructType\Panorama) {
                $invalidValues[] = is_object($hausHauspanoramaItem) ? get_class($hausHauspanoramaItem) : sprintf('%s(%s)', gettype($hausHauspanoramaItem), var_export($hausHauspanoramaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauspanorama property can only contain items of type \StructType\Panorama, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauspanorama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Panorama[] $hauspanorama
     * @return \StructType\Haus
     */
    public function setHauspanorama(array $hauspanorama = array())
    {
        // validation for constraint: array
        if ('' !== ($hauspanoramaArrayErrorMessage = self::validateHauspanoramaForArrayConstraintsFromSetHauspanorama($hauspanorama))) {
            throw new \InvalidArgumentException($hauspanoramaArrayErrorMessage, __LINE__);
        }
        if (is_null($hauspanorama) || (is_array($hauspanorama) && empty($hauspanorama))) {
            unset($this->hauspanorama);
        } else {
            $this->hauspanorama = $hauspanorama;
        }
        return $this;
    }
    /**
     * Add item to hauspanorama value
     * @throws \InvalidArgumentException
     * @param \StructType\Panorama $item
     * @return \StructType\Haus
     */
    public function addToHauspanorama(\StructType\Panorama $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Panorama) {
            throw new \InvalidArgumentException(sprintf('The hauspanorama property can only contain items of type \StructType\Panorama, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauspanorama[] = $item;
        return $this;
    }
}
