<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSaison StructType
 * Meta information extracted from the WSDL
 * - type: tns:getSaison
 * @subpackage Structs
 */
class GetSaison extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Login
     */
    public $login;
    /**
     * The saisonid
     * @var int
     */
    public $saisonid;
    /**
     * Constructor method for getSaison
     * @uses GetSaison::setLogin()
     * @uses GetSaison::setSaisonid()
     * @param \StructType\Login $login
     * @param int $saisonid
     */
    public function __construct(\StructType\Login $login = null, $saisonid = null)
    {
        $this
            ->setLogin($login)
            ->setSaisonid($saisonid);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\GetSaison
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get saisonid value
     * @return int|null
     */
    public function getSaisonid()
    {
        return $this->saisonid;
    }
    /**
     * Set saisonid value
     * @param int $saisonid
     * @return \StructType\GetSaison
     */
    public function setSaisonid($saisonid = null)
    {
        // validation for constraint: int
        if (!is_null($saisonid) && !(is_int($saisonid) || ctype_digit($saisonid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saisonid, true), gettype($saisonid)), __LINE__);
        }
        $this->saisonid = $saisonid;
        return $this;
    }
}
