<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for einstellung StructType
 * @subpackage Structs
 */
class Einstellung extends AbstractStructBase
{
    /**
     * The schluessel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schluessel;
    /**
     * The wert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $wert;
    /**
     * Constructor method for einstellung
     * @uses Einstellung::setSchluessel()
     * @uses Einstellung::setWert()
     * @param string $schluessel
     * @param int $wert
     */
    public function __construct($schluessel = null, $wert = null)
    {
        $this
            ->setSchluessel($schluessel)
            ->setWert($wert);
    }
    /**
     * Get schluessel value
     * @return string|null
     */
    public function getSchluessel()
    {
        return $this->schluessel;
    }
    /**
     * Set schluessel value
     * @param string $schluessel
     * @return \StructType\Einstellung
     */
    public function setSchluessel($schluessel = null)
    {
        // validation for constraint: string
        if (!is_null($schluessel) && !is_string($schluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schluessel, true), gettype($schluessel)), __LINE__);
        }
        $this->schluessel = $schluessel;
        return $this;
    }
    /**
     * Get wert value
     * @return int|null
     */
    public function getWert()
    {
        return $this->wert;
    }
    /**
     * Set wert value
     * @param int $wert
     * @return \StructType\Einstellung
     */
    public function setWert($wert = null)
    {
        // validation for constraint: int
        if (!is_null($wert) && !(is_int($wert) || ctype_digit($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->wert = $wert;
        return $this;
    }
}
