<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eigenschaften StructType
 * @subpackage Structs
 */
class Eigenschaften extends AbstractStructBase
{
    /**
     * The stamm
     * @var string
     */
    public $stamm;
    /**
     * The eigenschaft
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Eigenschaft[]
     */
    public $eigenschaft;
    /**
     * Constructor method for eigenschaften
     * @uses Eigenschaften::setStamm()
     * @uses Eigenschaften::setEigenschaft()
     * @param string $stamm
     * @param \StructType\Eigenschaft[] $eigenschaft
     */
    public function __construct($stamm = null, array $eigenschaft = array())
    {
        $this
            ->setStamm($stamm)
            ->setEigenschaft($eigenschaft);
    }
    /**
     * Get stamm value
     * @return string|null
     */
    public function getStamm()
    {
        return $this->stamm;
    }
    /**
     * Set stamm value
     * @param string $stamm
     * @return \StructType\Eigenschaften
     */
    public function setStamm($stamm = null)
    {
        // validation for constraint: string
        if (!is_null($stamm) && !is_string($stamm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stamm, true), gettype($stamm)), __LINE__);
        }
        $this->stamm = $stamm;
        return $this;
    }
    /**
     * Get eigenschaft value
     * @return \StructType\Eigenschaft[]|null
     */
    public function getEigenschaft()
    {
        return $this->eigenschaft;
    }
    /**
     * This method is responsible for validating the values passed to the setEigenschaft method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigenschaft method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigenschaftForArrayConstraintsFromSetEigenschaft(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eigenschaftenEigenschaftItem) {
            // validation for constraint: itemType
            if (!$eigenschaftenEigenschaftItem instanceof \StructType\Eigenschaft) {
                $invalidValues[] = is_object($eigenschaftenEigenschaftItem) ? get_class($eigenschaftenEigenschaftItem) : sprintf('%s(%s)', gettype($eigenschaftenEigenschaftItem), var_export($eigenschaftenEigenschaftItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eigenschaft property can only contain items of type \StructType\Eigenschaft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eigenschaft value
     * @throws \InvalidArgumentException
     * @param \StructType\Eigenschaft[] $eigenschaft
     * @return \StructType\Eigenschaften
     */
    public function setEigenschaft(array $eigenschaft = array())
    {
        // validation for constraint: array
        if ('' !== ($eigenschaftArrayErrorMessage = self::validateEigenschaftForArrayConstraintsFromSetEigenschaft($eigenschaft))) {
            throw new \InvalidArgumentException($eigenschaftArrayErrorMessage, __LINE__);
        }
        $this->eigenschaft = $eigenschaft;
        return $this;
    }
    /**
     * Add item to eigenschaft value
     * @throws \InvalidArgumentException
     * @param \StructType\Eigenschaft $item
     * @return \StructType\Eigenschaften
     */
    public function addToEigenschaft(\StructType\Eigenschaft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Eigenschaft) {
            throw new \InvalidArgumentException(sprintf('The eigenschaft property can only contain items of type \StructType\Eigenschaft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eigenschaft[] = $item;
        return $this;
    }
}
