<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eigenschaft StructType
 * @subpackage Structs
 */
class Eigenschaft extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * @var string
     */
    public $kurzbezeichnung;
    /**
     * The typ
     * @var int
     */
    public $typ;
    /**
     * Constructor method for eigenschaft
     * @uses Eigenschaft::setId()
     * @uses Eigenschaft::setSprache()
     * @uses Eigenschaft::setBezeichnung()
     * @uses Eigenschaft::setKurzbezeichnung()
     * @uses Eigenschaft::setTyp()
     * @param int $id
     * @param string $sprache
     * @param string $bezeichnung
     * @param string $kurzbezeichnung
     * @param int $typ
     */
    public function __construct($id = null, $sprache = null, $bezeichnung = null, $kurzbezeichnung = null, $typ = null)
    {
        $this
            ->setId($id)
            ->setSprache($sprache)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setTyp($typ);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Eigenschaft
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Eigenschaft
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Eigenschaft
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return string|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * Set kurzbezeichnung value
     * @param string $kurzbezeichnung
     * @return \StructType\Eigenschaft
     */
    public function setKurzbezeichnung($kurzbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($kurzbezeichnung) && !is_string($kurzbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurzbezeichnung, true), gettype($kurzbezeichnung)), __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Get typ value
     * @return int|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param int $typ
     * @return \StructType\Eigenschaft
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: int
        if (!is_null($typ) && !(is_int($typ) || ctype_digit($typ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typ, true), gettype($typ)), __LINE__);
        }
        $this->typ = $typ;
        return $this;
    }
}
