<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for buchbareleistungen StructType
 * @subpackage Structs
 */
class Buchbareleistungen extends AbstractStructBase
{
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The preisErw
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preisErw;
    /**
     * The preisKindB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preisKindB;
    /**
     * The preisKindC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preisKindC;
    /**
     * The preisKindD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preisKindD;
    /**
     * The preisEinzel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preisEinzel;
    /**
     * The proPerson
     * @var int
     */
    public $proPerson;
    /**
     * The proNacht
     * @var int
     */
    public $proNacht;
    /**
     * The gueltigVon
     * @var string
     */
    public $gueltigVon;
    /**
     * The gueltigBis
     * @var string
     */
    public $gueltigBis;
    /**
     * The buchbar
     * @var int
     */
    public $buchbar;
    /**
     * The gesamtpreis
     * @var int
     */
    public $gesamtpreis;
    /**
     * The typid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $typid;
    /**
     * The subtypid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $subtypid;
    /**
     * The subtypbez
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subtypbez;
    /**
     * The mwstsatz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mwstsatz;
    /**
     * Constructor method for buchbareleistungen
     * @uses Buchbareleistungen::setBezeichnung()
     * @uses Buchbareleistungen::setSprache()
     * @uses Buchbareleistungen::setPreisErw()
     * @uses Buchbareleistungen::setPreisKindB()
     * @uses Buchbareleistungen::setPreisKindC()
     * @uses Buchbareleistungen::setPreisKindD()
     * @uses Buchbareleistungen::setPreisEinzel()
     * @uses Buchbareleistungen::setProPerson()
     * @uses Buchbareleistungen::setProNacht()
     * @uses Buchbareleistungen::setGueltigVon()
     * @uses Buchbareleistungen::setGueltigBis()
     * @uses Buchbareleistungen::setBuchbar()
     * @uses Buchbareleistungen::setGesamtpreis()
     * @uses Buchbareleistungen::setTypid()
     * @uses Buchbareleistungen::setSubtypid()
     * @uses Buchbareleistungen::setSubtypbez()
     * @uses Buchbareleistungen::setMwstsatz()
     * @param string $bezeichnung
     * @param string $sprache
     * @param int $preisErw
     * @param int $preisKindB
     * @param int $preisKindC
     * @param int $preisKindD
     * @param int $preisEinzel
     * @param int $proPerson
     * @param int $proNacht
     * @param string $gueltigVon
     * @param string $gueltigBis
     * @param int $buchbar
     * @param int $gesamtpreis
     * @param int $typid
     * @param int $subtypid
     * @param string $subtypbez
     * @param int $mwstsatz
     */
    public function __construct($bezeichnung = null, $sprache = null, $preisErw = null, $preisKindB = null, $preisKindC = null, $preisKindD = null, $preisEinzel = null, $proPerson = null, $proNacht = null, $gueltigVon = null, $gueltigBis = null, $buchbar = null, $gesamtpreis = null, $typid = null, $subtypid = null, $subtypbez = null, $mwstsatz = null)
    {
        $this
            ->setBezeichnung($bezeichnung)
            ->setSprache($sprache)
            ->setPreisErw($preisErw)
            ->setPreisKindB($preisKindB)
            ->setPreisKindC($preisKindC)
            ->setPreisKindD($preisKindD)
            ->setPreisEinzel($preisEinzel)
            ->setProPerson($proPerson)
            ->setProNacht($proNacht)
            ->setGueltigVon($gueltigVon)
            ->setGueltigBis($gueltigBis)
            ->setBuchbar($buchbar)
            ->setGesamtpreis($gesamtpreis)
            ->setTypid($typid)
            ->setSubtypid($subtypid)
            ->setSubtypbez($subtypbez)
            ->setMwstsatz($mwstsatz);
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Buchbareleistungen
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Buchbareleistungen
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get preisErw value
     * @return int|null
     */
    public function getPreisErw()
    {
        return $this->preisErw;
    }
    /**
     * Set preisErw value
     * @param int $preisErw
     * @return \StructType\Buchbareleistungen
     */
    public function setPreisErw($preisErw = null)
    {
        // validation for constraint: int
        if (!is_null($preisErw) && !(is_int($preisErw) || ctype_digit($preisErw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisErw, true), gettype($preisErw)), __LINE__);
        }
        $this->preisErw = $preisErw;
        return $this;
    }
    /**
     * Get preisKindB value
     * @return int|null
     */
    public function getPreisKindB()
    {
        return $this->preisKindB;
    }
    /**
     * Set preisKindB value
     * @param int $preisKindB
     * @return \StructType\Buchbareleistungen
     */
    public function setPreisKindB($preisKindB = null)
    {
        // validation for constraint: int
        if (!is_null($preisKindB) && !(is_int($preisKindB) || ctype_digit($preisKindB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisKindB, true), gettype($preisKindB)), __LINE__);
        }
        $this->preisKindB = $preisKindB;
        return $this;
    }
    /**
     * Get preisKindC value
     * @return int|null
     */
    public function getPreisKindC()
    {
        return $this->preisKindC;
    }
    /**
     * Set preisKindC value
     * @param int $preisKindC
     * @return \StructType\Buchbareleistungen
     */
    public function setPreisKindC($preisKindC = null)
    {
        // validation for constraint: int
        if (!is_null($preisKindC) && !(is_int($preisKindC) || ctype_digit($preisKindC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisKindC, true), gettype($preisKindC)), __LINE__);
        }
        $this->preisKindC = $preisKindC;
        return $this;
    }
    /**
     * Get preisKindD value
     * @return int|null
     */
    public function getPreisKindD()
    {
        return $this->preisKindD;
    }
    /**
     * Set preisKindD value
     * @param int $preisKindD
     * @return \StructType\Buchbareleistungen
     */
    public function setPreisKindD($preisKindD = null)
    {
        // validation for constraint: int
        if (!is_null($preisKindD) && !(is_int($preisKindD) || ctype_digit($preisKindD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisKindD, true), gettype($preisKindD)), __LINE__);
        }
        $this->preisKindD = $preisKindD;
        return $this;
    }
    /**
     * Get preisEinzel value
     * @return int|null
     */
    public function getPreisEinzel()
    {
        return $this->preisEinzel;
    }
    /**
     * Set preisEinzel value
     * @param int $preisEinzel
     * @return \StructType\Buchbareleistungen
     */
    public function setPreisEinzel($preisEinzel = null)
    {
        // validation for constraint: int
        if (!is_null($preisEinzel) && !(is_int($preisEinzel) || ctype_digit($preisEinzel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preisEinzel, true), gettype($preisEinzel)), __LINE__);
        }
        $this->preisEinzel = $preisEinzel;
        return $this;
    }
    /**
     * Get proPerson value
     * @return int|null
     */
    public function getProPerson()
    {
        return $this->proPerson;
    }
    /**
     * Set proPerson value
     * @param int $proPerson
     * @return \StructType\Buchbareleistungen
     */
    public function setProPerson($proPerson = null)
    {
        // validation for constraint: int
        if (!is_null($proPerson) && !(is_int($proPerson) || ctype_digit($proPerson))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($proPerson, true), gettype($proPerson)), __LINE__);
        }
        $this->proPerson = $proPerson;
        return $this;
    }
    /**
     * Get proNacht value
     * @return int|null
     */
    public function getProNacht()
    {
        return $this->proNacht;
    }
    /**
     * Set proNacht value
     * @param int $proNacht
     * @return \StructType\Buchbareleistungen
     */
    public function setProNacht($proNacht = null)
    {
        // validation for constraint: int
        if (!is_null($proNacht) && !(is_int($proNacht) || ctype_digit($proNacht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($proNacht, true), gettype($proNacht)), __LINE__);
        }
        $this->proNacht = $proNacht;
        return $this;
    }
    /**
     * Get gueltigVon value
     * @return string|null
     */
    public function getGueltigVon()
    {
        return $this->gueltigVon;
    }
    /**
     * Set gueltigVon value
     * @param string $gueltigVon
     * @return \StructType\Buchbareleistungen
     */
    public function setGueltigVon($gueltigVon = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigVon) && !is_string($gueltigVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigVon, true), gettype($gueltigVon)), __LINE__);
        }
        $this->gueltigVon = $gueltigVon;
        return $this;
    }
    /**
     * Get gueltigBis value
     * @return string|null
     */
    public function getGueltigBis()
    {
        return $this->gueltigBis;
    }
    /**
     * Set gueltigBis value
     * @param string $gueltigBis
     * @return \StructType\Buchbareleistungen
     */
    public function setGueltigBis($gueltigBis = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigBis) && !is_string($gueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigBis, true), gettype($gueltigBis)), __LINE__);
        }
        $this->gueltigBis = $gueltigBis;
        return $this;
    }
    /**
     * Get buchbar value
     * @return int|null
     */
    public function getBuchbar()
    {
        return $this->buchbar;
    }
    /**
     * Set buchbar value
     * @param int $buchbar
     * @return \StructType\Buchbareleistungen
     */
    public function setBuchbar($buchbar = null)
    {
        // validation for constraint: int
        if (!is_null($buchbar) && !(is_int($buchbar) || ctype_digit($buchbar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buchbar, true), gettype($buchbar)), __LINE__);
        }
        $this->buchbar = $buchbar;
        return $this;
    }
    /**
     * Get gesamtpreis value
     * @return int|null
     */
    public function getGesamtpreis()
    {
        return $this->gesamtpreis;
    }
    /**
     * Set gesamtpreis value
     * @param int $gesamtpreis
     * @return \StructType\Buchbareleistungen
     */
    public function setGesamtpreis($gesamtpreis = null)
    {
        // validation for constraint: int
        if (!is_null($gesamtpreis) && !(is_int($gesamtpreis) || ctype_digit($gesamtpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamtpreis, true), gettype($gesamtpreis)), __LINE__);
        }
        $this->gesamtpreis = $gesamtpreis;
        return $this;
    }
    /**
     * Get typid value
     * @return int|null
     */
    public function getTypid()
    {
        return $this->typid;
    }
    /**
     * Set typid value
     * @param int $typid
     * @return \StructType\Buchbareleistungen
     */
    public function setTypid($typid = null)
    {
        // validation for constraint: int
        if (!is_null($typid) && !(is_int($typid) || ctype_digit($typid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typid, true), gettype($typid)), __LINE__);
        }
        $this->typid = $typid;
        return $this;
    }
    /**
     * Get subtypid value
     * @return int|null
     */
    public function getSubtypid()
    {
        return $this->subtypid;
    }
    /**
     * Set subtypid value
     * @param int $subtypid
     * @return \StructType\Buchbareleistungen
     */
    public function setSubtypid($subtypid = null)
    {
        // validation for constraint: int
        if (!is_null($subtypid) && !(is_int($subtypid) || ctype_digit($subtypid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subtypid, true), gettype($subtypid)), __LINE__);
        }
        $this->subtypid = $subtypid;
        return $this;
    }
    /**
     * Get subtypbez value
     * @return string|null
     */
    public function getSubtypbez()
    {
        return $this->subtypbez;
    }
    /**
     * Set subtypbez value
     * @param string $subtypbez
     * @return \StructType\Buchbareleistungen
     */
    public function setSubtypbez($subtypbez = null)
    {
        // validation for constraint: string
        if (!is_null($subtypbez) && !is_string($subtypbez)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtypbez, true), gettype($subtypbez)), __LINE__);
        }
        $this->subtypbez = $subtypbez;
        return $this;
    }
    /**
     * Get mwstsatz value
     * @return int|null
     */
    public function getMwstsatz()
    {
        return $this->mwstsatz;
    }
    /**
     * Set mwstsatz value
     * @param int $mwstsatz
     * @return \StructType\Buchbareleistungen
     */
    public function setMwstsatz($mwstsatz = null)
    {
        // validation for constraint: int
        if (!is_null($mwstsatz) && !(is_int($mwstsatz) || ctype_digit($mwstsatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mwstsatz, true), gettype($mwstsatz)), __LINE__);
        }
        $this->mwstsatz = $mwstsatz;
        return $this;
    }
}
