<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bildklasse StructType
 * @subpackage Structs
 */
class Bildklasse extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * Constructor method for bildklasse
     * @uses Bildklasse::setId()
     * @uses Bildklasse::setBezeichnung()
     * @param int $id
     * @param string $bezeichnung
     */
    public function __construct($id = null, $bezeichnung = null)
    {
        $this
            ->setId($id)
            ->setBezeichnung($bezeichnung);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Bildklasse
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\Bildklasse
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
}
